/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.CompatibilityMode;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.IrFileSerializer;
import org.jetbrains.kotlin.backend.common.serialization.proto.IdSignature;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.jvm.serialization.JvmIrSerializerSessionKt;
import org.jetbrains.kotlin.backend.jvm.serialization.proto.JvmIr;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\n\u0010\u0017\u001a\u00020\u0018*\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer;", "declarationTable", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "mode", "Lorg/jetbrains/kotlin/config/JvmSerializeIrMode;", "fileClassFqName", "Lorg/jetbrains/kotlin/name/FqName;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;Lorg/jetbrains/kotlin/config/JvmSerializeIrMode;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "serializeJvmIrFile", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$ClassOrFile;", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "serializeTopLevelClass", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "serializeAuxTables", "", "proto", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$ClassOrFile$Builder;", "toProto", "Lorg/jetbrains/kotlin/backend/jvm/serialization/proto/JvmIr$XStatementOrExpression;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrFileSerializer$XStatementOrExpression;", "ir.serialization.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmIrSerializerSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmIrSerializerSession.kt\norg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1863#2,2:127\n1863#2,2:129\n1863#2,2:131\n1863#2,2:133\n1863#2,2:135\n774#2:137\n865#2,2:138\n1863#2,2:140\n*S KotlinDebug\n*F\n+ 1 JvmIrSerializerSession.kt\norg/jetbrains/kotlin/backend/jvm/serialization/JvmIrSerializerSession\n*L\n72#1:127,2\n73#1:129,2\n74#1:131,2\n75#1:133,2\n76#1:135,2\n43#1:137\n43#1:138,2\n43#1:140,2\n*E\n"})
public final class JvmIrSerializerSession
extends IrFileSerializer {
    @NotNull
    private final DeclarationTable declarationTable;
    @NotNull
    private final JvmSerializeIrMode mode;
    @NotNull
    private final FqName fileClassFqName;

    public JvmIrSerializerSession(@NotNull DeclarationTable declarationTable, @NotNull JvmSerializeIrMode mode, @NotNull FqName fileClassFqName, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Intrinsics.checkNotNullParameter(declarationTable, "declarationTable");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        Intrinsics.checkNotNullParameter(fileClassFqName, "fileClassFqName");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        super(declarationTable, CompatibilityMode.Companion.getCURRENT(), languageVersionSettings, mode == JvmSerializeIrMode.INLINE, false, false, CollectionsKt.emptyList(), 32, null);
        this.declarationTable = declarationTable;
        this.mode = mode;
        this.fileClassFqName = fileClassFqName;
        boolean bl2 = bl = this.mode != JvmSerializeIrMode.NONE;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @Nullable
    public final JvmIr.ClassOrFile serializeJvmIrFile(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        Ref.BooleanRef anySaved = new Ref.BooleanRef();
        JvmIr.ClassOrFile.Builder proto = JvmIr.ClassOrFile.newBuilder();
        this.declarationTable.inFile(irFile, () -> JvmIrSerializerSession.serializeJvmIrFile$lambda$3(irFile, this, proto, anySaved));
        if (!anySaved.element) {
            return null;
        }
        Intrinsics.checkNotNull(proto);
        this.serializeAuxTables(proto);
        proto.setFileFacadeFqName(this.fileClassFqName.asString());
        return proto.build();
    }

    @Nullable
    public final JvmIr.ClassOrFile serializeTopLevelClass(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        JvmIr.ClassOrFile.Builder proto = JvmIr.ClassOrFile.newBuilder();
        IrDeclarationParent irDeclarationParent = irClass.getParent();
        Intrinsics.checkNotNull(irDeclarationParent, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
        this.declarationTable.inFile((IrFile)irDeclarationParent, () -> JvmIrSerializerSession.serializeTopLevelClass$lambda$5(irClass, this, proto));
        Intrinsics.checkNotNull(proto);
        this.serializeAuxTables(proto);
        proto.setFileFacadeFqName(this.fileClassFqName.asString());
        return proto.build();
    }

    private final void serializeAuxTables(JvmIr.ClassOrFile.Builder proto) {
        Object p0;
        Iterable $this$forEach$iv = this.getProtoTypeArray();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (IrType)element$iv;
            boolean bl = false;
            proto.addType((IrType)p0);
        }
        $this$forEach$iv = this.getProtoIdSignatureArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (IdSignature)element$iv;
            boolean bl = false;
            proto.addSignature((IdSignature)p0);
        }
        $this$forEach$iv = this.getProtoStringArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (String)element$iv;
            boolean bl = false;
            proto.addString((String)p0);
        }
        $this$forEach$iv = this.getProtoBodyArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrFileSerializer.XStatementOrExpression it = (IrFileSerializer.XStatementOrExpression)element$iv;
            boolean bl = false;
            proto.addBody(this.toProto(it));
        }
        $this$forEach$iv = this.getProtoDebugInfoArray();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            p0 = (String)element$iv;
            boolean bl = false;
            proto.addDebugInfo((String)p0);
        }
    }

    @NotNull
    public final JvmIr.XStatementOrExpression toProto(@NotNull IrFileSerializer.XStatementOrExpression $this$toProto) {
        JvmIr.XStatementOrExpression xStatementOrExpression;
        Intrinsics.checkNotNullParameter($this$toProto, "<this>");
        IrFileSerializer.XStatementOrExpression xStatementOrExpression2 = $this$toProto;
        if (xStatementOrExpression2 instanceof IrFileSerializer.XStatementOrExpression.XStatement) {
            JvmIr.XStatementOrExpression xStatementOrExpression3 = JvmIr.XStatementOrExpression.newBuilder().setStatement(((IrFileSerializer.XStatementOrExpression.XStatement)$this$toProto).toProtoStatement()).build();
            xStatementOrExpression = xStatementOrExpression3;
            Intrinsics.checkNotNullExpressionValue(xStatementOrExpression3, "build(...)");
        } else if (xStatementOrExpression2 instanceof IrFileSerializer.XStatementOrExpression.XExpression) {
            JvmIr.XStatementOrExpression xStatementOrExpression4 = JvmIr.XStatementOrExpression.newBuilder().setExpression(((IrFileSerializer.XStatementOrExpression.XExpression)$this$toProto).toProtoExpression()).build();
            xStatementOrExpression = xStatementOrExpression4;
            Intrinsics.checkNotNullExpressionValue(xStatementOrExpression4, "build(...)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return xStatementOrExpression;
    }

    private static final Unit serializeJvmIrFile$lambda$3$lambda$2$lambda$1(JvmIr.ClassOrFile.Builder $proto, JvmIrSerializerSession this$0, Ref.BooleanRef $anySaved, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        $proto.addDeclaration(this$0.serializeDeclaration(declaration));
        $anySaved.element = true;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit serializeJvmIrFile$lambda$3(IrFile $irFile, JvmIrSerializerSession this$0, JvmIr.ClassOrFile.Builder $proto, Ref.BooleanRef $anySaved) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $irFile.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrDeclaration it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof IrClass))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration topDeclaration = (IrDeclaration)element$iv;
            boolean bl = false;
            JvmIrSerializerSessionKt.access$forEveryDeclarationToSerialize(topDeclaration, this$0.mode, arg_0 -> JvmIrSerializerSession.serializeJvmIrFile$lambda$3$lambda$2$lambda$1($proto, this$0, $anySaved, arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final Unit serializeTopLevelClass$lambda$5$lambda$4(JvmIr.ClassOrFile.Builder $proto, JvmIrSerializerSession this$0, IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        $proto.addDeclaration(this$0.serializeDeclaration(declaration));
        return Unit.INSTANCE;
    }

    private static final Unit serializeTopLevelClass$lambda$5(IrClass $irClass, JvmIrSerializerSession this$0, JvmIr.ClassOrFile.Builder $proto) {
        JvmIrSerializerSessionKt.access$forEveryDeclarationToSerialize($irClass, this$0.mode, arg_0 -> JvmIrSerializerSession.serializeTopLevelClass$lambda$5$lambda$4($proto, this$0, arg_0));
        return Unit.INSTANCE;
    }
}

