/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.vcs.VcsException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.annotate.AnnotateClient;
import org.jetbrains.idea.svn.annotate.AnnotationConsumer;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.diff.DiffOptions;

public class CmdAnnotateClient
extends BaseSvnClient
implements AnnotateClient {
    @Override
    public void annotate(@NotNull Target target, @NotNull Revision startRevision, @NotNull Revision endRevision, boolean includeMergedRevisions, @Nullable DiffOptions diffOptions, @Nullable AnnotationConsumer handler) throws VcsException {
        if (target == null) {
            CmdAnnotateClient.$$$reportNull$$$0(0);
        }
        if (startRevision == null) {
            CmdAnnotateClient.$$$reportNull$$$0(1);
        }
        if (endRevision == null) {
            CmdAnnotateClient.$$$reportNull$$$0(2);
        }
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        CommandUtil.put(parameters, startRevision, endRevision);
        CommandUtil.put(parameters, includeMergedRevisions, "--use-merge-history");
        CommandUtil.put(parameters, diffOptions);
        parameters.add("--xml");
        CommandExecutor command = this.execute(this.myVcs, target, SvnCommandName.blame, parameters, null);
        this.parseOutput(command.getOutput(), handler);
    }

    public void parseOutput(@NotNull String output, @Nullable AnnotationConsumer handler) throws VcsException {
        if (output == null) {
            CmdAnnotateClient.$$$reportNull$$$0(3);
        }
        try {
            BlameInfo info = CommandUtil.parse(output, BlameInfo.class);
            if (handler != null && info != null && info.target != null && info.target.lineEntries != null) {
                for (LineEntry entry : info.target.lineEntries) {
                    CmdAnnotateClient.invokeHandler(handler, entry);
                }
            }
        }
        catch (JAXBException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private static void invokeHandler(@NotNull AnnotationConsumer handler, @NotNull LineEntry entry) {
        if (handler == null) {
            CmdAnnotateClient.$$$reportNull$$$0(4);
        }
        if (entry == null) {
            CmdAnnotateClient.$$$reportNull$$$0(5);
        }
        if (entry.commit != null) {
            handler.consume(entry.lineNumber - 1, entry.commit.build(), entry.mergedCommit());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endRevision";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/svn/annotate/CmdAnnotateClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "parseOutput";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "invokeHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @XmlRootElement(name="blame")
    public static class BlameInfo {
        @XmlElement(name="target")
        public TargetEntry target;
    }

    public static class TargetEntry {
        @XmlElement(name="entry")
        List<LineEntry> lineEntries;
    }

    public static class LineEntry {
        @XmlAttribute(name="line-number")
        public int lineNumber;
        public CommitInfo.Builder commit;
        @XmlElement(name="merged")
        public MergedEntry merged;

        @Nullable
        public CommitInfo mergedCommit() {
            return this.merged != null && this.merged.commit != null ? this.merged.commit.build() : null;
        }
    }

    public static class MergedEntry {
        @XmlAttribute(name="path")
        public String path;
        public CommitInfo.Builder commit;
    }
}

