/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.codeInspection.groovy;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.codeInspection.GradleInspectionBundle;
import org.jetbrains.plugins.gradle.codeInspection.fix.GradleTaskToRegisterFix;
import org.jetbrains.plugins.gradle.codeInspection.fix.GradleWithTypeFix;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.groovy.intentions.GrReplaceMethodCallQuickFix;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0001H\u0002\u001a \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0010"}, d2={"lazyApiAvailable", "", "call", "Lcom/intellij/psi/PsiElement;", "processNamedDomainObjectCollection", "", "method", "Lcom/intellij/psi/PsiMethod;", "elementToHighlight", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "processProject", "isReturnTypeValueUsed", "processDomainObjectCollection", "processTaskContainer", "processTaskCollection", "intellij.gradle.java"})
public final class GroovyConfigurationAvoidanceVisitorKt {
    private static final boolean lazyApiAvailable(PsiElement call) {
        String string = UtilKt.getLinkedGradleProjectPath(call);
        if (string == null) {
            return false;
        }
        String linkedProjectPath = string;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)GradleSettings.getInstance((Project)call.getProject()).getLinkedProjectSettings(linkedProjectPath);
        if (gradleProjectSettings == null || (gradleProjectSettings = gradleProjectSettings.resolveGradleVersion()) == null) {
            return false;
        }
        GradleProjectSettings gradleVersion = gradleProjectSettings;
        return GradleVersionUtil.isGradleAtLeast((GradleVersion)gradleVersion, (String)"4.9");
    }

    private static final void processNamedDomainObjectCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"findByName")) {
            Object[] objectArray = new Object[]{"named"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final void processProject(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"task")) {
            Object[] objectArray;
            Object[] objectArray2;
            if (!isReturnTypeValueUsed) {
                objectArray2 = new GradleTaskToRegisterFix[]{new GradleTaskToRegisterFix()};
                objectArray = objectArray2;
            } else {
                objectArray = new GradleTaskToRegisterFix[]{};
            }
            GradleTaskToRegisterFix[] fixes = objectArray;
            objectArray2 = new Object[]{"tasks.register"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
        }
    }

    private static final void processDomainObjectCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"all") || Intrinsics.areEqual((Object)method.getName(), (Object)"whenObjectAdded") || Intrinsics.areEqual((Object)method.getName(), (Object)"each")) {
            Object[] objectArray = new Object[]{"configureEach"};
            String string = GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray);
            objectArray = new LocalQuickFix[1];
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            objectArray[0] = new GrReplaceMethodCallQuickFix(string2, "configureEach");
            holder.registerProblem(elementToHighlight, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        } else if (Intrinsics.areEqual((Object)method.getName(), (Object)"withType") && method.getParameters().length > 1) {
            Object[] objectArray = new Object[]{"withType(...).configureEach"};
            String string = GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray);
            objectArray = new LocalQuickFix[]{new GradleWithTypeFix()};
            holder.registerProblem(elementToHighlight, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        } else if (Intrinsics.areEqual((Object)method.getName(), (Object)"getByName") || Intrinsics.areEqual((Object)method.getName(), (Object)"getAt")) {
            Object[] objectArray = new Object[]{"named"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final void processTaskContainer(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"create")) {
            Object[] objectArray;
            Object[] objectArray2;
            if (!isReturnTypeValueUsed) {
                objectArray2 = new GrReplaceMethodCallQuickFix[1];
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                objectArray2[0] = new GrReplaceMethodCallQuickFix(string, "register");
                objectArray = objectArray2;
            } else {
                objectArray = new GrReplaceMethodCallQuickFix[]{};
            }
            GrReplaceMethodCallQuickFix[] fixes = objectArray;
            objectArray2 = new Object[]{"register"};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
        }
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"getByPath") || Intrinsics.areEqual((Object)method.getName(), (Object)"findByPath")) {
            Object[] objectArray = new Object[]{method.getName()};
            holder.registerProblem(elementToHighlight, GradleInspectionBundle.message("inspection.message.0.requires.ordering", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final void processTaskCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        if (Intrinsics.areEqual((Object)method.getName(), (Object)"whenTaskAdded")) {
            Object[] objectArray = new Object[]{"configureEach"};
            String string = GradleInspectionBundle.message("inspection.message.consider.using.0.to.utilize.lazy.behavior", objectArray);
            objectArray = new LocalQuickFix[1];
            String string2 = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            objectArray[0] = new GrReplaceMethodCallQuickFix(string2, "configureEach");
            holder.registerProblem(elementToHighlight, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])objectArray);
        }
    }

    public static final /* synthetic */ boolean access$lazyApiAvailable(PsiElement call) {
        return GroovyConfigurationAvoidanceVisitorKt.lazyApiAvailable(call);
    }

    public static final /* synthetic */ void access$processTaskContainer(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        GroovyConfigurationAvoidanceVisitorKt.processTaskContainer(method, elementToHighlight, holder, isReturnTypeValueUsed);
    }

    public static final /* synthetic */ void access$processDomainObjectCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        GroovyConfigurationAvoidanceVisitorKt.processDomainObjectCollection(method, elementToHighlight, holder);
    }

    public static final /* synthetic */ void access$processProject(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder, boolean isReturnTypeValueUsed) {
        GroovyConfigurationAvoidanceVisitorKt.processProject(method, elementToHighlight, holder, isReturnTypeValueUsed);
    }

    public static final /* synthetic */ void access$processNamedDomainObjectCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        GroovyConfigurationAvoidanceVisitorKt.processNamedDomainObjectCollection(method, elementToHighlight, holder);
    }

    public static final /* synthetic */ void access$processTaskCollection(PsiMethod method, PsiElement elementToHighlight, ProblemsHolder holder) {
        GroovyConfigurationAvoidanceVisitorKt.processTaskCollection(method, elementToHighlight, holder);
    }
}

