/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.sources;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\f\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0007\u001a\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ANDROID_LIBRARY_SUFFIX", "", "getArtifactCoordinates", "Lcom/intellij/openapi/roots/LibraryOrderEntry;", "parseArtifactCoordinates", "artifactCoordinates", "artifactIdChecker", "Ljava/util/function/Predicate;", "getLibraryUnifiedCoordinates", "Lcom/intellij/buildsystem/model/unified/UnifiedCoordinates;", "sourceArtifactNotation", "isArtifactId", "", "artifactIdCandidate", "libraryOrderEntry", "intellij.gradle.java"})
@JvmName(name="ArtifactCoordinatesUtil")
@SourceDebugExtension(value={"SMAP\nartifactCoordinatesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 artifactCoordinatesUtil.kt\norg/jetbrains/plugins/gradle/service/sources/ArtifactCoordinatesUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,47:1\n1#2:48\n12567#3,2:49\n*S KotlinDebug\n*F\n+ 1 artifactCoordinatesUtil.kt\norg/jetbrains/plugins/gradle/service/sources/ArtifactCoordinatesUtil\n*L\n45#1:49,2\n*E\n"})
public final class ArtifactCoordinatesUtil {
    @NotNull
    private static final String ANDROID_LIBRARY_SUFFIX = "@aar";

    @Nullable
    public static final String getArtifactCoordinates(@NotNull LibraryOrderEntry $this$getArtifactCoordinates) {
        Intrinsics.checkNotNullParameter((Object)$this$getArtifactCoordinates, (String)"<this>");
        String string = $this$getArtifactCoordinates.getLibraryName();
        if (string == null) {
            return null;
        }
        String libraryName = string;
        String artifactCoordinates = StringsKt.removePrefix((String)libraryName, (CharSequence)(GradleConstants.SYSTEM_ID.getReadableName() + ": "));
        if (Intrinsics.areEqual((Object)libraryName, (Object)artifactCoordinates)) {
            return null;
        }
        return ArtifactCoordinatesUtil.parseArtifactCoordinates(artifactCoordinates, arg_0 -> ArtifactCoordinatesUtil.getArtifactCoordinates$lambda$0($this$getArtifactCoordinates, arg_0));
    }

    @VisibleForTesting
    @NotNull
    public static final String parseArtifactCoordinates(@NotNull String artifactCoordinates, @NotNull Predicate<String> artifactIdChecker) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinates, (String)"artifactCoordinates");
        Intrinsics.checkNotNullParameter(artifactIdChecker, (String)"artifactIdChecker");
        String[] stringArray = new String[]{":"};
        List it = StringsKt.split$default((CharSequence)artifactCoordinates, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        String rawCoordinates = it.size() == 4 && artifactIdChecker.test((String)it.get(1)) ? it.get(0) + ":" + it.get(1) + ":" + it.get(3) : (it.size() == 5 ? it.get(0) + ":" + it.get(1) + ":" + it.get(4) : artifactCoordinates);
        return StringsKt.removeSuffix((String)rawCoordinates, (CharSequence)ANDROID_LIBRARY_SUFFIX);
    }

    @Nullable
    public static final UnifiedCoordinates getLibraryUnifiedCoordinates(@NotNull String sourceArtifactNotation) {
        Intrinsics.checkNotNullParameter((Object)sourceArtifactNotation, (String)"sourceArtifactNotation");
        String[] stringArray = new String[]{":"};
        List it = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)sourceArtifactNotation, (String)ANDROID_LIBRARY_SUFFIX, (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        return it.size() < 3 ? null : new UnifiedCoordinates((String)it.get(0), (String)it.get(1), (String)it.get(2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isArtifactId(String artifactIdCandidate, LibraryOrderEntry libraryOrderEntry) {
        VirtualFile[] virtualFileArray = libraryOrderEntry.getRootFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getRootFiles(...)");
        VirtualFile[] rootFiles = virtualFileArray;
        if (rootFiles.length == 0) return true;
        VirtualFile[] $this$any$iv = rootFiles;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            VirtualFile element$iv;
            VirtualFile file = element$iv = $this$any$iv[n];
            boolean bl = false;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (StringsKt.startsWith$default((String)string, (String)artifactIdCandidate, (boolean)false, (int)2, null)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static final boolean getArtifactCoordinates$lambda$0(LibraryOrderEntry $this_getArtifactCoordinates, String idCandidate) {
        Intrinsics.checkNotNullParameter((Object)idCandidate, (String)"idCandidate");
        return ArtifactCoordinatesUtil.isArtifactId(idCandidate, $this_getArtifactCoordinates);
    }
}

