/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Color;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleConsoleFilter
implements Filter {
    public static final Pattern LINE_AND_COLUMN_PATTERN = Pattern.compile("line (\\d+), column (\\d+)\\.");
    @Nullable
    private final Project myProject;
    private static final TextAttributes HYPERLINK_ATTRIBUTES = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(CodeInsightColors.HYPERLINK_ATTRIBUTES);
    private String myFilteredFileName;
    private int myFilteredLineNumber;

    public GradleConsoleFilter(@Nullable Project project2) {
        this.myProject = project2;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        int lineNumber;
        String fileName;
        if (line == null) {
            GradleConsoleFilter.$$$reportNull$$$0(0);
        }
        String[] filePrefixes = new String[]{"Build file '", "build file '", "Settings file '", "settings file '"};
        String[] linePrefixes = new String[]{"' line: ", "': ", "' line: ", "': "};
        String filePrefix = null;
        String linePrefix = null;
        for (int i = 0; i < filePrefixes.length; ++i) {
            int filePrefixIndex = StringUtil.indexOf((CharSequence)line, (CharSequence)filePrefixes[i]);
            if (filePrefixIndex == -1) continue;
            filePrefix = filePrefixes[i];
            linePrefix = linePrefixes[i];
            break;
        }
        if (filePrefix == null) {
            return null;
        }
        int filePrefixIndex = StringUtil.indexOf((CharSequence)line, filePrefix);
        String fileAndLineNumber = line.substring(filePrefix.length() + filePrefixIndex);
        int linePrefixIndex = StringUtil.indexOf((CharSequence)fileAndLineNumber, linePrefix);
        if (linePrefixIndex == -1) {
            return null;
        }
        this.myFilteredFileName = fileName = fileAndLineNumber.substring(0, linePrefixIndex);
        String lineNumberStr = fileAndLineNumber.substring(linePrefixIndex + linePrefix.length()).trim();
        int lineNumberEndIndex = 0;
        int i = 0;
        while (i < lineNumberStr.length() && Character.isDigit(lineNumberStr.charAt(i))) {
            lineNumberEndIndex = i++;
        }
        if (lineNumberStr.isEmpty()) {
            return null;
        }
        lineNumberStr = lineNumberStr.substring(0, lineNumberEndIndex + 1);
        try {
            this.myFilteredLineNumber = lineNumber = Integer.parseInt(lineNumberStr);
        }
        catch (NumberFormatException e) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(fileName.replace(File.separatorChar, '/'));
        if (file == null) {
            return null;
        }
        int textStartOffset = entireLength - line.length() + filePrefix.length() + filePrefixIndex;
        int highlightEndOffset = textStartOffset + fileName.length();
        OpenFileHyperlinkInfo info = null;
        if (this.myProject != null) {
            Matcher matcher;
            int columnNumber = 0;
            String lineAndColumn = StringUtil.substringAfterLast((String)line, (String)" @ ");
            if (lineAndColumn != null && (matcher = LINE_AND_COLUMN_PATTERN.matcher(lineAndColumn)).find()) {
                columnNumber = Integer.parseInt(matcher.group(2));
            }
            info = new OpenFileHyperlinkInfo(this.myProject, file, Math.max(lineNumber - 1, 0), columnNumber);
        }
        TextAttributes attributes = HYPERLINK_ATTRIBUTES.clone();
        if (this.myProject != null && !ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(file)) {
            Color color = NamedColorUtil.getInactiveTextColor();
            attributes.setForegroundColor(color);
            attributes.setEffectColor(color);
        }
        return new Filter.Result(textStartOffset, highlightEndOffset, info, attributes);
    }

    public String getFilteredFileName() {
        return this.myFilteredFileName;
    }

    public int getFilteredLineNumber() {
        return this.myFilteredLineNumber;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/jetbrains/plugins/gradle/execution/GradleConsoleFilter", "applyFilter"));
    }
}

