/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VfsUtilCore;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataCache;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleOrderEnumeratorHandler
extends OrderEnumerationHandler {
    private static final Logger LOG = Logger.getInstance(GradleOrderEnumeratorHandler.class);
    private final boolean myResolveModulePerSourceSet;

    public GradleOrderEnumeratorHandler(@NotNull Module module) {
        GradleProjectSettings settings;
        if (module == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(0);
        }
        String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
        this.myResolveModulePerSourceSet = rootProjectPath != null ? (settings = (GradleProjectSettings)GradleSettings.getInstance(module.getProject()).getLinkedProjectSettings(rootProjectPath)) != null && settings.isResolveModulePerSourceSet() : false;
    }

    public boolean shouldAddRuntimeDependenciesToTestCompilationClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldIncludeTestsFromDependentModulesToTestClasspath() {
        return !this.myResolveModulePerSourceSet;
    }

    public boolean shouldProcessDependenciesRecursively() {
        return false;
    }

    public boolean areResourceFilesFromSourceRootsCopiedToOutput() {
        return false;
    }

    public boolean addCustomModuleRoots(@NotNull OrderRootType type, @NotNull ModuleRootModel rootModel, @NotNull Collection<String> result, boolean includeProduction, boolean includeTests) {
        if (type == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(1);
        }
        if (rootModel == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(2);
        }
        if (result == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(3);
        }
        if (!type.equals((Object)OrderRootType.CLASSES)) {
            return false;
        }
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)rootModel.getModule())) {
            return false;
        }
        String gradleProjectPath = ExternalSystemModulePropertyManager.getInstance((Module)rootModel.getModule()).getRootProjectPath();
        if (gradleProjectPath == null) {
            LOG.warn("Root project path of the Gradle project not found for " + String.valueOf(rootModel.getModule()));
            return false;
        }
        Project project2 = rootModel.getModule().getProject();
        ExternalProjectDataCache externalProjectDataCache = ExternalProjectDataCache.getInstance(project2);
        assert (externalProjectDataCache != null);
        ExternalProject externalRootProject = externalProjectDataCache.getRootExternalProject(gradleProjectPath);
        if (externalRootProject == null) {
            LOG.debug("Root external project was not yep imported for the project path: " + gradleProjectPath);
            return false;
        }
        Map<String, ExternalSourceSet> externalSourceSets = externalProjectDataCache.findExternalProject(externalRootProject, rootModel.getModule());
        if (externalSourceSets.isEmpty()) {
            return false;
        }
        boolean isDelegatedBuildEnabled = GradleProjectSettings.isDelegatedBuildEnabled(rootModel.getModule());
        for (ExternalSourceSet sourceSet : externalSourceSets.values()) {
            if (includeTests) {
                if (isDelegatedBuildEnabled) {
                    GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST), result, true);
                }
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.TEST_RESOURCE), result, isDelegatedBuildEnabled);
            }
            if (!includeProduction) continue;
            if (isDelegatedBuildEnabled) {
                GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.SOURCE), result, true);
            }
            GradleOrderEnumeratorHandler.addOutputModuleRoots((ExternalSourceDirectorySet)sourceSet.getSources().get(ExternalSystemSourceType.RESOURCE), result, isDelegatedBuildEnabled);
        }
        return true;
    }

    private static void addOutputModuleRoots(@Nullable ExternalSourceDirectorySet directorySet, @NotNull Collection<? super String> result, boolean isGradleAwareMake) {
        if (result == null) {
            GradleOrderEnumeratorHandler.$$$reportNull$$$0(4);
        }
        if (directorySet == null) {
            return;
        }
        if (isGradleAwareMake) {
            for (File outputDir : directorySet.getGradleOutputDirs()) {
                result.add(VfsUtilCore.pathToUrl((String)outputDir.getPath()));
            }
        } else if (!directorySet.isCompilerOutputPathInherited()) {
            result.add(VfsUtilCore.pathToUrl((String)directorySet.getOutputDir().getPath()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomModuleRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addOutputModuleRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FactoryImpl
    extends OrderEnumerationHandler.Factory {
        private static final ExtensionPointName<FactoryImpl> EP_NAME = ExtensionPointName.create((String)"org.jetbrains.plugins.gradle.orderEnumerationHandlerFactory");

        public boolean isApplicable(@NotNull Module module) {
            if (module == null) {
                FactoryImpl.$$$reportNull$$$0(0);
            }
            return ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module);
        }

        @NotNull
        public GradleOrderEnumeratorHandler createHandler(@NotNull Module module) {
            if (module == null) {
                FactoryImpl.$$$reportNull$$$0(1);
            }
            for (FactoryImpl factory : (FactoryImpl[])EP_NAME.getExtensions()) {
                if (!factory.isApplicable(module)) continue;
                GradleOrderEnumeratorHandler gradleOrderEnumeratorHandler = factory.createHandler(module);
                if (gradleOrderEnumeratorHandler == null) {
                    FactoryImpl.$$$reportNull$$$0(2);
                }
                return gradleOrderEnumeratorHandler;
            }
            return new GradleOrderEnumeratorHandler(module);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler$FactoryImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/execution/GradleOrderEnumeratorHandler$FactoryImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isApplicable";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createHandler";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

