/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.issue;

import com.intellij.build.issue.ConfigurableBuildIssue;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.JavaVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleAddDaemonToolchainCriteriaQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleDownloadToolchainQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleOpenDaemonJvmSettingsQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleRecreateToolchainDownloadUrlsQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleSettingsQuickFix;
import org.jetbrains.plugins.gradle.issue.quickfix.GradleVersionQuickFix;
import org.jetbrains.plugins.gradle.util.GradleBundle;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0005\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/gradle/issue/ConfigurableGradleBuildIssue;", "Lcom/intellij/build/issue/ConfigurableBuildIssue;", "<init>", "()V", "addGradleVersionQuickFix", "", "projectPath", "", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "addGradleJvmQuickFix", "javaVersion", "Lcom/intellij/util/lang/JavaVersion;", "addDaemonToolchainCriteriaQuickFix", "addDownloadToolchainQuickFix", "addRecreateToolchainDownloadUrlsQuickFix", "addOpenDaemonJvmSettingsQuickFix", "intellij.gradle"})
public abstract class ConfigurableGradleBuildIssue
extends ConfigurableBuildIssue {
    public final void addGradleVersionQuickFix(@NotNull String projectPath, @NotNull GradleVersion gradleVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
        GradleVersionQuickFix quickFix = new GradleVersionQuickFix(projectPath, gradleVersion, true);
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference, gradleVersion.getVersion()};
        String string = GradleBundle.message("gradle.build.quick.fix.gradle.version", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    public final void addGradleJvmQuickFix(@NotNull String projectPath, @NotNull JavaVersion javaVersion) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
        if (Intrinsics.areEqual((Object)"AndroidStudio", (Object)PlatformUtils.getPlatformPrefix())) {
            return;
        }
        GradleSettingsQuickFix quickFix = new GradleSettingsQuickFix(projectPath, true, GradleSettingsQuickFix.GradleJvmChangeDetector.INSTANCE, GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference, javaVersion};
        String string = GradleBundle.message("gradle.build.quick.fix.gradle.jvm", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    public final void addDaemonToolchainCriteriaQuickFix(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        GradleAddDaemonToolchainCriteriaQuickFix quickFix = new GradleAddDaemonToolchainCriteriaQuickFix(projectPath);
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference};
        String string = GradleBundle.message("gradle.build.quick.fix.add.toolchain.criteria", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    public final void addDownloadToolchainQuickFix(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        GradleDownloadToolchainQuickFix quickFix = new GradleDownloadToolchainQuickFix(projectPath);
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference};
        String string = GradleBundle.message("gradle.build.quick.fix.install.missing.toolchain", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    public final void addRecreateToolchainDownloadUrlsQuickFix(@NotNull String projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        GradleRecreateToolchainDownloadUrlsQuickFix quickFix = new GradleRecreateToolchainDownloadUrlsQuickFix(projectPath);
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference};
        String string = GradleBundle.message("gradle.build.quick.fix.recreate.download.urls", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }

    public final void addOpenDaemonJvmSettingsQuickFix() {
        GradleOpenDaemonJvmSettingsQuickFix quickFix = GradleOpenDaemonJvmSettingsQuickFix.INSTANCE;
        String hyperlinkReference = this.addQuickFix(quickFix);
        Object[] objectArray = new Object[]{hyperlinkReference};
        String string = GradleBundle.message("gradle.build.quick.fix.modify.gradle.jvm.criteria", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.addQuickFixPrompt(string);
    }
}

