/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution.eel;

import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.eel.EelTargetEnvironmentRequest;
import com.intellij.openapi.externalSystem.service.execution.TargetEnvironmentConfigurationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.eel.fs.EelFileSystemApi;
import com.intellij.platform.eel.fs.EelFileSystemApiKt;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.PathMapper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0017\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/eel/EelTargetEnvironmentConfigurationProvider;", "Lcom/intellij/openapi/externalSystem/service/execution/TargetEnvironmentConfigurationProvider;", "eel", "Lcom/intellij/platform/eel/EelApi;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/eel/EelApi;Lcom/intellij/openapi/project/Project;)V", "getEel", "()Lcom/intellij/platform/eel/EelApi;", "getProject", "()Lcom/intellij/openapi/project/Project;", "environmentConfiguration", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "getEnvironmentConfiguration", "()Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "environmentConfiguration$delegate", "Lkotlin/Lazy;", "pathMapper", "Lcom/intellij/util/PathMapper;", "getPathMapper", "()Lcom/intellij/util/PathMapper;", "pathMapper$delegate", "resolveEnvironmentConfiguration", "EelPathMapper", "intellij.gradle"})
public final class EelTargetEnvironmentConfigurationProvider
implements TargetEnvironmentConfigurationProvider {
    @NotNull
    private final EelApi eel;
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy environmentConfiguration$delegate;
    @NotNull
    private final Lazy pathMapper$delegate;

    public EelTargetEnvironmentConfigurationProvider(@NotNull EelApi eel, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.eel = eel;
        this.project = project2;
        this.environmentConfiguration$delegate = LazyKt.lazy(() -> EelTargetEnvironmentConfigurationProvider.environmentConfiguration_delegate$lambda$0(this));
        this.pathMapper$delegate = LazyKt.lazy(() -> EelTargetEnvironmentConfigurationProvider.pathMapper_delegate$lambda$1(this));
    }

    @NotNull
    public final EelApi getEel() {
        return this.eel;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public TargetEnvironmentConfiguration getEnvironmentConfiguration() {
        Lazy lazy = this.environmentConfiguration$delegate;
        return (TargetEnvironmentConfiguration)lazy.getValue();
    }

    @NotNull
    public PathMapper getPathMapper() {
        Lazy lazy = this.pathMapper$delegate;
        return (PathMapper)lazy.getValue();
    }

    private final TargetEnvironmentConfiguration resolveEnvironmentConfiguration() {
        return (TargetEnvironmentConfiguration)new EelTargetEnvironmentRequest.Configuration(this.eel);
    }

    private static final TargetEnvironmentConfiguration environmentConfiguration_delegate$lambda$0(EelTargetEnvironmentConfigurationProvider this$0) {
        return this$0.resolveEnvironmentConfiguration();
    }

    private static final EelPathMapper pathMapper_delegate$lambda$1(EelTargetEnvironmentConfigurationProvider this$0) {
        return new EelPathMapper(this$0.eel, this$0.project);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001f\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/eel/EelTargetEnvironmentConfigurationProvider$EelPathMapper;", "Lcom/intellij/util/PathMapper;", "eel", "Lcom/intellij/platform/eel/EelApi;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/platform/eel/EelApi;Lcom/intellij/openapi/project/Project;)V", "isEmpty", "", "canReplaceLocal", "localPath", "", "convertToLocal", "remotePath", "canReplaceRemote", "convertToRemote", "", "paths", "", "intellij.gradle"})
    @SourceDebugExtension(value={"SMAP\nEelTargetEnvironmentConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EelTargetEnvironmentConfigurationProvider.kt\norg/jetbrains/plugins/gradle/service/execution/eel/EelTargetEnvironmentConfigurationProvider$EelPathMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,57:1\n1557#2:58\n1628#2,3:59\n*S KotlinDebug\n*F\n+ 1 EelTargetEnvironmentConfigurationProvider.kt\norg/jetbrains/plugins/gradle/service/execution/eel/EelTargetEnvironmentConfigurationProvider$EelPathMapper\n*L\n52#1:58\n52#1:59,3\n*E\n"})
    private static final class EelPathMapper
    implements PathMapper {
        @NotNull
        private final EelApi eel;
        @NotNull
        private final Project project;

        public EelPathMapper(@NotNull EelApi eel, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)eel, (String)"eel");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.eel = eel;
            this.project = project2;
        }

        public boolean isEmpty() {
            return false;
        }

        public boolean canReplaceLocal(@NotNull String localPath) {
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            Path nio = Path.of(localPath, new String[0]);
            Intrinsics.checkNotNull((Object)nio);
            return !Intrinsics.areEqual((Object)EelNioBridgeServiceKt.asEelPath((Path)nio).getDescriptor(), (Object)LocalEelDescriptor.INSTANCE);
        }

        @NotNull
        public String convertToLocal(@NotNull String remotePath) {
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            Path nio = Path.of(remotePath, new String[0]);
            EelFileSystemApi eelFileSystemApi = this.eel.getFs();
            Intrinsics.checkNotNull((Object)nio);
            EelPath eelPath = EelFileSystemApiKt.getPath((EelFileSystemApi)eelFileSystemApi, (String)NioPathUtil.toCanonicalPath((Path)nio));
            Path path = EelNioBridgeServiceKt.asNioPathOrNull((EelPath)eelPath, (Project)this.project);
            Intrinsics.checkNotNull((Object)path);
            return NioPathUtil.toCanonicalPath((Path)path);
        }

        public boolean canReplaceRemote(@NotNull String remotePath) {
            Intrinsics.checkNotNullParameter((Object)remotePath, (String)"remotePath");
            return true;
        }

        @NotNull
        public String convertToRemote(@NotNull String localPath) {
            Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
            Path nioPath = Path.of(localPath, new String[0]);
            Intrinsics.checkNotNull((Object)nioPath);
            return EelNioBridgeServiceKt.asEelPath((Path)nioPath).toString();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public List<String> convertToRemote(@NotNull Collection<String> paths) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable $this$map$iv = paths;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.convertToRemote((String)it));
            }
            return (List)destination$iv$iv;
        }
    }
}

