/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.service.project.GradlePreviewCustomizer;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverUtil;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleModuleDataKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/gradle/service/project/DefaultGradlePreviewCustomizer;", "Lorg/jetbrains/plugins/gradle/service/project/GradlePreviewCustomizer;", "<init>", "()V", "isApplicable", "", "resolverContext", "Lorg/jetbrains/plugins/gradle/service/project/ProjectResolverContext;", "resolvePreviewProjectInfo", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "intellij.gradle"})
public final class DefaultGradlePreviewCustomizer
implements GradlePreviewCustomizer {
    @NotNull
    public static final DefaultGradlePreviewCustomizer INSTANCE = new DefaultGradlePreviewCustomizer();

    private DefaultGradlePreviewCustomizer() {
    }

    @Override
    public boolean isApplicable(@NotNull ProjectResolverContext resolverContext) {
        Intrinsics.checkNotNullParameter((Object)resolverContext, (String)"resolverContext");
        return true;
    }

    @Override
    @NotNull
    public DataNode<ProjectData> resolvePreviewProjectInfo(@NotNull ProjectResolverContext resolverContext) {
        Intrinsics.checkNotNullParameter((Object)resolverContext, (String)"resolverContext");
        String string = resolverContext.getProjectPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProjectPath(...)");
        String projectPath = string;
        String projectName = new File(projectPath).getName();
        String ideProjectPath = resolverContext.getIdeProjectPath();
        String string2 = ideProjectPath;
        if (string2 == null) {
            string2 = projectPath;
        }
        String mainModuleFileDirectoryPath = string2;
        ProjectData projectData = new ProjectData(GradleConstants.SYSTEM_ID, projectName, projectPath, projectPath);
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        ModuleData moduleData = new ModuleData(projectName, GradleConstants.SYSTEM_ID, GradleProjectResolverUtil.getDefaultModuleTypeId(), projectName, mainModuleFileDirectoryPath, projectPath);
        GradleModuleDataKt.setGradleIdentityPath(moduleData, ":");
        projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData).createChild(ProjectKeys.CONTENT_ROOT, (Object)new ContentRootData(GradleConstants.SYSTEM_ID, projectPath));
        return projectDataNode;
    }
}

