/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ui.configuration.SdkComboBox;
import com.intellij.openapi.roots.ui.configuration.SdkComboBoxModel;
import com.intellij.openapi.roots.ui.configuration.SdkLookupProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import one.util.streamex.StreamEx;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleRuntimeTargetUI;
import org.jetbrains.plugins.gradle.execution.target.TargetPathFieldWithBrowseButton;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmCriteria;
import org.jetbrains.plugins.gradle.service.execution.GradleDaemonJvmHelper;
import org.jetbrains.plugins.gradle.service.settings.GradleDaemonJvmCriteriaView;
import org.jetbrains.plugins.gradle.service.settings.GradleDaemonJvmCriteriaViewFactory;
import org.jetbrains.plugins.gradle.service.settings.GradleLocationSettingType;
import org.jetbrains.plugins.gradle.service.settings.GradleProjectSettingsControlBuilder;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.TestRunner;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleJvmComboBoxUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmResolutionUtil;
import org.jetbrains.plugins.gradle.util.GradleJvmUtil;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class IdeaGradleProjectSettingsControlBuilder
implements GradleProjectSettingsControlBuilder {
    private static final Logger LOG = Logger.getInstance(IdeaGradleProjectSettingsControlBuilder.class);
    private static final long BALLOON_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    private static final String HIDDEN_KEY = "hidden";
    @NotNull
    private final GradleProjectSettings myInitialSettings;
    @NotNull
    private final Disposable myDisposable;
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private final Ref<Project> myProjectRef;
    @NotNull
    private final Disposable myProjectRefDisposable;
    private boolean myShowBalloonIfNecessary;
    private boolean dropGradleJdkComponents;
    private boolean dropGradleDaemonJvmCriteriaComponents;
    private boolean dropUseWrapperButton;
    private boolean dropCustomizableWrapperButton;
    private boolean dropUseLocalDistributionButton;
    private boolean dropUseBundledDistributionButton;
    private boolean dropResolveModulePerSourceSetCheckBox;
    private boolean dropResolveExternalAnnotationsCheckBox;
    private boolean dropDelegateBuildCombobox;
    private boolean dropTestRunnerCombobox;
    @Nullable
    private JComboBox<DistributionTypeItem> myGradleDistributionComboBox;
    @Nullable
    private JBLabel myGradleDistributionHint;
    @NotNull
    private GradleLocationSettingType myGradleHomeSettingType;
    @Nullable
    private TargetPathFieldWithBrowseButton myGradleHomePathField;
    @Nullable
    private JPanel myGradlePanel;
    @Nullable
    private SdkComboBox myGradleJdkComboBox;
    @Nullable
    private JPanel myGradleJvmWrapper;
    @Nullable
    private GradleDaemonJvmCriteriaView myGradleDaemonJvmCriteriaView;
    @Nullable
    private JPanel myImportPanel;
    @Nullable
    private JPanel myModulePerSourceSetPanel;
    @Nullable
    private JBCheckBox myResolveModulePerSourceSetCheckBox;
    @Nullable
    private JBCheckBox myResolveExternalAnnotationsCheckBox;
    @Nullable
    private JLabel myDelegateBuildLabel;
    @Nullable
    private ComboBox<BuildRunItem> myDelegateBuildCombobox;
    @Nullable
    private JLabel myTestRunnerLabel;
    @Nullable
    private ComboBox<TestRunnerItem> myTestRunnerCombobox;
    @Nullable
    private JPanel myDelegatePanel;

    public IdeaGradleProjectSettingsControlBuilder(@NotNull GradleProjectSettings initialSettings) {
        if (initialSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(0);
        }
        this.myDisposable = Disposer.newDisposable((String)"IdeaGradleProjectSettingsControlBuilder.myDisposable");
        this.myAlarm = new Alarm(this.myDisposable);
        this.myProjectRef = Ref.create();
        this.myProjectRefDisposable = () -> this.myProjectRef.set(null);
        this.myGradleHomeSettingType = GradleLocationSettingType.UNKNOWN;
        this.myInitialSettings = initialSettings;
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleJdkComponents() {
        this.dropGradleJdkComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropGradleDaemonJvmCriteriaComponents() {
        this.dropGradleDaemonJvmCriteriaComponents = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseWrapperButton() {
        this.dropUseWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropCustomizableWrapperButton() {
        this.dropCustomizableWrapperButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseLocalDistributionButton() {
        this.dropUseLocalDistributionButton = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropUseBundledDistributionButton() {
        this.dropUseBundledDistributionButton = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public IdeaGradleProjectSettingsControlBuilder dropUseAutoImportBox() {
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveModulePerSourceSetCheckBox() {
        this.dropResolveModulePerSourceSetCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropResolveExternalAnnotationsCheckBox() {
        this.dropResolveExternalAnnotationsCheckBox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropDelegateBuildCombobox() {
        this.dropDelegateBuildCombobox = true;
        return this;
    }

    public IdeaGradleProjectSettingsControlBuilder dropTestRunnerCombobox() {
        this.dropTestRunnerCombobox = true;
        return this;
    }

    @Override
    public void showUi(boolean show) {
        ExternalSystemUiUtil.showUi((Object)this, (boolean)show);
        if (show) {
            this.updateDistributionComponents();
            this.updateDeprecatedControls();
        }
    }

    @Override
    @NotNull
    public GradleProjectSettings getInitialSettings() {
        GradleProjectSettings gradleProjectSettings = this.myInitialSettings;
        if (gradleProjectSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(1);
        }
        return gradleProjectSettings;
    }

    @Override
    public void createAndFillControls(PaintAwarePanel content, int indentLevel) {
        content.setPaintCallback(graphics -> this.showBalloonIfNecessary());
        content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"ancestor".equals(evt.getPropertyName())) {
                    return;
                }
                boolean bl = IdeaGradleProjectSettingsControlBuilder.this.myShowBalloonIfNecessary = evt.getNewValue() != null && evt.getOldValue() == null;
                if (evt.getNewValue() == null && evt.getOldValue() != null) {
                    IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                }
            }
        });
        this.addImportComponents(content, indentLevel);
        this.addDelegationComponents(content, indentLevel);
        this.addGradleComponents(content, indentLevel);
    }

    private void addImportComponents(PaintAwarePanel content, int indentLevel) {
        this.myImportPanel = IdeaGradleProjectSettingsControlBuilder.addComponentsGroup(null, content, indentLevel, panel -> {
            if (!this.dropResolveModulePerSourceSetCheckBox) {
                this.myModulePerSourceSetPanel = new JPanel(new GridBagLayout());
                panel.add((Component)this.myModulePerSourceSetPanel, ExternalSystemUiUtil.getFillLineConstraints((int)0).insets(0, 0, 0, 0));
                this.myResolveModulePerSourceSetCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.module.per.source.set", IdeaGradleProjectSettingsControlBuilder.getIDEName()));
                this.myModulePerSourceSetPanel.add((Component)this.myResolveModulePerSourceSetCheckBox, ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
                JBLabel myResolveModulePerSourceSetHintLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.module.per.source.set.hint", new Object[0])), UIUtil.ComponentStyle.SMALL);
                myResolveModulePerSourceSetHintLabel.setIcon(AllIcons.General.BalloonWarning12);
                myResolveModulePerSourceSetHintLabel.setVerticalTextPosition(1);
                myResolveModulePerSourceSetHintLabel.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
                GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
                constraints.insets.top = 0;
                constraints.insets.left += UIUtil.getCheckBoxTextHorizontalOffset((JCheckBox)this.myResolveModulePerSourceSetCheckBox);
                this.myModulePerSourceSetPanel.add((Component)myResolveModulePerSourceSetHintLabel, constraints);
            }
            if (!this.dropResolveExternalAnnotationsCheckBox) {
                this.myResolveExternalAnnotationsCheckBox = new JBCheckBox(GradleBundle.message("gradle.settings.text.download.annotations", new Object[0]));
                panel.add((Component)this.myResolveExternalAnnotationsCheckBox, ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
            }
        });
    }

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi((Object)this);
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private void deduceGradleHomeIfPossible() {
        if (this.myGradleHomePathField == null) {
            return;
        }
        Path gradleHome = GradleInstallationManager.getInstance().getAutodetectedGradleHome((Project)this.myProjectRef.get());
        if (gradleHome == null) {
            new DelayedBalloonInfo(MessageType.WARNING, GradleLocationSettingType.UNKNOWN, BALLOON_DELAY_MILLIS).run();
            return;
        }
        this.myGradleHomeSettingType = GradleLocationSettingType.DEDUCED;
        new DelayedBalloonInfo(MessageType.INFO, GradleLocationSettingType.DEDUCED, BALLOON_DELAY_MILLIS).run();
        this.myGradleHomePathField.setText(gradleHome.toString());
        this.myGradleHomePathField.getTextField().setForeground(GradleLocationSettingType.DEDUCED.getColor());
    }

    private void addGradleComponents(PaintAwarePanel content, int indentLevel) {
        this.myGradlePanel = IdeaGradleProjectSettingsControlBuilder.addComponentsGroup("Gradle", content, indentLevel, panel -> {
            this.addGradleChooserComponents((JPanel)panel, indentLevel + 1);
            if (GradleDaemonJvmHelper.isProjectUsingDaemonJvmCriteria(this.myInitialSettings)) {
                this.addGradleDaemonJvmCriteriaComponents((JPanel)panel, indentLevel + 1);
            } else {
                this.addGradleJdkComponents((JPanel)panel, indentLevel + 1);
            }
        });
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleJdkComponents(JPanel content, int indentLevel) {
        if (!this.dropGradleJdkComponents) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            JBLabel gradleJvmLabel = new JBLabel(GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
            this.myGradleJvmWrapper = new JPanel(new BorderLayout());
            this.recreateGradleJdkComboBox(project2, new ProjectSdksModel());
            gradleJvmLabel.setLabelFor((Component)this.myGradleJvmWrapper);
            content.add((Component)gradleJvmLabel, ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add((Component)this.myGradleJvmWrapper, ExternalSystemUiUtil.getFillLineConstraints((int)0));
        }
        return this;
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleDaemonJvmCriteriaComponents(JPanel content, int indentLevel) {
        if (!this.dropGradleDaemonJvmCriteriaComponents) {
            JBLabel gradleJvmLabel = new JBLabel(GradleBundle.message("gradle.settings.text.daemon.toolchain.component", new Object[0]));
            this.myGradleJvmWrapper = new JPanel(new BorderLayout());
            this.recreateGradleDaemonJvmCriteriaComponent(this.myInitialSettings);
            gradleJvmLabel.setLabelFor((Component)this.myGradleJvmWrapper);
            JBInsets insets = JBUI.insets((int)(5 * indentLevel), (int)(5 + 5 * indentLevel), (int)0, (int)5);
            GridBag gradleJdkLabelConstraint = new GridBag().anchor(18).weightx(0.0).insets((Insets)insets);
            content.add((Component)gradleJvmLabel, gradleJdkLabelConstraint);
            content.add((Component)this.myGradleJvmWrapper, ExternalSystemUiUtil.getFillLineConstraints((int)0));
        }
        return this;
    }

    @Override
    public IdeaGradleProjectSettingsControlBuilder addGradleChooserComponents(JPanel content, int indentLevel) {
        ArrayList<DistributionTypeItem> availableDistributions = new ArrayList<DistributionTypeItem>();
        if (!this.dropUseWrapperButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.DEFAULT_WRAPPED));
        }
        if (!this.dropCustomizableWrapperButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.WRAPPED));
        }
        if (!this.dropUseLocalDistributionButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.LOCAL));
        }
        if (!this.dropUseBundledDistributionButton) {
            availableDistributions.add(new DistributionTypeItem(DistributionType.BUNDLED));
        }
        this.myGradleDistributionComboBox = new ComboBox();
        this.myGradleDistributionComboBox.setRenderer((ListCellRenderer<DistributionTypeItem>)((Object)new MyItemCellRenderer()));
        this.myGradleDistributionHint = new JBLabel();
        this.myGradleHomePathField = new TargetPathFieldWithBrowseButton();
        this.myGradleDistributionHint.setLabelFor((Component)((Object)this.myGradleHomePathField));
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(GradleLocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.getTextField().setForeground(GradleLocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.myGradleDistributionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IdeaGradleProjectSettingsControlBuilder.this.updateDistributionComponents();
            }
        });
        this.myGradleDistributionComboBox.setModel((ComboBoxModel<DistributionTypeItem>)new CollectionComboBoxModel(availableDistributions));
        if (!availableDistributions.isEmpty()) {
            content.add((Component)new JBLabel(GradleBundle.message("gradle.project.settings.distribution", new Object[0])), ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
            content.add(this.myGradleDistributionComboBox, ExternalSystemUiUtil.getLabelConstraints((int)0));
            JPanel additionalControlsPanel = new JPanel(new GridBagLayout());
            additionalControlsPanel.add((Component)this.myGradleDistributionHint);
            additionalControlsPanel.add((Component)((Object)this.myGradleHomePathField), ExternalSystemUiUtil.getFillLineConstraints((int)0));
            content.add((Component)additionalControlsPanel, ExternalSystemUiUtil.getFillLineConstraints((int)0).insets(0, 0, 0, 0));
            boolean macTheme = UIUtil.isUnderDefaultMacTheme();
            this.myGradleDistributionComboBox.setPreferredSize(new Dimension(this.myGradleDistributionComboBox.getPreferredSize().width, this.myGradleHomePathField.getPreferredSize().height + (macTheme ? 3 : 0)));
        }
        return this;
    }

    private void updateDistributionComponents() {
        if (this.myGradleDistributionComboBox == null) {
            return;
        }
        if (this.myGradleHomePathField == null) {
            return;
        }
        boolean localEnabled = this.getSelectedGradleDistribution() == DistributionType.LOCAL;
        boolean wrapperSelected = this.getSelectedGradleDistribution() == DistributionType.DEFAULT_WRAPPED;
        this.myGradleHomePathField.setEnabled(localEnabled);
        this.myGradleHomePathField.setVisible(localEnabled);
        if (this.myGradleDistributionHint != null) {
            this.myGradleDistributionHint.setEnabled(wrapperSelected);
            this.myGradleDistributionHint.setVisible(wrapperSelected);
        }
        if (localEnabled) {
            if (this.myGradleHomePathField.getText().isEmpty()) {
                this.deduceGradleHomeIfPossible();
            } else {
                Project project2 = (Project)this.myProjectRef.get();
                if (GradleInstallationManager.getInstance().isGradleSdkHome(project2, Path.of(this.myGradleHomePathField.getText(), new String[0]))) {
                    this.myGradleHomeSettingType = GradleLocationSettingType.EXPLICIT_CORRECT;
                } else {
                    this.myGradleHomeSettingType = GradleLocationSettingType.EXPLICIT_INCORRECT;
                    this.myShowBalloonIfNecessary = true;
                }
            }
            this.showBalloonIfNecessary();
        } else {
            this.myAlarm.cancelAllRequests();
        }
    }

    @Nullable
    private DistributionType getSelectedGradleDistribution() {
        if (this.myGradleDistributionComboBox == null) {
            return null;
        }
        Object selection = this.myGradleDistributionComboBox.getSelectedItem();
        return selection == null ? null : (DistributionType)((Object)((DistributionTypeItem)selection).value);
    }

    @Override
    public boolean validate(GradleProjectSettings settings) throws ConfigurationException {
        if (this.myGradleJdkComboBox != null && !ApplicationManager.getApplication().isUnitTestMode()) {
            String homePath;
            SdkLookupProvider.SdkInfo sdkInfo2 = this.getSelectedGradleJvmInfo(this.myGradleJdkComboBox);
            if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Undefined) {
                throw new ConfigurationException(GradleBundle.message("gradle.jvm.undefined", new Object[0]));
            }
            if (sdkInfo2 instanceof SdkLookupProvider.SdkInfo.Resolved && !ExternalSystemJdkUtil.isValidJdk((String)(homePath = ((SdkLookupProvider.SdkInfo.Resolved)sdkInfo2).getHomePath()))) {
                throw new ConfigurationException(GradleBundle.message("gradle.jvm.incorrect", homePath));
            }
        }
        if (this.myGradleDaemonJvmCriteriaView != null) {
            this.myGradleDaemonJvmCriteriaView.validateSelection();
        }
        if (this.myGradleHomePathField != null && this.getSelectedGradleDistribution() == DistributionType.LOCAL) {
            String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                this.myGradleHomeSettingType = GradleLocationSettingType.UNKNOWN;
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.empty", gradleHomePath));
            }
            if (!GradleInstallationManager.getInstance().isGradleSdkHome((Project)this.myProjectRef.get(), Path.of(gradleHomePath, new String[0]))) {
                this.myGradleHomeSettingType = GradleLocationSettingType.EXPLICIT_INCORRECT;
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.incorrect", gradleHomePath));
            }
        }
        return true;
    }

    @NotNull
    private SdkLookupProvider getSdkLookupProvider(@NotNull Project project2) {
        if (project2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(2);
        }
        SdkLookupProvider sdkLookupProvider = GradleJvmResolutionUtil.getGradleJvmLookupProvider(project2, this.myInitialSettings);
        if (sdkLookupProvider == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(3);
        }
        return sdkLookupProvider;
    }

    @NotNull
    private SdkLookupProvider.SdkInfo getSelectedGradleJvmInfo(@NotNull SdkComboBox comboBox) {
        if (comboBox == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(4);
        }
        Project project2 = comboBox.getModel().getProject();
        SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(project2);
        String externalProjectPath2 = this.myInitialSettings.getExternalProjectPath();
        Sdk projectSdk = comboBox.getModel().getSdksModel().getProjectSdk();
        String gradleJvm = GradleJvmComboBoxUtil.getSelectedGradleJvmReference(comboBox, sdkLookupProvider);
        SdkLookupProvider.SdkInfo sdkInfo2 = GradleJvmUtil.nonblockingResolveGradleJvmInfo(sdkLookupProvider, project2, projectSdk, externalProjectPath2, gradleJvm);
        if (sdkInfo2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(5);
        }
        return sdkInfo2;
    }

    @Override
    public void apply(GradleProjectSettings settings) {
        Object testRunnerSelectedItem;
        Object delegateBuildSelectedItem;
        Object selected;
        settings.setCompositeBuild(this.myInitialSettings.getCompositeBuild());
        if (this.myGradleHomePathField != null) {
            Path finalGradleHomePath;
            Path gradleHomePath = Path.of(FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText()), new String[0]);
            if (GradleInstallationManager.getInstance().isGradleSdkHome((Project)this.myProjectRef.get(), gradleHomePath)) {
                finalGradleHomePath = gradleHomePath;
            } else {
                finalGradleHomePath = GradleInstallationManager.getInstance().suggestBetterGradleHomePath((Project)this.myProjectRef.get(), gradleHomePath);
                if (finalGradleHomePath != null) {
                    SwingUtilities.invokeLater(() -> this.myGradleHomePathField.setText(finalGradleHomePath.toString()));
                }
            }
            if (finalGradleHomePath == null) {
                settings.setGradleHome(null);
            } else {
                String finalGradleHome = finalGradleHomePath.toString();
                settings.setGradleHome(finalGradleHome);
                GradleUtil.storeLastUsedGradleHome(finalGradleHome);
            }
        }
        if (this.myGradleJdkComboBox != null) {
            IdeaGradleProjectSettingsControlBuilder.wrapExceptions((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> this.myGradleJdkComboBox.getModel().getSdksModel().apply()));
            SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(this.myGradleJdkComboBox.getModel().getProject());
            String gradleJvm = GradleJvmComboBoxUtil.getSelectedGradleJvmReference(this.myGradleJdkComboBox, sdkLookupProvider);
            settings.setGradleJvm(StringUtil.isEmpty((String)gradleJvm) ? null : gradleJvm);
        }
        if (this.myGradleDaemonJvmCriteriaView != null && this.myGradleDaemonJvmCriteriaView.isModified()) {
            this.myGradleDaemonJvmCriteriaView.applySelection();
            this.applyDaemonJvmCriteria((Project)this.myProjectRef.get(), settings.getExternalProjectPath(), this.myGradleDaemonJvmCriteriaView.getInitialCriteria());
        }
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            settings.setResolveModulePerSourceSet(this.myResolveModulePerSourceSetCheckBox.isSelected());
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            settings.setResolveExternalAnnotations(this.myResolveExternalAnnotationsCheckBox.isSelected());
        }
        if (this.myGradleDistributionComboBox != null && (selected = this.myGradleDistributionComboBox.getSelectedItem()) instanceof DistributionTypeItem) {
            settings.setDistributionType((DistributionType)((Object)((DistributionTypeItem)selected).value));
        }
        if (this.myDelegateBuildCombobox != null && (delegateBuildSelectedItem = this.myDelegateBuildCombobox.getSelectedItem()) instanceof BuildRunItem) {
            settings.setDelegatedBuild((Boolean)ObjectUtils.notNull((Object)((Boolean)((BuildRunItem)delegateBuildSelectedItem).value), (Object)true));
        }
        if (this.myTestRunnerCombobox != null && (testRunnerSelectedItem = this.myTestRunnerCombobox.getSelectedItem()) instanceof TestRunnerItem) {
            settings.setTestRunner((TestRunner)((Object)ObjectUtils.notNull((Object)((Object)((TestRunner)((Object)((TestRunnerItem)testRunnerSelectedItem).value))), (Object)((Object)GradleProjectSettings.DEFAULT_TEST_RUNNER))));
        }
    }

    @Override
    public void applyDaemonJvmCriteria(Project project2, String externalProjectPath2, GradleDaemonJvmCriteria daemonJvmCriteria) {
        GradleDaemonJvmHelper.updateProjectDaemonJvmCriteria(project2, externalProjectPath2, daemonJvmCriteria);
    }

    @Override
    public boolean isModified() {
        if (this.myGradleDistributionComboBox != null && this.myGradleDistributionComboBox.getSelectedItem() instanceof DistributionTypeItem && ((DistributionTypeItem)this.myGradleDistributionComboBox.getSelectedItem()).value != this.myInitialSettings.getDistributionType()) {
            return true;
        }
        if (this.myResolveModulePerSourceSetCheckBox != null && this.myResolveModulePerSourceSetCheckBox.isSelected() != this.myInitialSettings.isResolveModulePerSourceSet()) {
            return true;
        }
        if (this.myResolveExternalAnnotationsCheckBox != null && this.myResolveExternalAnnotationsCheckBox.isSelected() != this.myInitialSettings.isResolveExternalAnnotations()) {
            return true;
        }
        if (this.myDelegateBuildCombobox != null && this.myDelegateBuildCombobox.getSelectedItem() instanceof MyItem && !Objects.equals(((MyItem)this.myDelegateBuildCombobox.getSelectedItem()).value, this.myInitialSettings.getDelegatedBuild())) {
            return true;
        }
        if (this.myTestRunnerCombobox != null && this.myTestRunnerCombobox.getSelectedItem() instanceof MyItem && !Objects.equals(((MyItem)this.myTestRunnerCombobox.getSelectedItem()).value, (Object)this.myInitialSettings.getTestRunner())) {
            return true;
        }
        if (this.myGradleJdkComboBox != null) {
            SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(this.myGradleJdkComboBox.getModel().getProject());
            String gradleJvm = GradleJvmComboBoxUtil.getSelectedGradleJvmReference(this.myGradleJdkComboBox, sdkLookupProvider);
            if (!StringUtil.equals((CharSequence)gradleJvm, (CharSequence)this.myInitialSettings.getGradleJvm())) {
                return true;
            }
            if (this.myGradleJdkComboBox.getModel().getSdksModel().isModified()) {
                return true;
            }
        }
        if (this.myGradleDaemonJvmCriteriaView != null && this.myGradleDaemonJvmCriteriaView.isModified()) {
            return true;
        }
        if (this.myGradleHomePathField == null) {
            return false;
        }
        String gradleHome = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (StringUtil.isEmpty((String)gradleHome)) {
            return !StringUtil.isEmpty((String)this.myInitialSettings.getGradleHome());
        }
        return !gradleHome.equals(this.myInitialSettings.getGradleHome());
    }

    @Override
    public void reset(@Nullable Project project2, GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        this.reset(project2, settings, isDefaultModuleCreation, null);
    }

    @Override
    public void reset(@Nullable Project project2, GradleProjectSettings settings, boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        this.updateProjectRef(project2, wizardContext);
        String gradleHome = settings.getGradleHome();
        if (this.myGradleHomePathField != null) {
            GradleRuntimeTargetUI.installActionListener(this.myGradleHomePathField, (Project)this.myProjectRef.get(), GradleBundle.message("gradle.settings.text.home.path", new Object[0]));
            this.myGradleHomePathField.setText(gradleHome == null ? "" : gradleHome);
            this.myGradleHomePathField.getTextField().setForeground(GradleLocationSettingType.EXPLICIT_CORRECT.getColor());
        }
        this.resetImportControls(settings);
        this.resetGradleDaemonJvmCriteriaComponent();
        this.resetGradleJdkComboBox(project2, settings, wizardContext);
        this.resetWrapperControls(settings.getExternalProjectPath(), settings, isDefaultModuleCreation);
        this.resetGradleDelegationControls(wizardContext);
        if (StringUtil.isEmpty((String)gradleHome)) {
            this.myGradleHomeSettingType = GradleLocationSettingType.UNKNOWN;
            this.deduceGradleHomeIfPossible();
        } else {
            Path gradleHomePath = Path.of(gradleHome, new String[0]);
            this.myGradleHomeSettingType = GradleInstallationManager.getInstance().isGradleSdkHome(project2, gradleHomePath) ? GradleLocationSettingType.EXPLICIT_CORRECT : (GradleInstallationManager.getInstance().suggestBetterGradleHomePath(project2, gradleHomePath) != null ? GradleLocationSettingType.EXPLICIT_CORRECT : GradleLocationSettingType.EXPLICIT_INCORRECT);
            this.myAlarm.cancelAllRequests();
            if (this.myGradleHomeSettingType == GradleLocationSettingType.EXPLICIT_INCORRECT && settings.getDistributionType() == DistributionType.LOCAL) {
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
            }
        }
        this.updateDeprecatedControls();
    }

    @Override
    public void update(String linkedProjectPath, GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        this.resetWrapperControls(linkedProjectPath, settings, isDefaultModuleCreation);
        this.resetImportControls(settings);
        this.updateDeprecatedControls();
    }

    private void resetImportControls(GradleProjectSettings settings) {
        if (this.myResolveModulePerSourceSetCheckBox != null) {
            this.myResolveModulePerSourceSetCheckBox.setSelected(settings.isResolveModulePerSourceSet());
            boolean showSetting = !settings.isResolveModulePerSourceSet() || Registry.is((String)"gradle.settings.showDeprecatedSettings", (boolean)false);
            this.myModulePerSourceSetPanel.putClientProperty(HIDDEN_KEY, showSetting);
        }
        if (this.myResolveExternalAnnotationsCheckBox != null) {
            this.myResolveExternalAnnotationsCheckBox.setSelected(settings.isResolveExternalAnnotations());
        }
    }

    private void updateDeprecatedControls() {
        if (this.myModulePerSourceSetPanel != null) {
            this.myModulePerSourceSetPanel.setVisible(this.myModulePerSourceSetPanel.getClientProperty(HIDDEN_KEY) == Boolean.TRUE);
        }
    }

    protected void resetGradleJdkComboBox(@Nullable Project project2, GradleProjectSettings settings, @Nullable WizardContext wizardContext) {
        ProjectSdksModel sdksModel = new ProjectSdksModel();
        this.resetGradleJdkComboBox(project2, settings, wizardContext, sdksModel);
    }

    protected final void resetGradleJdkComboBox(@Nullable Project project2, @NotNull GradleProjectSettings settings, @Nullable WizardContext wizardContext, @NotNull ProjectSdksModel sdksModel) {
        if (settings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(6);
        }
        if (sdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(7);
        }
        if (this.myGradleJdkComboBox == null) {
            return;
        }
        project2 = project2 == null || project2.isDisposed() ? ProjectManager.getInstance().getDefaultProject() : project2;
        Sdk projectSdk = wizardContext != null ? wizardContext.getProjectJdk() : null;
        IdeaGradleProjectSettingsControlBuilder.setupProjectSdksModel(sdksModel, project2, projectSdk);
        this.recreateGradleJdkComboBox(project2, sdksModel);
        SdkLookupProvider sdkLookupProvider = this.getSdkLookupProvider(project2);
        String externalProjectPath2 = this.myInitialSettings.getExternalProjectPath();
        GradleJvmComboBoxUtil.addUsefulGradleJvmReferences(this.myGradleJdkComboBox, externalProjectPath2);
        GradleJvmComboBoxUtil.setSelectedGradleJvmReference(this.myGradleJdkComboBox, sdkLookupProvider, externalProjectPath2, settings.getGradleJvm());
    }

    protected final void resetGradleDaemonJvmCriteriaComponent() {
        if (this.myGradleDaemonJvmCriteriaView == null) {
            return;
        }
        this.myGradleDaemonJvmCriteriaView.resetSelection();
    }

    private void recreateGradleJdkComboBox(@NotNull Project project2, @NotNull ProjectSdksModel sdksModel) {
        if (project2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(8);
        }
        if (sdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(9);
        }
        if (this.myGradleJvmWrapper != null) {
            if (this.myGradleJdkComboBox != null) {
                this.myGradleJvmWrapper.remove((Component)this.myGradleJdkComboBox);
            }
            this.myGradleJdkComboBox = new SdkComboBox(SdkComboBoxModel.createJdkComboBoxModel((Project)project2, (ProjectSdksModel)sdksModel));
            this.myGradleJvmWrapper.add((Component)this.myGradleJdkComboBox, "Center");
        }
    }

    private void recreateGradleDaemonJvmCriteriaComponent(@NotNull GradleProjectSettings gradleProjectSettings) {
        if (gradleProjectSettings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(10);
        }
        if (this.myGradleJvmWrapper != null) {
            if (this.myGradleDaemonJvmCriteriaView != null) {
                this.myGradleJvmWrapper.remove(this.myGradleDaemonJvmCriteriaView);
            }
            Path projectPath = Path.of(gradleProjectSettings.getExternalProjectPath(), new String[0]);
            GradleVersion gradleVersion = gradleProjectSettings.resolveGradleVersion();
            this.myGradleDaemonJvmCriteriaView = GradleDaemonJvmCriteriaViewFactory.createView(projectPath, gradleVersion, this.myDisposable);
            this.myGradleJvmWrapper.add((Component)this.myGradleDaemonJvmCriteriaView, "Center");
        }
    }

    private void resetWrapperControls(String linkedProjectPath, @NotNull GradleProjectSettings settings, boolean isDefaultModuleCreation) {
        if (settings == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(11);
        }
        if (this.myGradleDistributionComboBox == null) {
            return;
        }
        if (isDefaultModuleCreation) {
            DistributionTypeItem toRemove = new DistributionTypeItem(DistributionType.WRAPPED);
            ((CollectionComboBoxModel)this.myGradleDistributionComboBox.getModel()).remove((Object)toRemove);
        }
        if (StringUtil.isEmpty((String)linkedProjectPath) && !isDefaultModuleCreation) {
            this.myGradleDistributionComboBox.setSelectedItem(new DistributionTypeItem(DistributionType.LOCAL));
            return;
        }
        if (this.myGradleDistributionHint != null && !this.dropUseWrapperButton) {
            boolean isGradleDefaultWrapperFilesExist = GradleUtil.isGradleDefaultWrapperFilesExist(linkedProjectPath);
            boolean showError = !isGradleDefaultWrapperFilesExist && !isDefaultModuleCreation;
            this.myGradleDistributionHint.setText(showError ? GradleBundle.message("gradle.settings.wrapper.not.found", new Object[0]) : null);
            this.myGradleDistributionHint.setIcon(showError ? AllIcons.General.Error : null);
        }
        if (settings.getDistributionType() == null) {
            if (this.myGradleDistributionComboBox.getItemCount() > 0) {
                this.myGradleDistributionComboBox.setSelectedIndex(0);
            }
        } else {
            this.myGradleDistributionComboBox.setSelectedItem(new DistributionTypeItem(settings.getDistributionType()));
        }
    }

    private void addDelegationComponents(PaintAwarePanel content, int indentLevel) {
        this.myDelegatePanel = IdeaGradleProjectSettingsControlBuilder.addComponentsGroup(GradleBundle.message("gradle.settings.text.build.run.title", new Object[0]), content, indentLevel, panel -> {
            if (this.dropDelegateBuildCombobox && this.dropTestRunnerCombobox) {
                return;
            }
            JBLabel label = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)GradleBundle.message("gradle.settings.text.build.run.hint", IdeaGradleProjectSettingsControlBuilder.getIDEName())), UIUtil.ComponentStyle.SMALL);
            label.setForeground(UIUtil.getLabelFontColor((UIUtil.FontColor)UIUtil.FontColor.BRIGHTER));
            GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1));
            constraints.insets.bottom = 12;
            panel.add((Component)label, constraints);
            if (!this.dropDelegateBuildCombobox) {
                Object[] states = new BuildRunItem[]{new BuildRunItem(Boolean.TRUE), new BuildRunItem(Boolean.FALSE)};
                this.myDelegateBuildCombobox = new ComboBox(states);
                this.myDelegateBuildCombobox.setRenderer(new MyItemCellRenderer());
                this.myDelegateBuildCombobox.setSelectedItem((Object)new BuildRunItem(this.myInitialSettings.getDelegatedBuild()));
                this.myDelegateBuildLabel = new JBLabel(GradleBundle.message("gradle.settings.text.build.run", new Object[0]));
                panel.add((Component)this.myDelegateBuildLabel, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(indentLevel + 1));
                panel.add((Component)this.myDelegateBuildCombobox, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(0));
                panel.add(Box.createGlue(), ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1)));
                this.myDelegateBuildLabel.setLabelFor((Component)this.myDelegateBuildCombobox);
            }
            if (!this.dropTestRunnerCombobox) {
                Object[] testRunners = (TestRunnerItem[])StreamEx.of((Object[])TestRunner.values()).map(x$0 -> new TestRunnerItem((TestRunner)((Object)((Object)x$0)))).toArray(TestRunnerItem[]::new);
                this.myTestRunnerCombobox = new ComboBox(testRunners);
                this.myTestRunnerCombobox.setRenderer(new MyItemCellRenderer());
                this.myTestRunnerCombobox.setSelectedItem((Object)new TestRunnerItem(this.myInitialSettings.getTestRunner()));
                this.myTestRunnerCombobox.setPrototypeDisplayValue((Object)new TestRunnerItem(TestRunner.CHOOSE_PER_TEST));
                if (this.myDelegateBuildCombobox != null) {
                    this.myDelegateBuildCombobox.setPreferredSize(this.myTestRunnerCombobox.getPreferredSize());
                }
                this.myTestRunnerLabel = new JBLabel(GradleBundle.message("gradle.settings.text.run.tests", new Object[0]));
                panel.add((Component)this.myTestRunnerLabel, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(indentLevel + 1));
                panel.add((Component)this.myTestRunnerCombobox, IdeaGradleProjectSettingsControlBuilder.getLabelConstraints(0));
                panel.add(Box.createGlue(), ExternalSystemUiUtil.getFillLineConstraints((int)(indentLevel + 1)));
                this.myTestRunnerLabel.setLabelFor((Component)this.myTestRunnerCombobox);
            }
        });
    }

    private void resetGradleDelegationControls(@Nullable WizardContext wizardContext) {
        if (wizardContext != null) {
            this.dropTestRunnerCombobox();
            this.dropDelegateBuildCombobox();
            if (this.myDelegatePanel != null) {
                Container parent = this.myDelegatePanel.getParent();
                if (parent != null) {
                    parent.remove(this.myDelegatePanel);
                }
                this.myDelegatePanel = null;
                this.myDelegateBuildCombobox = null;
                this.myTestRunnerCombobox = null;
            }
            return;
        }
        if (this.myDelegateBuildCombobox != null) {
            this.myDelegateBuildCombobox.setSelectedItem((Object)new BuildRunItem(this.myInitialSettings.getDelegatedBuild()));
        }
        if (this.myTestRunnerCombobox != null) {
            this.myTestRunnerCombobox.setSelectedItem((Object)new TestRunnerItem(this.myInitialSettings.getTestRunner()));
        }
    }

    void showBalloonIfNecessary() {
        MessageType messageType;
        if (!this.myShowBalloonIfNecessary || this.myGradleHomePathField != null && !this.myGradleHomePathField.isEnabled()) {
            return;
        }
        this.myShowBalloonIfNecessary = false;
        switch (this.myGradleHomeSettingType) {
            case DEDUCED: {
                MessageType messageType2 = MessageType.INFO;
                break;
            }
            case EXPLICIT_INCORRECT: 
            case UNKNOWN: {
                MessageType messageType2 = MessageType.ERROR;
                break;
            }
            default: {
                MessageType messageType2 = messageType = null;
            }
        }
        if (messageType != null) {
            new DelayedBalloonInfo(messageType, this.myGradleHomeSettingType, BALLOON_DELAY_MILLIS).run();
        }
    }

    private void updateProjectRef(@Nullable Project project2, @Nullable WizardContext wizardContext) {
        if (wizardContext != null && wizardContext.getProject() != null) {
            project2 = wizardContext.getProject();
        }
        if (project2 != null && project2 != this.myProjectRef.get()) {
            Disposer.register((Disposable)project2, (Disposable)this.myProjectRefDisposable);
        }
        this.myProjectRef.set((Object)project2);
    }

    private static JPanel addComponentsGroup(@Nullable @NlsContexts.Separator String title, PaintAwarePanel content, int indentLevel, @NotNull Consumer<JPanel> configuration) {
        if (configuration == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(12);
        }
        JPanel result = new JPanel(new GridBagLayout());
        if (title != null) {
            GridBag constraints = ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel);
            constraints.insets.top = 12;
            result.add((Component)new TitledSeparator(title), constraints);
        }
        int count = result.getComponentCount();
        configuration.accept(result);
        if (result.getComponentCount() > count) {
            content.add((Component)result, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0).insets(0, 0, 0, 0));
        }
        return result;
    }

    private static void setupProjectSdksModel(@NotNull ProjectSdksModel sdksModel, @NotNull Project project2, @Nullable Sdk projectSdk) {
        if (sdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(14);
        }
        sdksModel.reset(project2);
        IdeaGradleProjectSettingsControlBuilder.deduplicateSdkNames(sdksModel);
        if (projectSdk == null) {
            projectSdk = sdksModel.getProjectSdk();
            projectSdk = sdksModel.findSdk(projectSdk);
        }
        if (projectSdk != null) {
            projectSdk = ExternalSystemJdkUtil.resolveDependentJdk((Sdk)projectSdk);
            projectSdk = sdksModel.findSdk(projectSdk.getName());
        }
        sdksModel.setProjectSdk(projectSdk);
    }

    @NotNull
    private static GridBag getLabelConstraints(int indentLevel) {
        JBInsets insets = JBUI.insets((int)0, (int)(5 + 5 * indentLevel), (int)0, (int)5);
        GridBag gridBag = new GridBag().anchor(17).weightx(0.0).insets((Insets)insets);
        if (gridBag == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(15);
        }
        return gridBag;
    }

    private static void wrapExceptions(ThrowableRunnable<Throwable> runnable) {
        try {
            runnable.run();
        }
        catch (Throwable ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void deduplicateSdkNames(@NotNull ProjectSdksModel projectSdksModel) {
        if (projectSdksModel == null) {
            IdeaGradleProjectSettingsControlBuilder.$$$reportNull$$$0(16);
        }
        HashSet<String> processedNames = new HashSet<String>();
        Collection editableSdks = projectSdksModel.getProjectSdks().values();
        for (Sdk sdk : editableSdks) {
            if (processedNames.contains(sdk.getName())) {
                SdkModificator sdkModificator = sdk.getSdkModificator();
                String name = SdkConfigurationUtil.createUniqueSdkName((String)sdk.getName(), editableSdks);
                sdkModificator.setName(name);
                sdkModificator.commitChanges();
            }
            processedNames.add(sdk.getName());
        }
    }

    @NlsSafe
    static String getIDEName() {
        return ApplicationNamesInfo.getInstance().getFullProductName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 5, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder";
                break;
            }
            case 2: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 7: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdksModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProjectSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSdksModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkLookupProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedGradleJvmInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelConstraints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 15: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSdkLookupProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedGradleJvmInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetGradleJdkComboBox";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "recreateGradleJdkComboBox";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "recreateGradleDaemonJvmCriteriaComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resetWrapperControls";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addComponentsGroup";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupProjectSdksModel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "deduplicateSdkNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 5, 15 -> new IllegalStateException(string);
        };
    }

    private class DelayedBalloonInfo
    implements Runnable {
        private final MessageType myMessageType;
        @Nls
        private final String myText;
        private final long myTriggerTime;

        DelayedBalloonInfo(@NotNull MessageType messageType, GradleLocationSettingType settingType, long delayMillis) {
            if (messageType == null) {
                DelayedBalloonInfo.$$$reportNull$$$0(0);
            }
            if (settingType == null) {
                DelayedBalloonInfo.$$$reportNull$$$0(1);
            }
            this.myMessageType = messageType;
            this.myText = settingType.getDescription(GradleConstants.SYSTEM_ID);
            this.myTriggerTime = System.currentTimeMillis() + delayMillis;
        }

        @Override
        public void run() {
            long diff = this.myTriggerTime - System.currentTimeMillis();
            if (diff > 0L) {
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.cancelAllRequests();
                IdeaGradleProjectSettingsControlBuilder.this.myAlarm.addRequest((Runnable)this, diff);
                return;
            }
            if (IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField == null || !IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField.isShowing()) {
                return;
            }
            ExternalSystemUiUtil.showBalloon((JComponent)((Object)IdeaGradleProjectSettingsControlBuilder.this.myGradleHomePathField), (MessageType)this.myMessageType, (String)this.myText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messageType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settingType";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DelayedBalloonInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class DistributionTypeItem
    extends MyItem<DistributionType> {
        private DistributionTypeItem(DistributionType value) {
            super(value);
        }

        @Override
        protected String getText() {
            return DistributionTypeItem.getText((DistributionType)((Object)this.value));
        }

        @Override
        protected String getComment() {
            return null;
        }

        @NotNull
        @NlsContexts.ListItem
        private static String getText(@Nullable DistributionType value) {
            if (value != null) {
                String string = switch (value) {
                    default -> throw new IncompatibleClassChangeError();
                    case DistributionType.BUNDLED -> GradleBundle.message("gradle.project.settings.distribution.bundled", new Object[0]);
                    case DistributionType.DEFAULT_WRAPPED -> GradleBundle.message("gradle.project.settings.distribution.wrapper", new Object[0]);
                    case DistributionType.WRAPPED -> GradleBundle.message("gradle.project.settings.distribution.wrapper.task", new Object[0]);
                    case DistributionType.LOCAL -> GradleBundle.message("gradle.project.settings.distribution.local", new Object[0]);
                };
                if (string == null) {
                    DistributionTypeItem.$$$reportNull$$$0(0);
                }
                return string;
            }
            LOG.error("Unexpected: " + String.valueOf((Object)value));
            String string = GradleBundle.message("gradle.settings.text.unexpected", new Object[]{value});
            if (string == null) {
                DistributionTypeItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$DistributionTypeItem", "getText"));
        }
    }

    private static class MyItemCellRenderer<T>
    extends ColoredListCellRenderer<MyItem<T>> {
        private MyItemCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MyItem<T>> list, MyItem<T> value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                MyItemCellRenderer.$$$reportNull$$$0(0);
            }
            if (value == null) {
                return;
            }
            CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
            ending.addText(value.getText(), MyItemCellRenderer.getTextAttributes(selected));
            if (value.getComment() != null) {
                SimpleTextAttributes commentAttributes = MyItemCellRenderer.getCommentAttributes(selected);
                ending.addComment(value.getComment(), commentAttributes);
            }
            ending.getAppearance().customize((SimpleColoredComponent)this);
        }

        @NotNull
        private static SimpleTextAttributes getTextAttributes(boolean selected) {
            SimpleTextAttributes simpleTextAttributes = selected && (!SystemInfoRt.isWindows || !UIManager.getLookAndFeel().getName().contains("Windows")) ? SimpleTextAttributes.SELECTED_SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyItemCellRenderer.$$$reportNull$$$0(1);
            }
            return simpleTextAttributes;
        }

        @NotNull
        private static SimpleTextAttributes getCommentAttributes(boolean selected) {
            SimpleTextAttributes simpleTextAttributes = SystemInfo.isMac && selected ? new SimpleTextAttributes(0, (Color)JBColor.WHITE) : SimpleTextAttributes.GRAY_ATTRIBUTES;
            if (simpleTextAttributes == null) {
                MyItemCellRenderer.$$$reportNull$$$0(2);
            }
            return simpleTextAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$MyItemCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$MyItemCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommentAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class BuildRunItem
    extends MyItem<Boolean> {
        private BuildRunItem(Boolean value) {
            super(value);
        }

        @Override
        protected String getText() {
            return BuildRunItem.getText((Boolean)this.value);
        }

        @Override
        protected String getComment() {
            return Comparing.equal((Object)((Boolean)this.value), (Object)true) ? GradleBundle.message("gradle.settings.text.default", new Object[0]) : null;
        }

        @NotNull
        @NlsContexts.ListItem
        private static String getText(@Nullable Boolean state) {
            if (state == Boolean.TRUE) {
                return "Gradle";
            }
            if (state == Boolean.FALSE) {
                String string = IdeaGradleProjectSettingsControlBuilder.getIDEName();
                if (string == null) {
                    BuildRunItem.$$$reportNull$$$0(0);
                }
                return string;
            }
            LOG.error("Unexpected: " + state);
            String string = GradleBundle.message("gradle.settings.text.unexpected", state);
            if (string == null) {
                BuildRunItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$BuildRunItem", "getText"));
        }
    }

    private final class TestRunnerItem
    extends MyItem<TestRunner> {
        private TestRunnerItem(TestRunner value) {
            super(value);
        }

        @Override
        protected String getText() {
            return TestRunnerItem.getText((TestRunner)((Object)this.value));
        }

        @Override
        protected String getComment() {
            return Comparing.equal((Object)((Object)((TestRunner)((Object)this.value))), (Object)((Object)GradleProjectSettings.DEFAULT_TEST_RUNNER)) ? GradleBundle.message("gradle.settings.text.default", new Object[0]) : null;
        }

        @NotNull
        @NlsContexts.ListItem
        private static String getText(@Nullable TestRunner runner) {
            if (runner == TestRunner.GRADLE) {
                return "Gradle";
            }
            if (runner == TestRunner.PLATFORM) {
                String string = IdeaGradleProjectSettingsControlBuilder.getIDEName();
                if (string == null) {
                    TestRunnerItem.$$$reportNull$$$0(0);
                }
                return string;
            }
            if (runner == TestRunner.CHOOSE_PER_TEST) {
                String string = GradleBundle.message("gradle.settings.text.build.run.per.test", new Object[0]);
                if (string == null) {
                    TestRunnerItem.$$$reportNull$$$0(1);
                }
                return string;
            }
            LOG.error("Unexpected: " + String.valueOf((Object)runner));
            String string = GradleBundle.message("gradle.settings.text.unexpected", new Object[]{runner});
            if (string == null) {
                TestRunnerItem.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/settings/IdeaGradleProjectSettingsControlBuilder$TestRunnerItem", "getText"));
        }
    }

    private static abstract class MyItem<T> {
        @Nullable
        protected final T value;

        private MyItem(@Nullable T value) {
            this.value = value;
        }

        @NlsContexts.ListItem
        protected abstract String getText();

        @NlsContexts.ListItem
        protected abstract String getComment();

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (this == o) return true;
            if (!(o instanceof MyItem)) return false;
            MyItem item = (MyItem)o;
            if (!Objects.equals(this.value, item.value)) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

