/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.plots;

import com.intellij.kotlin.jupyter.core.util.CursorProvider;
import com.intellij.kotlin.jupyter.core.util.MouseEventDeepReDispatcher;
import com.intellij.kotlin.jupyter.core.util.MouseEventDispatcher;
import com.intellij.kotlin.jupyter.core.util.RetargetingCursorProvider;
import com.intellij.kotlin.jupyter.core.util.UiKt;
import com.intellij.kotlin.jupyter.plots.FlavorsKt;
import com.intellij.kotlin.jupyter.plots.IdeaPlotComponentProviderBatik;
import com.intellij.kotlin.jupyter.plots.IdeaSwingContextBatik;
import com.intellij.kotlin.jupyter.plots.LetsPlotComponentKt;
import com.intellij.kotlin.jupyter.plots.LetsPlotFlavor;
import com.intellij.kotlin.jupyter.plots.LetsPlotOutputDataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBLayeredPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.awt.plot.component.PlotPanel;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\tJ\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J \u0010\u001c\u001a\u00020\u00102\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017j\u0002`\u001aH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kotlin/jupyter/plots/LetsPlotComponent;", "Lcom/intellij/ui/components/JBLayeredPane;", "<init>", "()V", "plotPanel", "Lorg/jetbrains/letsPlot/awt/plot/component/PlotPanel;", "transparentPanel", "Ljavax/swing/JPanel;", "_dataKey", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "previousColorFlavor", "Lcom/intellij/kotlin/jupyter/plots/LetsPlotFlavor;", "dataKey", "getDataKey", "()Lcom/intellij/kotlin/jupyter/plots/LetsPlotOutputDataKey;", "initialize", "", "updateUI", "doLayout", "getPreferredSize", "Ljava/awt/Dimension;", "reinitComponent", "spec", "", "", "", "Lcom/intellij/kotlin/jupyter/plots/MutableLetsPlotSpec;", "clear", "initForSpec", "processedSpec", "Companion", "intellij.kotlin.jupyter.plots"})
@SourceDebugExtension(value={"SMAP\nLetsPlotComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LetsPlotComponent.kt\ncom/intellij/kotlin/jupyter/plots/LetsPlotComponent\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,197:1\n25#2:198\n*S KotlinDebug\n*F\n+ 1 LetsPlotComponent.kt\ncom/intellij/kotlin/jupyter/plots/LetsPlotComponent\n*L\n133#1:198\n*E\n"})
public final class LetsPlotComponent
extends JBLayeredPane {
    @NotNull
    public static final Companion Companion;
    @Nullable
    private PlotPanel plotPanel;
    @Nullable
    private JPanel transparentPanel;
    @Nullable
    private LetsPlotOutputDataKey _dataKey;
    @Nullable
    private LetsPlotFlavor previousColorFlavor;
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final LetsPlotOutputDataKey getDataKey() {
        return this._dataKey;
    }

    public final void initialize(@NotNull LetsPlotOutputDataKey dataKey) {
        Intrinsics.checkNotNullParameter((Object)dataKey, (String)"dataKey");
        this.reinitComponent(LetsPlotComponentKt.access$getSpec(dataKey));
        this._dataKey = dataKey;
    }

    public void updateUI() {
        LetsPlotFlavor colorFlavor = FlavorsKt.getCurrentLetsPlotFlavor();
        LetsPlotOutputDataKey letsPlotOutputDataKey = this.getDataKey();
        if (letsPlotOutputDataKey == null) {
            return;
        }
        LetsPlotOutputDataKey data = letsPlotOutputDataKey;
        if (this.previousColorFlavor == colorFlavor) {
            return;
        }
        this.previousColorFlavor = colorFlavor;
        this.reinitComponent(LetsPlotComponentKt.access$getSpec(data, colorFlavor));
    }

    public void doLayout() {
        super.doLayout();
        Dimension mySize = this.getSize();
        if (mySize.width <= 0 || mySize.height <= 0) {
            return;
        }
        PlotPanel plotPanel2 = this.plotPanel;
        if (plotPanel2 == null) {
            return;
        }
        PlotPanel myComponent = plotPanel2;
        LetsPlotOutputDataKey letsPlotOutputDataKey = this.getDataKey();
        if (letsPlotOutputDataKey == null) {
            return;
        }
        LetsPlotOutputDataKey myData = letsPlotOutputDataKey;
        Map spec = LetsPlotComponentKt.access$getSpec(myData);
        Pair pair2 = LetsPlotComponentKt.access$plotSize(spec, mySize.width, mySize.height);
        int plotWidth = ((Number)pair2.component1()).intValue();
        int plotHeight = ((Number)pair2.component2()).intValue();
        myComponent.setBounds(0, 0, plotWidth, plotHeight);
        myComponent.dispatchEvent(new ComponentEvent(myComponent, 101));
        JPanel jPanel = this.transparentPanel;
        if (jPanel == null) {
            return;
        }
        JPanel transparentPanel = jPanel;
        transparentPanel.setSize(mySize);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Serializable serializable = this.plotPanel;
        if (serializable == null || (serializable = serializable.getPreferredSize()) == null) {
            Dimension dimension = super.getPreferredSize();
            serializable = dimension;
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
        }
        return serializable;
    }

    private final void reinitComponent(Map<String, Object> spec) {
        this.clear();
        this.initForSpec(spec);
    }

    private final void clear() {
        this.removeAll();
        PlotPanel plotPanel2 = this.plotPanel;
        if (plotPanel2 != null) {
            plotPanel2.dispose();
        }
        this.plotPanel = null;
        this.transparentPanel = null;
    }

    private final void initForSpec(Map<String, Object> processedSpec) {
        JPanel jPanel;
        IdeaPlotComponentProviderBatik plotComponentProvider = new IdeaPlotComponentProviderBatik(processedSpec, false, IdeaSwingContextBatik.INSTANCE.getIDEA_EDT_EXECUTOR(), (Function1<? super List<String>, Unit>)((Function1)LetsPlotComponent::initForSpec$lambda$0));
        IdeaSwingContextBatik ideaSwingContextBatik = IdeaSwingContextBatik.INSTANCE;
        PlotPanel plotPanel2 = new PlotPanel(plotComponentProvider, ideaSwingContextBatik){};
        plotPanel2.setOpaque(true);
        this.setAlignmentX(0.5f);
        this.setAlignmentY(0.5f);
        JPanel $this$initForSpec_u24lambda_u242 = jPanel = new JPanel();
        boolean bl = false;
        $this$initForSpec_u24lambda_u242.setOpaque(false);
        PopupHandler.installPopupMenu((JComponent)$this$initForSpec_u24lambda_u242, (String)"LetsPlotActions", (String)"Editor.Jupyter.Cell.Output.Popup");
        UiKt.addDispatchingMouseListener((Component)$this$initForSpec_u24lambda_u242, (MouseEventDispatcher)((MouseEventDispatcher)new MouseEventDeepReDispatcher((Component)plotPanel2, LetsPlotComponent::initForSpec$lambda$2$lambda$1)));
        UiKt.addCursorProvider((Component)$this$initForSpec_u24lambda_u242, (CursorProvider.Factory)((CursorProvider.Factory)new RetargetingCursorProvider.Factory((Component)plotPanel2)));
        JPanel transparentPanel = jPanel;
        this.add(transparentPanel, JBLayeredPane.POPUP_LAYER, -1);
        this.add(plotPanel2, JBLayeredPane.DEFAULT_LAYER, -1);
        this.plotPanel = plotPanel2;
        this.transparentPanel = transparentPanel;
    }

    private static final Unit initForSpec$lambda$0(List messages) {
        Intrinsics.checkNotNullParameter((Object)messages, (String)"messages");
        for (String message : messages) {
            LOG.debug("[Demo Plot Viewer] " + message);
        }
        return Unit.INSTANCE;
    }

    private static final boolean initForSpec$lambda$2$lambda$1(MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return switch (e.getID()) {
            case 500, 501, 502 -> false;
            default -> true;
        };
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/kotlin/jupyter/plots/LetsPlotComponent$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.plots"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

