/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.spatial.projections;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.ProjectionsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H$J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H$J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/AzimuthalBaseProjection;", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "()V", "angle", "", "z", "invert", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "v", "project", "scale", "cxcy", "validDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "Companion", "commons"})
public abstract class AzimuthalBaseProjection
implements Projection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final double LON_LIMIT = 179.999;
    private static final double LAT_LIMIT = 90.0;
    @NotNull
    private static final DoubleRectangle VALID_RECTANGLE = DoubleRectangle.Companion.LTRB(-179.999, -90.0, 179.999, 90.0);

    @Override
    @NotNull
    public DoubleRectangle validDomain() {
        return VALID_RECTANGLE;
    }

    @Override
    @Nullable
    public DoubleVector project(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double x2 = MathKt.toRadians(v.getX());
        double y2 = MathKt.toRadians(v.getY());
        double cx = Math.cos(x2);
        double cy = Math.cos(y2);
        double k = this.scale(cx * cy);
        double px = k * cy * Math.sin(x2);
        double py = k * Math.sin(y2);
        return ProjectionsKt.finiteDoubleVectorOrNull(px, py);
    }

    @Override
    @Nullable
    public DoubleVector invert(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double x2 = v.getX();
        double y2 = v.getY();
        double z = Math.sqrt(x2 * x2 + y2 * y2);
        double c = this.angle(z);
        double sc = Math.sin(c);
        double cc = Math.cos(c);
        double ix = MathKt.toDegrees(Math.atan2(x2 * sc, z * cc));
        double iy = MathKt.toDegrees(z == 0.0 ? 0.0 : Math.asin(y2 * sc / z));
        return ProjectionsKt.finiteDoubleVectorOrNull(ix, iy);
    }

    protected abstract double scale(double var1);

    protected abstract double angle(double var1);

    @Override
    public boolean getNonlinear() {
        return Projection.DefaultImpls.getNonlinear(this);
    }

    @Override
    public boolean getCylindrical() {
        return Projection.DefaultImpls.getCylindrical(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/AzimuthalBaseProjection$Companion;", "", "()V", "LAT_LIMIT", "", "LON_LIMIT", "VALID_RECTANGLE", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "commons"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

