/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.observable.collections.list.ObservableList;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.geom.PieGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.AnnotationUtil;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgCircleElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002'(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0010\u0010\t\u001a\f\u0012\b\u0012\u00060\u000bR\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u000eJ(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J<\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\n2\u0006\u0010\u0018\u001a\u00020\u00142\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002JF\u0010\u001c\u001a\u00020\u00122\n\u0010\u001d\u001a\u00060\u000bR\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00140!2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation;", "", "()V", "INTERVAL_BETWEEN_ANNOTATIONS", "", "build", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "sectors", "", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom$Sector;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/PieGeom;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "createAnnotationElement", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "label", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$AnnotationLabel;", "textLocation", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "textStyle", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "createAnnotationElements", "pieCenter", "annotationLabels", "xRange", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "getAnnotationLabel", "sector", "annotation", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation;", "textSizeGetter", "Lkotlin/Function2;", "", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "offsetForPointer", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "AnnotationLabel", "Side", "plot-base"})
@SourceDebugExtension(value={"SMAP\nPieAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PieAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,270:1\n1549#2:271\n1620#2,3:272\n766#2:275\n857#2,2:276\n766#2:279\n857#2,2:280\n1940#2,14:282\n1940#2,14:296\n1549#2:310\n1620#2,3:311\n1855#2,2:314\n1360#2:316\n1446#2,5:317\n1726#2,3:322\n1360#2:325\n1446#2,5:326\n1855#2,2:331\n766#2:333\n857#2,2:334\n1549#2:336\n1620#2,3:337\n766#2:340\n857#2,2:341\n1045#2:343\n1054#2:344\n1549#2:345\n1620#2,3:346\n1#3:278\n*S KotlinDebug\n*F\n+ 1 PieAnnotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation\n*L\n33#1:271\n33#1:272,3\n37#1:275\n37#1:276,2\n40#1:279\n40#1:280,2\n49#1:282,14\n51#1:296,14\n52#1:310\n52#1:311,3\n72#1:314,2\n102#1:316\n102#1:317,5\n102#1:322,3\n215#1:325\n215#1:326,5\n257#1:331,2\n178#1:333\n178#1:334,2\n179#1:336\n179#1:337,3\n183#1:340\n183#1:341,2\n187#1:343\n189#1:344\n203#1:345\n203#1:346,3\n*E\n"})
public final class PieAnnotation {
    @NotNull
    public static final PieAnnotation INSTANCE = new PieAnnotation();
    private static final double INTERVAL_BETWEEN_ANNOTATIONS = 4.0;

    private PieAnnotation() {
    }

    /*
     * WARNING - void declaration
     */
    public final void build(@NotNull SvgRoot root, @NotNull List<PieGeom.Sector> sectors, @NotNull GeomContext ctx2) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Object t;
        Object t2;
        List<PieGeom.Sector> list2;
        void $this$filterTo$iv$iv;
        List<PieGeom.Sector> $this$filter$iv;
        List<PieGeom.Sector> list3;
        PieGeom.Sector it;
        void $this$filterTo$iv$iv2;
        List<PieGeom.Sector> $this$filter$iv2;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(sectors, (String)"sectors");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Annotation annotation = ctx2.getAnnotation();
        if (annotation == null) {
            return;
        }
        Annotation annotation2 = annotation;
        if (sectors.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = sectors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            PieGeom.Sector sector = (PieGeom.Sector)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getPieCenter());
        }
        DoubleVector doubleVector = (DoubleVector)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (doubleVector == null) {
            return;
        }
        DoubleVector pieCenter = doubleVector;
        $this$map$iv = sectors;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv2 = $this$filter$iv2;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it = (PieGeom.Sector)element$iv$iv;
            boolean bl = false;
            if (!(it.getOuterArcStart().getX() < pieCenter.getX() || it.getOuterArcEnd().getX() < pieCenter.getX() || it.getSectorCenter().getX() < pieCenter.getX())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv;
        if ($this$filter$iv2.isEmpty()) {
            boolean bl = false;
            list3 = sectors;
        } else {
            list3 = $this$filter$iv2;
        }
        List leftSectors = list3;
        Iterable bl = sectors;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PieGeom.Sector it2 = (PieGeom.Sector)element$iv$iv;
            boolean bl2 = false;
            if (!(it2.getOuterArcStart().getX() > pieCenter.getX() || it2.getOuterArcEnd().getX() > pieCenter.getX() || it2.getSectorCenter().getX() > pieCenter.getX())) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        if ($this$filter$iv.isEmpty()) {
            boolean bl3 = false;
            list2 = sectors;
        } else {
            list2 = $this$filter$iv;
        }
        List rightSectors = list2;
        double expand = 20.0;
        Iterator iterator2 = ((Iterable)leftSectors).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        it = (PieGeom.Sector)iterator2.next();
        boolean bl4 = false;
        double bl2 = it.getPieCenter().getX() - it.getRadius();
        while (iterator2.hasNext()) {
            PieGeom.Sector it3 = (PieGeom.Sector)iterator2.next();
            $i$a$-minOf-PieAnnotation$build$leftBorder$1 = false;
            double d = it3.getPieCenter().getX() - it3.getRadius();
            bl2 = Math.min(bl2, d);
        }
        double leftBorder = bl2 - expand;
        Iterator iterator3 = ((Iterable)rightSectors).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        PieGeom.Sector it4 = (PieGeom.Sector)iterator3.next();
        boolean bl5 = false;
        double it3 = it4.getPieCenter().getX() + it4.getRadius();
        while (iterator3.hasNext()) {
            PieGeom.Sector it5 = (PieGeom.Sector)iterator3.next();
            $i$a$-maxOf-PieAnnotation$build$rightBorder$1 = false;
            double d = it5.getPieCenter().getX() + it5.getRadius();
            it3 = Math.max(it3, d);
        }
        double rightBorder = it3 + expand;
        Iterable $this$maxBy$iv = leftSectors;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = maxElem$iv;
        } else {
            PieGeom.Sector p0 = (PieGeom.Sector)maxElem$iv;
            boolean bl6 = false;
            double maxValue$iv = p0.getRadius();
            do {
                Object e$iv = iterator$iv.next();
                PieGeom.Sector p02 = (PieGeom.Sector)e$iv;
                $i$a$-maxByOrThrow-PieAnnotation$build$leftMaxOffsetForOuter$1 = false;
                double v$iv = p02.getRadius();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = maxElem$iv;
        }
        PieGeom.Sector it6 = (PieGeom.Sector)t2;
        boolean bl7 = false;
        double leftMaxOffsetForOuter = it6.getHoleRadius() + 1.2 * (it6.getRadius() - it6.getHoleRadius());
        Iterable $this$maxBy$iv2 = rightSectors;
        boolean $i$f$maxByOrThrow2 = false;
        Iterator iterator$iv2 = $this$maxBy$iv2.iterator();
        if (!iterator$iv2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv2 = iterator$iv2.next();
        if (!iterator$iv2.hasNext()) {
            t = maxElem$iv2;
        } else {
            PieGeom.Sector p0 = (PieGeom.Sector)maxElem$iv2;
            boolean bl8 = false;
            double maxValue$iv = p0.getRadius();
            do {
                Object e$iv = iterator$iv2.next();
                PieGeom.Sector p03 = (PieGeom.Sector)e$iv;
                $i$a$-maxByOrThrow-PieAnnotation$build$rightMaxOffsetForOuter$1 = false;
                double v$iv = p03.getRadius();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv2 = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv2.hasNext());
            t = maxElem$iv2;
        }
        PieGeom.Sector it7 = (PieGeom.Sector)t;
        boolean bl9 = false;
        double rightMaxOffsetForOuter = it7.getHoleRadius() + 1.2 * (it7.getRadius() - it7.getHoleRadius());
        Iterable $this$map$iv2 = sectors;
        boolean $i$f$map2 = false;
        maxElem$iv2 = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sector;
            PieGeom.Sector sector2 = (PieGeom.Sector)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl10 = false;
            double offsetForPointer = leftSectors.contains(sector) && rightSectors.contains(sector) ? Math.max(leftMaxOffsetForOuter, rightMaxOffsetForOuter) : (leftSectors.contains(sector) ? leftMaxOffsetForOuter : rightMaxOffsetForOuter);
            collection.add(INSTANCE.getAnnotationLabel((PieGeom.Sector)sector, annotation2, AnnotationUtil.INSTANCE.textSizeGetter(annotation2.getTextStyle(), ctx2), offsetForPointer, ctx2.getPlotContext()));
        }
        List annotationLabels = (List)destination$iv$iv3;
        $this$map$iv2 = this.createAnnotationElements(pieCenter, annotationLabels, annotation2.getTextStyle(), new DoubleSpan(leftBorder, rightBorder), ctx2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode p0 = (SvgNode)element$iv;
            boolean bl11 = false;
            root.add(p0);
        }
    }

    private final AnnotationLabel getAnnotationLabel(PieGeom.Sector sector, Annotation annotation, Function2<? super String, ? super DataPointAesthetics, DoubleVector> textSizeGetter2, double offsetForPointer, PlotContext plotContext) {
        DoubleVector doubleVector;
        boolean canBePlacedInside;
        DoubleVector textSize;
        String text;
        block6: {
            boolean bl;
            Iterator $this$flatMapTo$iv$iv;
            text = annotation.getAnnotationText(sector.getP().index(), plotContext);
            textSize = (DoubleVector)textSizeGetter2.invoke((Object)text, (Object)sector.getP());
            DoubleRectangle textRect = new DoubleRectangle(sector.getSectorCenter().subtract(textSize.mul(0.5)), textSize);
            Iterable<DoubleSegment> $this$flatMap$iv = textRect.getParts();
            boolean $i$f$flatMap = false;
            Iterable<DoubleSegment> iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                DoubleSegment it = (DoubleSegment)element$iv$iv;
                boolean bl2 = false;
                Object[] objectArray = new DoubleVector[]{it.getStart(), it.getEnd()};
                Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$all$iv = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    DoubleVector p0 = (DoubleVector)element$iv;
                    boolean bl3 = false;
                    if (PieAnnotation.getAnnotationLabel$isPointInsideSector(sector, p0)) continue;
                    bl = false;
                    break block6;
                }
                bl = canBePlacedInside = true;
            }
        }
        if (canBePlacedInside) {
            doubleVector = sector.getSectorCenter();
        } else {
            double offset2 = sector.getHoleRadius() + 0.8 * (sector.getRadius() - sector.getHoleRadius());
            doubleVector = sector.getPosition().add(new DoubleVector(offset2 * Math.cos(sector.getDirection()), offset2 * Math.sin(sector.getDirection())));
        }
        DoubleVector pointerLocation = doubleVector;
        Side side = canBePlacedInside ? Side.INSIDE : (pointerLocation.getX() < sector.getPieCenter().getX() ? Side.LEFT : Side.RIGHT);
        DoubleVector outerPointerCoord = canBePlacedInside ? null : sector.getPosition().add(new DoubleVector(offsetForPointer * Math.cos(sector.getDirection()), offsetForPointer * Math.sin(sector.getDirection())));
        Color textColor2 = WhenMappings.$EnumSwitchMapping$0[side.ordinal()] == 1 ? annotation.getTextColor(sector.getP().fill()) : Annotation.getTextColor$default(annotation, null, 1, null);
        return new AnnotationLabel(text, textSize, pointerLocation, outerPointerCoord, textColor2, side);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SvgGElement> createAnnotationElements(DoubleVector pieCenter, List<AnnotationLabel> annotationLabels, TextStyle textStyle, DoubleSpan xRange, GeomContext ctx2) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = (Iterable)Side.getEntries();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Side p0 = (Side)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = PieAnnotation.createAnnotationElements$createForSide(annotationLabels, xRange, textStyle, ctx2, pieCenter, p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final SvgGElement createAnnotationElement(AnnotationLabel label, DoubleVector textLocation, TextStyle textStyle, GeomContext ctx2) {
        void $this$createAnnotationElement_u24lambda_u2426;
        void $this$forEach$iv;
        SvgGElement g = AnnotationUtil.INSTANCE.createTextElement(label.getText(), textLocation, new AnnotationUtil.TextParams(textStyle, label.getTextColor(), label.getSide().getHJust(), null, null, null, null, 120, null), ctx2);
        if (label.getOuterPointerCoord() == null) {
            return g;
        }
        double startXPos = label.getSide() == Side.LEFT ? textLocation.getX() + 5.0 : textLocation.getX() - 5.0;
        double midXPos = label.getSide() == Side.RIGHT && label.getOuterPointerCoord().getX() > startXPos || label.getSide() == Side.LEFT && label.getOuterPointerCoord().getX() < startXPos ? startXPos : label.getOuterPointerCoord().getX();
        DoubleVector middlePoint = new DoubleVector(midXPos, textLocation.getY());
        Object object = new SvgLineElement[]{new SvgLineElement(startXPos, textLocation.getY(), middlePoint.getX(), middlePoint.getY()), new SvgLineElement(middlePoint.getX(), middlePoint.getY(), label.getLocation().getX(), label.getLocation().getY())};
        object = CollectionsKt.listOf((Object[])object);
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgLineElement line2 = (SvgLineElement)element$iv;
            boolean bl = false;
            line2.strokeColor().set(label.getTextColor());
            line2.strokeWidth().set(0.7);
            g.children().add(line2);
        }
        Object $i$f$forEach22 = object = new SvgCircleElement(label.getLocation().getX(), label.getLocation().getY(), 1.5);
        ObservableList<SvgNode> observableList = g.children();
        boolean bl = false;
        $this$createAnnotationElement_u24lambda_u2426.fillColor().set(label.getTextColor());
        observableList.add(object);
        return g;
    }

    private static final boolean getAnnotationLabel$isPointInsideSector(PieGeom.Sector $sector, DoubleVector pnt) {
        DoubleVector v = pnt.subtract($sector.getPosition());
        double d = $sector.getHoleRadius();
        double d2 = $sector.getRadius();
        double d3 = v.length();
        if (!(d <= d3 ? d3 <= d2 : false)) {
            return false;
        }
        double it = Math.atan2(v.getY(), v.getX());
        boolean bl = false;
        double angle = (-1.5707963267948966 <= it ? it <= Math.PI : false) && Math.abs($sector.getStartAngle()) > Math.PI ? it - Math.PI * 2 : ((-Math.PI <= it ? it <= -1.5707963267948966 : false) && Math.abs($sector.getEndAngle()) > Math.PI ? it + Math.PI * 2 : it);
        return $sector.getStartAngle() <= angle && angle < $sector.getEndAngle();
    }

    /*
     * WARNING - void declaration
     */
    private static final List<SvgGElement> createAnnotationElements$createForSide(List<AnnotationLabel> $annotationLabels, DoubleSpan $xRange, TextStyle $textStyle, GeomContext $ctx, DoubleVector $pieCenter, Side side) {
        void $this$mapTo$iv$iv;
        List outsideLabels;
        List list2;
        boolean bl;
        Double d;
        void $this$filterTo$iv$iv;
        if (side == Side.INSIDE) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            AnnotationLabel it;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv;
            Iterable iterable = $annotationLabels;
            boolean $i$f$filter = false;
            void var8_10 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                it = (AnnotationLabel)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getSide() == side)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (AnnotationLabel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                collection.add(INSTANCE.createAnnotationElement(it, it.getLocation(), $textStyle, $ctx));
            }
            return (List)destination$iv$iv;
        }
        Ref.BooleanRef startFromTheTop = new Ref.BooleanRef();
        Iterable $this$filter$iv = $annotationLabels;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AnnotationLabel it = (AnnotationLabel)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getSide() == side)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List l = (List)destination$iv$iv;
        boolean bl5 = false;
        destination$iv$iv = l;
        Object $i$f$filterTo22 = startFromTheTop;
        Iterator<Object> it = destination$iv$iv.iterator();
        if (!it.hasNext()) {
            d = null;
        } else {
            AnnotationLabel it2 = (AnnotationLabel)it.next();
            boolean bl6 = false;
            double bl4 = it2.getLocation().getY();
            while (it.hasNext()) {
                AnnotationLabel it3 = (AnnotationLabel)it.next();
                $i$a$-minOfOrNull-PieAnnotation$createAnnotationElements$createForSide$outsideLabels$2$1 = false;
                double d2 = it3.getLocation().getY();
                bl4 = Math.min(bl4, d2);
            }
            d = bl4;
        }
        Ref.BooleanRef booleanRef = $i$f$filterTo22;
        if (d != null) {
            void it4;
            double d3 = ((Number)d).doubleValue();
            $i$f$filterTo22 = booleanRef;
            boolean bl7 = false;
            booleanRef = $i$f$filterTo22;
            bl = it4 < $pieCenter.getY();
        } else {
            bl = booleanRef.element = false;
        }
        if (startFromTheTop.element) {
            Iterable $this$sortedBy$iv = l;
            boolean $i$f$sortedBy = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    AnnotationLabel it = (AnnotationLabel)a2;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getLocation().getY());
                    it = (AnnotationLabel)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLocation().getY()));
                }
            });
        } else {
            Iterable $this$sortedByDescending$iv = l;
            boolean $i$f$sortedByDescending = false;
            list2 = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    AnnotationLabel it = (AnnotationLabel)b2;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getLocation().getY());
                    it = (AnnotationLabel)a2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLocation().getY()));
                }
            });
        }
        if ((outsideLabels = list2).isEmpty()) {
            return CollectionsKt.emptyList();
        }
        double d4 = side == Side.LEFT ? $xRange.getLowerEnd().doubleValue() : $xRange.getUpperEnd().doubleValue();
        DoubleVector doubleVector = ((AnnotationLabel)CollectionsKt.first((List)outsideLabels)).getOuterPointerCoord();
        Intrinsics.checkNotNull((Object)doubleVector);
        DoubleVector startPosition = new DoubleVector(d4, doubleVector.getY());
        double yOffset2 = 0.0;
        Iterable $this$map$iv = outsideLabels;
        boolean $i$f$map = false;
        $i$f$filterTo22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void label;
            AnnotationLabel annotationLabel = (AnnotationLabel)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl8 = false;
            DoubleVector loc = startFromTheTop.element ? new DoubleVector(startPosition.getX(), startPosition.getY() + yOffset2) : new DoubleVector(startPosition.getX(), startPosition.getY() - yOffset2);
            yOffset2 += label.getTextSize().getY() + 4.0;
            collection.add(INSTANCE.createAnnotationElement((AnnotationLabel)label, loc, $textStyle, $ctx));
        }
        return (List)destination$iv$iv2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u000bH\u00c6\u0003JG\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$AnnotationLabel;", "", "text", "", "textSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "location", "outerPointerCoord", "textColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "side", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;", "(Ljava/lang/String;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/values/Color;Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;)V", "getLocation", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getOuterPointerCoord", "getSide", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;", "getText", "()Ljava/lang/String;", "getTextColor", "()Lorg/jetbrains/letsPlot/commons/values/Color;", "getTextSize", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "plot-base"})
    private static final class AnnotationLabel {
        @NotNull
        private final String text;
        @NotNull
        private final DoubleVector textSize;
        @NotNull
        private final DoubleVector location;
        @Nullable
        private final DoubleVector outerPointerCoord;
        @NotNull
        private final Color textColor;
        @NotNull
        private final Side side;

        public AnnotationLabel(@NotNull String text, @NotNull DoubleVector textSize, @NotNull DoubleVector location2, @Nullable DoubleVector outerPointerCoord, @NotNull Color textColor2, @NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            this.text = text;
            this.textSize = textSize;
            this.location = location2;
            this.outerPointerCoord = outerPointerCoord;
            this.textColor = textColor2;
            this.side = side;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final DoubleVector getTextSize() {
            return this.textSize;
        }

        @NotNull
        public final DoubleVector getLocation() {
            return this.location;
        }

        @Nullable
        public final DoubleVector getOuterPointerCoord() {
            return this.outerPointerCoord;
        }

        @NotNull
        public final Color getTextColor() {
            return this.textColor;
        }

        @NotNull
        public final Side getSide() {
            return this.side;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final DoubleVector component2() {
            return this.textSize;
        }

        @NotNull
        public final DoubleVector component3() {
            return this.location;
        }

        @Nullable
        public final DoubleVector component4() {
            return this.outerPointerCoord;
        }

        @NotNull
        public final Color component5() {
            return this.textColor;
        }

        @NotNull
        public final Side component6() {
            return this.side;
        }

        @NotNull
        public final AnnotationLabel copy(@NotNull String text, @NotNull DoubleVector textSize, @NotNull DoubleVector location2, @Nullable DoubleVector outerPointerCoord, @NotNull Color textColor2, @NotNull Side side) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)textSize, (String)"textSize");
            Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
            Intrinsics.checkNotNullParameter((Object)textColor2, (String)"textColor");
            Intrinsics.checkNotNullParameter((Object)((Object)side), (String)"side");
            return new AnnotationLabel(text, textSize, location2, outerPointerCoord, textColor2, side);
        }

        public static /* synthetic */ AnnotationLabel copy$default(AnnotationLabel annotationLabel, String string, DoubleVector doubleVector, DoubleVector doubleVector2, DoubleVector doubleVector3, Color color, Side side, int n, Object object) {
            if ((n & 1) != 0) {
                string = annotationLabel.text;
            }
            if ((n & 2) != 0) {
                doubleVector = annotationLabel.textSize;
            }
            if ((n & 4) != 0) {
                doubleVector2 = annotationLabel.location;
            }
            if ((n & 8) != 0) {
                doubleVector3 = annotationLabel.outerPointerCoord;
            }
            if ((n & 0x10) != 0) {
                color = annotationLabel.textColor;
            }
            if ((n & 0x20) != 0) {
                side = annotationLabel.side;
            }
            return annotationLabel.copy(string, doubleVector, doubleVector2, doubleVector3, color, side);
        }

        @NotNull
        public String toString() {
            return "AnnotationLabel(text=" + this.text + ", textSize=" + this.textSize + ", location=" + this.location + ", outerPointerCoord=" + this.outerPointerCoord + ", textColor=" + this.textColor + ", side=" + (Object)((Object)this.side) + ')';
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.textSize.hashCode();
            result2 = result2 * 31 + this.location.hashCode();
            result2 = result2 * 31 + (this.outerPointerCoord == null ? 0 : this.outerPointerCoord.hashCode());
            result2 = result2 * 31 + this.textColor.hashCode();
            result2 = result2 * 31 + this.side.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AnnotationLabel)) {
                return false;
            }
            AnnotationLabel annotationLabel = (AnnotationLabel)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)annotationLabel.text)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.textSize, (Object)annotationLabel.textSize)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.location, (Object)annotationLabel.location)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.outerPointerCoord, (Object)annotationLabel.outerPointerCoord)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.textColor, (Object)annotationLabel.textColor)) {
                return false;
            }
            return this.side == annotationLabel.side;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;", "", "(Ljava/lang/String;I)V", "getHJust", "", "INSIDE", "LEFT", "RIGHT", "plot-base"})
    private static final abstract class Side
    extends Enum<Side> {
        public static final /* enum */ Side INSIDE = new INSIDE("INSIDE", 0);
        public static final /* enum */ Side LEFT = new LEFT("LEFT", 1);
        public static final /* enum */ Side RIGHT = new RIGHT("RIGHT", 2);
        private static final /* synthetic */ Side[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Side() {
        }

        @NotNull
        public abstract String getHJust();

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value) {
            return Enum.valueOf(Side.class, value);
        }

        @NotNull
        public static EnumEntries<Side> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ Side(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            $VALUES = sideArray = new Side[]{Side.INSIDE, Side.LEFT, Side.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side$INSIDE;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;", "getHJust", "", "plot-base"})
        static final class INSIDE
        extends Side {
            /*
             * WARNING - void declaration
             */
            INSIDE() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getHJust() {
                return "middle";
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side$LEFT;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;", "getHJust", "", "plot-base"})
        static final class LEFT
        extends Side {
            /*
             * WARNING - void declaration
             */
            LEFT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getHJust() {
                return "right";
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side$RIGHT;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/PieAnnotation$Side;", "getHJust", "", "plot-base"})
        static final class RIGHT
        extends Side {
            /*
             * WARNING - void declaration
             */
            RIGHT() {
                void var1_1;
            }

            @Override
            @NotNull
            public String getHJust() {
                return "left";
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.INSIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

