/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.svg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.values.Font;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Node;
import org.jetbrains.letsPlot.core.plot.base.render.svg.RichText;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Token;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgTSpanElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u000f0\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LatexTerm;", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "node", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;", "(Lorg/jetbrains/letsPlot/core/plot/base/render/svg/Node;)V", "svg", "", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgTSpanElement;", "getSvg", "()Ljava/util/List;", "visualCharCount", "", "getVisualCharCount", "()I", "estimateWidth", "", "font", "Lorg/jetbrains/letsPlot/commons/values/Font;", "widthCalculator", "Lkotlin/Function2;", "", "Companion", "plot-base"})
public final class LatexTerm
implements RichText.Term {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Node node;
    private final int visualCharCount;
    @NotNull
    private final List<SvgTSpanElement> svg;

    public LatexTerm(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.visualCharCount = this.node.getVisualCharCount();
        this.svg = this.node.getSvg();
    }

    @Override
    public int getVisualCharCount() {
        return this.visualCharCount;
    }

    @NotNull
    public List<SvgTSpanElement> getSvg() {
        return this.svg;
    }

    @Override
    public double estimateWidth(@NotNull Font font, @NotNull Function2<? super String, ? super Font, Double> widthCalculator) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        Intrinsics.checkNotNullParameter(widthCalculator, (String)"widthCalculator");
        return this.node.estimateWidth(font, widthCalculator);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0002J \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/svg/LatexTerm$Companion;", "", "()V", "extractFormulas", "", "Lkotlin/Pair;", "", "Lkotlin/ranges/IntRange;", "text", "parse", "Lorg/jetbrains/letsPlot/core/plot/base/render/svg/RichText$Term;", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nLatexTerm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LatexTerm.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/LatexTerm$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n1549#2:330\n1620#2,3:331\n*S KotlinDebug\n*F\n+ 1 LatexTerm.kt\norg/jetbrains/letsPlot/core/plot/base/render/svg/LatexTerm$Companion\n*L\n26#1:330\n26#1:331,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Pair<RichText.Term, IntRange>> parse(@NotNull String text) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Iterable $this$map$iv = this.extractFormulas(text);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair2 = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String formula = (String)pair2.component1();
                IntRange range = (IntRange)pair2.component2();
                String text2 = StringsKt.replace$default((String)formula, (String)"-", (String)"\u2212", (boolean)false, (int)4, null);
                collection.add(TuplesKt.to((Object)new LatexTerm(Node.Companion.parse(Token.Companion.tokenize(text2))), (Object)range));
            }
            return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }

        private final List<Pair<String, IntRange>> extractFormulas(String text) {
            List formulas = new ArrayList();
            int formulaStart = 0;
            int n = text.length() - 1;
            for (int i = 0; i < n; ++i) {
                String formula;
                String string;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(i, i + 2), (String)"substring(...)");
                if (Intrinsics.areEqual((Object)string, (Object)"\\(")) {
                    formulaStart = i + 2;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"\\)")) continue;
                Intrinsics.checkNotNullExpressionValue((Object)text.substring(formulaStart, i), (String)"substring(...)");
                IntRange range = new IntRange(formulaStart - 2, i + 1);
                formulas.add(new Pair((Object)formula, (Object)range));
            }
            return formulas;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

