/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.typedGeometry.algorithms.AdaptiveResampler;
import org.jetbrains.letsPlot.core.commons.data.SeriesUtil;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.builder.AxisUtil;
import org.jetbrains.letsPlot.core.plot.builder.coord.PolarCoordinateSystem;
import org.jetbrains.letsPlot.core.plot.builder.guide.AxisComponent;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0011\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil;", "", "()V", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "coord", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "gridDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "Helper", "PolarBreaksData", "plot-builder"})
public final class PolarAxisUtil {
    @NotNull
    public static final PolarAxisUtil INSTANCE = new PolarAxisUtil();

    private PolarAxisUtil() {
    }

    @NotNull
    public final PolarBreaksData breaksData(@NotNull ScaleBreaks scaleBreaks, @NotNull PolarCoordinateSystem coord, @NotNull DoubleRectangle gridDomain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
        Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)gridDomain, (String)"gridDomain");
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        return new Helper(scaleBreaks, coord, gridDomain, flipAxis, orientation, labelAdjustments).breaksData();
    }

    public static /* synthetic */ PolarBreaksData breaksData$default(PolarAxisUtil polarAxisUtil, ScaleBreaks scaleBreaks, PolarCoordinateSystem polarCoordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, Object object) {
        if ((n & 0x20) != 0) {
            tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
        }
        return polarAxisUtil.breaksData(scaleBreaks, polarCoordinateSystem, doubleRectangle, bl, orientation, tickLabelAdjustments);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010*\u001a\u00020+J\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0-H\u0002J\u0018\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010-2\u0006\u00100\u001a\u00020\"H\u0002J\u0018\u00101\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010-2\u0006\u00102\u001a\u00020\"H\u0002J\u0018\u00103\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010-2\u0006\u00102\u001a\u00020\"H\u0002J>\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\"0-2\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u0002072\u0006\u0010\b\u001a\u00020\t2\u0006\u00108\u001a\u00020\tH\u0002J\u0010\u00104\u001a\u00020\u00102\u0006\u00109\u001a\u00020\u0010H\u0002R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR-\u0010\u0004\u001a\u00020\u0010*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00100 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010#R-\u0010$\u001a\u00020\"*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00100 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R-\u0010'\u001a\u00020!*\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00100 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006:"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$Helper;", "", "scaleBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "coord", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "gridDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "labelAdjustments", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;ZLorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;)V", "center", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getCenter", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getCoord", "()Lorg/jetbrains/letsPlot/core/plot/builder/coord/PolarCoordinateSystem;", "getFlipAxis", "()Z", "getGridDomain", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getLabelAdjustments", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "getOrientation", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "getScaleBreaks", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "Lkotlin/collections/IndexedValue;", "Lkotlin/Triple;", "", "", "(Lkotlin/collections/IndexedValue;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "domValue", "getDomValue", "(Lkotlin/collections/IndexedValue;)D", "label", "getLabel", "(Lkotlin/collections/IndexedValue;)Ljava/lang/String;", "breaksData", "Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "breaksToClient", "", "breaks", "buildAngleGridLine", "breakCoord", "buildGridLine", "br", "buildRadiusGridLine", "toClient", "dataDomain", "coordinateSystem", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "horizontal", "v", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nPolarAxisUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PolarAxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$Helper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1559#2:207\n1590#2,4:208\n1603#2,9:212\n1855#2:221\n1856#2:223\n1612#2:224\n1549#2:225\n1620#2,3:226\n1559#2:229\n1590#2,4:230\n1603#2,9:234\n1855#2:243\n1856#2:245\n1612#2:246\n1603#2,9:247\n1855#2:256\n1856#2:258\n1612#2:259\n1603#2,9:260\n1855#2:269\n1856#2:271\n1612#2:272\n1549#2:273\n1620#2,3:274\n1549#2:277\n1620#2,3:278\n1549#2:281\n1620#2,3:282\n1549#2:285\n1620#2,3:286\n1549#2:289\n1620#2,3:290\n1549#2:293\n1620#2,3:294\n1549#2:297\n1620#2,3:298\n1549#2:301\n1620#2,3:302\n1#3:222\n1#3:244\n1#3:257\n1#3:270\n*S KotlinDebug\n*F\n+ 1 PolarAxisUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$Helper\n*L\n50#1:207\n50#1:208,4\n84#1:212,9\n84#1:221\n84#1:223\n84#1:224\n90#1:225\n90#1:226,3\n93#1:229\n93#1:230,4\n96#1:234,9\n96#1:243\n96#1:245\n96#1:246\n102#1:247,9\n102#1:256\n102#1:258\n102#1:259\n103#1:260,9\n103#1:269\n103#1:271\n103#1:272\n107#1:273\n107#1:274,3\n108#1:277\n108#1:278,3\n109#1:281\n109#1:282,3\n110#1:285\n110#1:286,3\n111#1:289\n111#1:290,3\n121#1:293\n121#1:294,3\n146#1:297\n146#1:298,3\n151#1:301\n151#1:302,3\n84#1:222\n96#1:244\n102#1:257\n103#1:270\n*E\n"})
    private static final class Helper {
        @NotNull
        private final ScaleBreaks scaleBreaks;
        @NotNull
        private final PolarCoordinateSystem coord;
        @NotNull
        private final DoubleRectangle gridDomain;
        private final boolean flipAxis;
        @NotNull
        private final Orientation orientation;
        @NotNull
        private final AxisComponent.TickLabelAdjustments labelAdjustments;
        @NotNull
        private final DoubleVector center;

        public Helper(@NotNull ScaleBreaks scaleBreaks, @NotNull PolarCoordinateSystem coord, @NotNull DoubleRectangle gridDomain, boolean flipAxis, @NotNull Orientation orientation, @NotNull AxisComponent.TickLabelAdjustments labelAdjustments) {
            Intrinsics.checkNotNullParameter((Object)scaleBreaks, (String)"scaleBreaks");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)gridDomain, (String)"gridDomain");
            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
            Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
            this.scaleBreaks = scaleBreaks;
            this.coord = coord;
            this.gridDomain = gridDomain;
            this.flipAxis = flipAxis;
            this.orientation = orientation;
            this.labelAdjustments = labelAdjustments;
            DoubleVector doubleVector = this.coord.toClient(this.gridDomain.getOrigin());
            if (doubleVector == null) {
                throw new IllegalStateException("Failed to get center of the polar coordinate system".toString());
            }
            this.center = doubleVector;
        }

        public /* synthetic */ Helper(ScaleBreaks scaleBreaks, PolarCoordinateSystem polarCoordinateSystem, DoubleRectangle doubleRectangle, boolean bl, Orientation orientation, AxisComponent.TickLabelAdjustments tickLabelAdjustments, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                tickLabelAdjustments = new AxisComponent.TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
            }
            this(scaleBreaks, polarCoordinateSystem, doubleRectangle, bl, orientation, tickLabelAdjustments);
        }

        @NotNull
        public final ScaleBreaks getScaleBreaks() {
            return this.scaleBreaks;
        }

        @NotNull
        public final PolarCoordinateSystem getCoord() {
            return this.coord;
        }

        @NotNull
        public final DoubleRectangle getGridDomain() {
            return this.gridDomain;
        }

        public final boolean getFlipAxis() {
            return this.flipAxis;
        }

        @NotNull
        public final Orientation getOrientation() {
            return this.orientation;
        }

        @NotNull
        public final AxisComponent.TickLabelAdjustments getLabelAdjustments() {
            return this.labelAdjustments;
        }

        @NotNull
        public final DoubleVector getCenter() {
            return this.center;
        }

        @NotNull
        public final String getLabel(@NotNull IndexedValue<Triple<String, Double, DoubleVector>> $this$label) {
            Intrinsics.checkNotNullParameter($this$label, (String)"<this>");
            return (String)((Triple)$this$label.getValue()).getFirst();
        }

        public final double getDomValue(@NotNull IndexedValue<Triple<String, Double, DoubleVector>> $this$domValue) {
            Intrinsics.checkNotNullParameter($this$domValue, (String)"<this>");
            return ((Number)((Triple)$this$domValue.getValue()).getSecond()).doubleValue();
        }

        @NotNull
        public final DoubleVector getCoord(@NotNull IndexedValue<Triple<String, Double, DoubleVector>> $this$coord) {
            Intrinsics.checkNotNullParameter($this$coord, (String)"<this>");
            return (DoubleVector)((Triple)$this$coord.getValue()).getThird();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PolarBreaksData breaksData() {
            void $this$mapTo$iv$iv;
            void $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            void $this$mapTo$iv$iv4;
            void $this$mapTo$iv$iv5;
            List list2;
            List<DoubleVector> it$iv$iv;
            Object element$iv$iv;
            boolean $i$f$forEach;
            Object $this$forEach$iv$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            boolean $i$f$mapNotNullTo;
            boolean $i$f$mapNotNull;
            Iterable $this$mapNotNull$iv;
            boolean bl;
            Object element$iv$iv2;
            void $this$mapNotNullTo$iv$iv2;
            Pair clientBreak;
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv;
            void $this$mapTo$iv$iv6;
            void $this$map$iv;
            boolean bl2;
            Triple it$iv$iv2;
            List<DoubleVector> clientLine;
            DoubleVector clientTick;
            Object br;
            int n;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv3;
            Object firstBr;
            List list3;
            Object object;
            void $this$mapIndexedTo$iv$iv2;
            if (!(this.scaleBreaks.getTransformedValues().size() == this.scaleBreaks.getLabels().size())) {
                boolean $i$a$-check-PolarAxisUtil$Helper$breaksData$22 = false;
                String $i$a$-check-PolarAxisUtil$Helper$breaksData$22 = "Breaks and labels must have the same size";
                throw new IllegalStateException($i$a$-check-PolarAxisUtil$Helper$breaksData$22.toString());
            }
            Iterable $this$mapIndexed$iv2 = this.breaksToClient(this.scaleBreaks.getTransformedValues());
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                void clientTick2;
                void i;
                int n2;
                if ((n2 = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DoubleVector doubleVector = (DoubleVector)item$iv$iv;
                int n3 = n2;
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add(new IndexedValue((int)i, (Object)new Triple((Object)this.scaleBreaks.getLabels().get((int)i), (Object)this.scaleBreaks.getTransformedValues().get((int)i), (Object)clientTick2)));
            }
            List it = (List)destination$iv$iv;
            boolean bl4 = false;
            if (it.size() < 2) {
                list3 = it;
            } else {
                firstBr = (IndexedValue)CollectionsKt.first((List)it);
                IndexedValue lastBr = (IndexedValue)CollectionsKt.last((List)it);
                if (this.getCoord((IndexedValue<Triple<String, Double, DoubleVector>>)firstBr).subtract(this.getCoord((IndexedValue<Triple<String, Double, DoubleVector>>)lastBr)).length() > 3.0) {
                    list3 = it;
                } else {
                    IndexedValue newFirstBr = new IndexedValue(firstBr.getIndex(), (Object)new Triple((Object)(this.getLabel((IndexedValue<Triple<String, Double, DoubleVector>>)lastBr) + '/' + this.getLabel((IndexedValue<Triple<String, Double, DoubleVector>>)firstBr)), (Object)this.getDomValue((IndexedValue<Triple<String, Double, DoubleVector>>)firstBr), (Object)this.getCoord((IndexedValue<Triple<String, Double, DoubleVector>>)firstBr)));
                    IndexedValue newLastBr = new IndexedValue(lastBr.getIndex(), (Object)new Triple((Object)"", (Object)this.getDomValue((IndexedValue<Triple<String, Double, DoubleVector>>)lastBr), (Object)this.getCoord((IndexedValue<Triple<String, Double, DoubleVector>>)lastBr)));
                    List cleaned = CollectionsKt.toMutableList((Collection)it);
                    cleaned.set(newFirstBr.getIndex(), newFirstBr);
                    cleaned.set(newLastBr.getIndex(), newLastBr);
                    list3 = cleaned;
                }
            }
            List majorBreaks = list3;
            Iterable $this$mapNotNull$iv2 = majorBreaks;
            boolean $i$f$mapNotNull22 = false;
            firstBr = $this$mapNotNull$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv3;
            boolean $i$f$forEach22 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv$iv = iterator2.next();
                boolean bl5 = false;
                IndexedValue indexedValue = (IndexedValue)element$iv$iv3;
                n = 0;
                br = (Triple)indexedValue.component2();
                String label = (String)br.component1();
                double domainTick = ((Number)br.component2()).doubleValue();
                clientTick = (DoubleVector)br.component3();
                if ((this.buildGridLine(domainTick) == null ? null : new Triple((Object)label, (Object)clientTick, clientLine)) == null) continue;
                it$iv$iv2 = it$iv$iv2;
                bl2 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List majorBreaksData = (List)destination$iv$iv2;
            Iterable $i$f$mapNotNull22 = majorBreaks;
            object = AxisUtil.INSTANCE;
            boolean $i$f$map = false;
            destination$iv$iv2 = $this$map$iv;
            Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                void it2;
                element$iv$iv$iv = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl6 = false;
                collection.add(((Number)((Triple)it2.getValue()).getSecond()).doubleValue());
            }
            List<Double> minorDomainBreaks = ((AxisUtil)object).minorDomainBreaks$plot_builder((List)destination$iv$iv3);
            boolean bl7 = false;
            destination$iv$iv3 = this.breaksToClient(minorDomainBreaks);
            boolean $i$f$mapIndexed2 = false;
            Iterator $i$f$forEach22 = $this$mapIndexed$iv;
            Iterable destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                if ((n = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                br = (DoubleVector)item$iv$iv;
                int label = n;
                Collection domainTick = destination$iv$iv4;
                boolean bl8 = false;
                domainTick.add(new Pair((Object)minorDomainBreaks.get((int)i), (Object)clientBreak));
            }
            List minorBreaks = (List)destination$iv$iv4;
            Iterable $this$mapNotNull$iv3 = minorBreaks;
            boolean $i$f$mapNotNull3 = false;
            $this$mapIndexed$iv = $this$mapNotNull$iv3;
            Collection destination$iv$iv5 = new ArrayList();
            boolean $i$f$mapNotNullTo32 = false;
            void $this$forEach$iv$iv$iv3 = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach3 = false;
            for (Object element$iv$iv$iv2 : $this$forEach$iv$iv$iv3) {
                element$iv$iv2 = element$iv$iv$iv2;
                boolean bl9 = false;
                clientBreak = (Pair)element$iv$iv2;
                boolean bl10 = false;
                double domainTick = ((Number)clientBreak.component1()).doubleValue();
                clientTick = (DoubleVector)clientBreak.component2();
                if ((this.buildGridLine(domainTick) == null ? null : new Pair((Object)clientTick, clientLine)) == null) continue;
                it$iv$iv2 = it$iv$iv2;
                bl2 = false;
                destination$iv$iv5.add(it$iv$iv2);
            }
            List minorBreaksData = (List)destination$iv$iv5;
            boolean bl11 = bl = !this.orientation.isHorizontal();
            if (bl) {
                $this$mapNotNull$iv = CollectionsKt.listOf((Object)this.gridDomain.xRange().getUpperEnd());
                $i$f$mapNotNull = false;
                Iterable $i$f$mapNotNullTo32 = $this$mapNotNull$iv;
                destination$iv$iv4 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv$iv3;
                    element$iv$iv = element$iv$iv$iv3 = element$iv$iv2.next();
                    boolean bl12 = false;
                    double p0 = ((Number)element$iv$iv).doubleValue();
                    boolean bl13 = false;
                    if (this.buildAngleGridLine(p0) == null) continue;
                    boolean bl14 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                list2 = (List)CollectionsKt.single((List)((List)destination$iv$iv4));
            } else if (!bl) {
                $this$mapNotNull$iv = CollectionsKt.listOf((Object)this.gridDomain.yRange().getUpperEnd());
                $i$f$mapNotNull = false;
                $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv4 = new ArrayList();
                $i$f$mapNotNullTo = false;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = false;
                element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv$iv4;
                    element$iv$iv = element$iv$iv$iv4 = element$iv$iv2.next();
                    boolean bl15 = false;
                    double p0 = ((Number)element$iv$iv).doubleValue();
                    boolean bl16 = false;
                    if (this.buildRadiusGridLine(p0) == null) continue;
                    boolean bl17 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                list2 = (List)CollectionsKt.single((List)((List)destination$iv$iv4));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            List axisLine = list2;
            Iterable $this$map$iv2 = majorBreaksData;
            boolean $i$f$map2 = false;
            $this$mapNotNullTo$iv$iv = $this$map$iv2;
            destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                element$iv$iv2 = (Triple)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl18 = false;
                DoubleVector tick = (DoubleVector)element$iv$iv2.component2();
                object.add(tick);
            }
            List list4 = (List)destination$iv$iv4;
            Iterable $this$map$iv3 = majorBreaksData;
            boolean $i$f$map3 = false;
            destination$iv$iv4 = $this$map$iv3;
            Iterable destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv4) {
                Triple bl18 = (Triple)item$iv$iv;
                object = destination$iv$iv6;
                boolean bl19 = false;
                List gridLine = (List)bl18.component3();
                object.add(gridLine);
            }
            List list5 = (List)destination$iv$iv6;
            Iterable $this$map$iv4 = majorBreaksData;
            boolean $i$f$map4 = false;
            destination$iv$iv6 = $this$map$iv4;
            Iterable destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
            boolean $i$f$mapTo4 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Triple bl19 = (Triple)item$iv$iv;
                object = destination$iv$iv7;
                boolean bl20 = false;
                String label = (String)bl19.component1();
                object.add(label);
            }
            List list6 = (List)destination$iv$iv7;
            Iterable $this$map$iv5 = minorBreaksData;
            boolean $i$f$map5 = false;
            destination$iv$iv7 = $this$map$iv5;
            Iterable destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo5 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair bl20 = (Pair)item$iv$iv;
                object = destination$iv$iv8;
                boolean bl21 = false;
                DoubleVector tick = (DoubleVector)bl20.component1();
                object.add(tick);
            }
            List list7 = (List)destination$iv$iv8;
            Iterable $this$map$iv6 = minorBreaksData;
            boolean $i$f$map6 = false;
            destination$iv$iv8 = $this$map$iv6;
            Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
            boolean $i$f$mapTo6 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair2 = (Pair)item$iv$iv;
                object = destination$iv$iv9;
                boolean bl22 = false;
                List gridLine = (List)pair2.component2();
                object.add(gridLine);
            }
            List list8 = (List)destination$iv$iv9;
            DoubleVector doubleVector = this.center;
            double d = this.coord.getStartAngle();
            return new PolarBreaksData(doubleVector, d, list4, list6, list7, list5, list8, axisLine);
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleVector> breaksToClient(List<Double> breaks) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)this.toClient(breaks, this.gridDomain, this.coord, this.flipAxis, this.orientation.isHorizontal()));
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DoubleVector doubleVector;
                void it;
                DoubleVector doubleVector2 = (DoubleVector)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                boolean bl2 = this.orientation.isHorizontal();
                if (bl2) {
                    doubleVector = it.subtract(this.center);
                } else if (!bl2) {
                    doubleVector = it.rotateAround(this.center, this.coord.getStartAngle() * this.coord.getDirection());
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection.add(doubleVector);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        private final List<DoubleVector> toClient(List<Double> breaks, DoubleRectangle dataDomain, CoordinateSystem coordinateSystem, boolean flipAxis, boolean horizontal) {
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            DoubleRectangle hvDomain = dataDomain;
            Iterable $this$map$iv = breaks;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void breakValue;
                double d = ((Number)item$iv$iv).doubleValue();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(horizontal ? new DoubleVector((double)breakValue, hvDomain.yRange().getUpperEnd()) : new DoubleVector(hvDomain.xRange().getLowerEnd(), (double)breakValue));
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DoubleVector breakValue = (DoubleVector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                DoubleVector pointInDataDomain = it.flipIf(flipAxis);
                DoubleVector doubleVector = SeriesUtil.INSTANCE.finiteOrNull(coordinateSystem.toClient(pointInDataDomain));
                if (doubleVector == null) {
                    doubleVector = null;
                }
                collection.add(doubleVector);
            }
            return (List)destination$iv$iv;
        }

        private final DoubleVector toClient(DoubleVector v) {
            DoubleVector doubleVector = this.coord.toClient(v.flipIf(this.flipAxis));
            if (doubleVector == null) {
                throw new IllegalStateException("Unexpected null value".toString());
            }
            return doubleVector;
        }

        private final List<DoubleVector> buildAngleGridLine(double breakCoord) {
            if (!this.gridDomain.xRange().contains(breakCoord)) {
                return null;
            }
            Object[] objectArray = new DoubleVector[]{this.toClient(new DoubleVector(breakCoord, this.gridDomain.yRange().getLowerEnd())), this.toClient(new DoubleVector(breakCoord, this.gridDomain.yRange().getUpperEnd()))};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        private final List<DoubleVector> buildRadiusGridLine(double br) {
            if (!this.gridDomain.yRange().contains(br)) {
                return null;
            }
            Object[] objectArray = new DoubleVector[]{new DoubleVector(this.gridDomain.xRange().getLowerEnd(), br), new DoubleVector(this.gridDomain.xRange().getUpperEnd(), br)};
            List line2 = CollectionsKt.listOf((Object[])objectArray);
            return AdaptiveResampler.Companion.resample(line2, 0.95, (Function1<? super DoubleVector, DoubleVector>)((Function1)new Function1<DoubleVector, DoubleVector>((Object)this){

                @NotNull
                public final DoubleVector invoke(@NotNull DoubleVector p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return Helper.access$toClient((Helper)this.receiver, p0);
                }
            }));
        }

        private final List<DoubleVector> buildGridLine(double br) {
            List<DoubleVector> list2;
            boolean bl = this.orientation.isHorizontal();
            if (bl) {
                list2 = this.buildAngleGridLine(br);
            } else if (!bl) {
                list2 = this.buildRadiusGridLine(br);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return list2;
        }

        public static final /* synthetic */ DoubleVector access$toClient(Helper $this, DoubleVector v) {
            return $this.toClient(v);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\u0018\u00002\u00020\u0001Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u0012\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0002\u0010\u000eR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/PolarAxisUtil$PolarBreaksData;", "", "center", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "startAngle", "", "majorBreaks", "", "majorLabels", "", "minorBreaks", "majorGrid", "minorGrid", "axisLine", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;DLjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getAxisLine", "()Ljava/util/List;", "getCenter", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getMajorBreaks", "getMajorGrid", "getMajorLabels", "getMinorBreaks", "getMinorGrid", "getStartAngle", "()D", "plot-builder"})
    public static final class PolarBreaksData {
        @NotNull
        private final DoubleVector center;
        private final double startAngle;
        @NotNull
        private final List<DoubleVector> majorBreaks;
        @NotNull
        private final List<String> majorLabels;
        @NotNull
        private final List<DoubleVector> minorBreaks;
        @NotNull
        private final List<List<DoubleVector>> majorGrid;
        @NotNull
        private final List<List<DoubleVector>> minorGrid;
        @NotNull
        private final List<DoubleVector> axisLine;

        public PolarBreaksData(@NotNull DoubleVector center, double startAngle, @NotNull List<DoubleVector> majorBreaks, @NotNull List<String> majorLabels, @NotNull List<DoubleVector> minorBreaks, @NotNull List<? extends List<DoubleVector>> majorGrid, @NotNull List<? extends List<DoubleVector>> minorGrid, @NotNull List<DoubleVector> axisLine) {
            Intrinsics.checkNotNullParameter((Object)center, (String)"center");
            Intrinsics.checkNotNullParameter(majorBreaks, (String)"majorBreaks");
            Intrinsics.checkNotNullParameter(majorLabels, (String)"majorLabels");
            Intrinsics.checkNotNullParameter(minorBreaks, (String)"minorBreaks");
            Intrinsics.checkNotNullParameter(majorGrid, (String)"majorGrid");
            Intrinsics.checkNotNullParameter(minorGrid, (String)"minorGrid");
            Intrinsics.checkNotNullParameter(axisLine, (String)"axisLine");
            this.center = center;
            this.startAngle = startAngle;
            this.majorBreaks = majorBreaks;
            this.majorLabels = majorLabels;
            this.minorBreaks = minorBreaks;
            this.majorGrid = majorGrid;
            this.minorGrid = minorGrid;
            this.axisLine = axisLine;
        }

        @NotNull
        public final DoubleVector getCenter() {
            return this.center;
        }

        public final double getStartAngle() {
            return this.startAngle;
        }

        @NotNull
        public final List<DoubleVector> getMajorBreaks() {
            return this.majorBreaks;
        }

        @NotNull
        public final List<String> getMajorLabels() {
            return this.majorLabels;
        }

        @NotNull
        public final List<DoubleVector> getMinorBreaks() {
            return this.minorBreaks;
        }

        @NotNull
        public final List<List<DoubleVector>> getMajorGrid() {
            return this.majorGrid;
        }

        @NotNull
        public final List<List<DoubleVector>> getMinorGrid() {
            return this.minorGrid;
        }

        @NotNull
        public final List<DoubleVector> getAxisLine() {
            return this.axisLine;
        }
    }
}

