/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout.axis.label;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.theme.AxisTheme;
import org.jetbrains.letsPlot.core.plot.builder.guide.Orientation;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AbstractFixedBreaksLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.AxisLabelsLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalMultilineLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalRotatedLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalSimpleLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalTiltedLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.axis.label.HorizontalVerticalLabelsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.util.Insets;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u000eH\u0002J\b\u0010 \u001a\u00020\u001aH\u0002J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalFixedBreaksLabelsLayout;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AbstractFixedBreaksLabelsLayout;", "orientation", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;", "breaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "geomAreaInsets", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;", "polar", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/Orientation;Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;Lorg/jetbrains/letsPlot/core/plot/builder/layout/util/Insets;Lorg/jetbrains/letsPlot/core/plot/base/theme/AxisTheme;Z)V", "axisLeftExpand", "", "axisRightExpand", "doLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayoutInfo;", "axisDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "axisLength", "labelBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "labelNormalSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "multilineLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/AxisLabelsLayout;", "overlap", "labelsInfo", "axisSpanExpanded", "rotatedLayout", "angle", "simpleLayout", "tiltedLayout", "verticalLayout", "withScaleBreaks", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nHorizontalFixedBreaksLabelsLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HorizontalFixedBreaksLabelsLayout.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/axis/label/HorizontalFixedBreaksLabelsLayout\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class HorizontalFixedBreaksLabelsLayout
extends AbstractFixedBreaksLabelsLayout {
    @NotNull
    private final Insets geomAreaInsets;
    private final boolean polar;
    private final double axisLeftExpand;
    private final double axisRightExpand;

    public HorizontalFixedBreaksLabelsLayout(@NotNull Orientation orientation, @NotNull ScaleBreaks breaks, @NotNull Insets geomAreaInsets, @NotNull AxisTheme theme, boolean polar) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        Intrinsics.checkNotNullParameter((Object)geomAreaInsets, (String)"geomAreaInsets");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        super(orientation, breaks, theme);
        this.geomAreaInsets = geomAreaInsets;
        this.polar = polar;
        this.axisLeftExpand = Math.max(this.geomAreaInsets.getLeft(), 10.0);
        this.axisRightExpand = Math.max(this.geomAreaInsets.getRight(), 10.0);
        if (!orientation.isHorizontal()) {
            boolean bl = false;
            String string = orientation.toString();
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean overlap(AxisLabelsLayoutInfo labelsInfo, DoubleSpan axisSpanExpanded) {
        if (labelsInfo.isOverlap$plot_builder()) return true;
        DoubleRectangle doubleRectangle = labelsInfo.getBounds();
        Intrinsics.checkNotNull((Object)doubleRectangle);
        if (axisSpanExpanded.encloses(doubleRectangle.xRange())) return false;
        return true;
    }

    @Override
    @NotNull
    public AxisLabelsLayoutInfo doLayout(@NotNull DoubleSpan axisDomain, double axisLength) {
        AxisLabelsLayoutInfo axisLabelsLayoutInfo;
        Intrinsics.checkNotNullParameter((Object)axisDomain, (String)"axisDomain");
        if (!this.getTheme().showLabels()) {
            return this.noLabelsLayoutInfo(axisLength, this.getOrientation());
        }
        DoubleSpan axisSpanExpanded = new DoubleSpan(-this.axisLeftExpand, axisLength + this.axisRightExpand);
        if (this.getTheme().rotateLabels()) {
            return this.rotatedLayout(this.getTheme().labelAngle()).doLayout(axisDomain, axisLength);
        }
        if (this.getBreaks().getSize() > 400) {
            axisLabelsLayoutInfo = this.verticalLayout().doLayout(axisDomain, axisLength);
        } else if (!this.polar) {
            AxisLabelsLayoutInfo layoutInfo = this.simpleLayout().doLayout(axisDomain, axisLength);
            if (this.overlap(layoutInfo, axisSpanExpanded) && this.overlap(layoutInfo = this.multilineLayout().doLayout(axisDomain, axisLength), axisSpanExpanded) && this.overlap(layoutInfo = this.tiltedLayout().doLayout(axisDomain, axisLength), axisSpanExpanded)) {
                layoutInfo = this.verticalLayout().doLayout(axisDomain, axisLength);
            }
            axisLabelsLayoutInfo = layoutInfo;
        } else {
            axisLabelsLayoutInfo = this.simpleLayout().doLayout(axisDomain, axisLength);
        }
        AxisLabelsLayoutInfo labelsLayoutInfo = axisLabelsLayoutInfo;
        return labelsLayoutInfo;
    }

    @Override
    @NotNull
    public AxisLabelsLayout withScaleBreaks(@NotNull ScaleBreaks breaks) {
        Intrinsics.checkNotNullParameter((Object)breaks, (String)"breaks");
        return new HorizontalFixedBreaksLabelsLayout(this.getOrientation(), breaks, this.geomAreaInsets, this.getTheme(), this.polar);
    }

    private final AxisLabelsLayout simpleLayout() {
        return new HorizontalSimpleLabelsLayout(this.getOrientation(), this.getBreaks(), this.getTheme());
    }

    private final AxisLabelsLayout multilineLayout() {
        return new HorizontalMultilineLabelsLayout(this.getOrientation(), this.getBreaks(), this.getTheme(), 2);
    }

    private final AxisLabelsLayout tiltedLayout() {
        return new HorizontalTiltedLabelsLayout(this.getOrientation(), this.getBreaks(), this.getTheme());
    }

    private final AxisLabelsLayout rotatedLayout(double angle) {
        return new HorizontalRotatedLabelsLayout(this.getOrientation(), this.getBreaks(), this.getTheme(), angle);
    }

    private final AxisLabelsLayout verticalLayout() {
        return new HorizontalVerticalLabelsLayout(this.getOrientation(), this.getBreaks(), this.getTheme());
    }

    @Override
    @NotNull
    protected DoubleRectangle labelBounds(@NotNull DoubleVector labelNormalSize) {
        Intrinsics.checkNotNullParameter((Object)labelNormalSize, (String)"labelNormalSize");
        throw new IllegalStateException("Not implemented here");
    }
}

