/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.testFrameworks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ProcessBuilder {
    public static final boolean isWindows = ProcessBuilder.isWindows();
    private static final String WIN_SHELL_SPECIALS = "&<>()@^|";
    private final List<String> myParameters = new ArrayList<String>();
    private File myWorkingDir = null;

    private static boolean isWindows() {
        try {
            return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).startsWith("windows");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public void add(String parameter) {
        this.myParameters.add(parameter);
    }

    public void add(List<String> parameters) {
        for (String parameter : parameters) {
            this.add(parameter);
        }
    }

    public void setWorkingDir(File workingDir) {
        this.myWorkingDir = workingDir;
    }

    public Process createProcess() throws IOException {
        if (this.myParameters.isEmpty()) {
            throw new IllegalArgumentException("Executable name not specified");
        }
        String command = this.myParameters.get(0);
        boolean winShell = isWindows && ProcessBuilder.isWinShell(command);
        String[] commandLine = new String[this.myParameters.size()];
        commandLine[0] = command;
        for (int i = 1; i < this.myParameters.size(); ++i) {
            String parameter = this.myParameters.get(i);
            if (isWindows) {
                int pos = parameter.indexOf(34);
                if (pos >= 0) {
                    StringBuilder buffer = new StringBuilder(parameter);
                    do {
                        buffer.insert(pos, '\\');
                        pos += 2;
                    } while ((pos = parameter.indexOf(34, pos)) >= 0);
                    parameter = buffer.toString();
                } else if (parameter.isEmpty()) {
                    parameter = "\"\"";
                }
                if (winShell && ProcessBuilder.containsAnyChar(parameter, WIN_SHELL_SPECIALS)) {
                    parameter = '\"' + parameter + '\"';
                }
            }
            commandLine[i] = parameter;
        }
        return Runtime.getRuntime().exec(commandLine, null, this.myWorkingDir);
    }

    private static boolean isWinShell(String command) {
        return ProcessBuilder.endsWithIgnoreCase(command, ".cmd") || ProcessBuilder.endsWithIgnoreCase(command, ".bat") || "cmd".equalsIgnoreCase(command) || "cmd.exe".equalsIgnoreCase(command);
    }

    private static boolean endsWithIgnoreCase(String str, String suffix) {
        return str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static boolean containsAnyChar(String value, String chars) {
        for (int i = 0; i < value.length(); ++i) {
            if (chars.indexOf(value.charAt(i)) < 0) continue;
            return true;
        }
        return false;
    }
}

