/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.debugger.impl.OutputChecker;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.CompilerTester;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.JavaProjectTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ExecutionTestCase
extends JavaProjectTestCase {
    private OutputChecker myChecker;
    private int myTimeoutMillis = 300000;
    private static Path ourOutputRoot;
    private Path myModuleOutputDir;
    protected static final String SOURCES_DIRECTORY_NAME = "src";

    public final void setTimeout(int timeoutMillis) {
        this.myTimeoutMillis = timeoutMillis;
    }

    protected abstract OutputChecker initOutputChecker();

    protected abstract String getTestAppPath();

    protected boolean areLogErrorsIgnored() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        this.setupTempDir();
        if (ourOutputRoot == null) {
            ourOutputRoot = this.getTempDir().newPath();
        }
        this.myChecker = this.initOutputChecker();
        EdtTestUtil.runInEdtAndWait(() -> super.setUp());
        this.myModuleOutputDir = this.getModuleOutputDir();
        if (!Files.exists(this.myModuleOutputDir, new LinkOption[0])) {
            Files.createDirectories(this.myModuleOutputDir, new FileAttribute[0]);
            if (FileUtil.isAncestor((File)ourOutputRoot.toFile(), (File)this.myModuleOutputDir.toFile(), (boolean)false)) {
                VirtualFile vDir = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(ourOutputRoot);
                ExecutionTestCase.assertNotNull((String)ourOutputRoot.toString(), (Object)vDir);
            }
            this.compileProject();
        }
    }

    protected void compileProject() throws Exception {
        CompilerTester compilerTester = new CompilerTester(this.myProject, Arrays.asList(ModuleManager.getInstance((Project)this.myProject).getModules()), this.getTestRootDisposable(), this.overrideCompileJdkAndOutput());
        List<CompilerMessage> messages = compilerTester.rebuild();
        for (CompilerMessage message : messages) {
            if (message.getCategory() != CompilerMessageCategory.ERROR) continue;
            FileUtil.delete((Path)this.myModuleOutputDir);
            ExecutionTestCase.fail((String)("Compilation failed: " + String.valueOf(message) + " " + String.valueOf(message.getVirtualFile())));
        }
    }

    @NotNull
    protected Path getModuleOutputDir() {
        Path path = ourOutputRoot.resolve(PathUtil.getFileName((String)this.getTestAppPath()));
        if (path == null) {
            ExecutionTestCase.$$$reportNull$$$0(0);
        }
        return path;
    }

    protected boolean overrideCompileJdkAndOutput() {
        return true;
    }

    @Override
    protected void setUpModule() {
        super.setUpModule();
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.setupModuleRoots();
            IdeaTestUtil.setModuleLanguageLevel(this.myModule, LanguageLevel.JDK_1_8);
            Path outputDir = this.getModuleOutputDir();
            PsiTestUtil.setCompilerOutputPath(this.myModule, VfsUtilCore.pathToUrl((String)outputDir.toString()), false);
        });
    }

    @Override
    protected Sdk getTestProjectJdk() {
        return JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk();
    }

    protected final void systemPrintln(@NotNull @NonNls String msg) {
        if (msg == null) {
            ExecutionTestCase.$$$reportNull$$$0(1);
        }
        this.println(msg, (Key)ProcessOutputType.SYSTEM);
    }

    public void println(@NonNls String s, Key outputType) {
        this.myChecker.println(s, outputType);
    }

    public void print(String s, Key outputType) {
        this.myChecker.print(s, outputType);
    }

    @Override
    protected void runBareRunnable(@NotNull ThrowableRunnable<Throwable> runnable) throws Throwable {
        if (runnable == null) {
            ExecutionTestCase.$$$reportNull$$$0(2);
        }
        runnable.run();
        int errorLoggingHappened = TestLoggerFactory.getRethrowErrorNumber();
        if (errorLoggingHappened != 0 && !this.areLogErrorsIgnored()) {
            ExecutionTestCase.assertEquals((String)"No ignored errors should happen during execution tests", (int)0, (int)errorLoggingHappened);
        }
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            ExecutionTestCase.$$$reportNull$$$0(3);
        }
        this.myChecker.init(this.getTestName(true));
        super.runTestRunnable(testRunnable);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myChecker = null;
        EdtTestUtil.runInEdtAndWait(() -> super.tearDown());
    }

    protected JavaParameters createJavaParameters(String mainClass) {
        JavaParameters parameters = new JavaParameters();
        parameters.getClassPath().add(this.getAppOutputPath());
        parameters.setMainClass(mainClass);
        parameters.setJdk(JavaAwareProjectJdkTableImpl.getInstanceEx().getInternalJdk());
        parameters.setWorkingDirectory(this.getTestAppPath());
        return parameters;
    }

    @RequiresWriteLock
    protected void setupModuleRoots() {
        ThreadingAssertions.assertWriteAccess();
        String modulePath = this.getTestAppPath();
        String srcPath = this.getSrcPath(modulePath);
        VirtualFile moduleDir = LocalFileSystem.getInstance().findFileByPath(modulePath.replace(File.separatorChar, '/'));
        VirtualFile srcDir = LocalFileSystem.getInstance().findFileByPath(srcPath.replace(File.separatorChar, '/'));
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)this.myModule);
        PsiTestUtil.removeAllRoots(this.myModule, rootManager.getSdk());
        PsiTestUtil.addContentRoot(this.myModule, moduleDir);
        PsiTestUtil.addSourceRoot(this.myModule, srcDir);
    }

    protected OutputChecker getChecker() {
        return this.myChecker;
    }

    protected String getAppDataPath() {
        return this.getTestAppPath() + File.separator + "data";
    }

    protected String getAppOptionsPath() {
        return this.getTestAppPath() + File.separator + "config" + File.separator + "options";
    }

    protected String getAppOutputPath() {
        return this.getModuleOutputDir().toString();
    }

    @NotNull
    protected String getSrcPath(String modulePath) {
        String string = modulePath + File.separator + SOURCES_DIRECTORY_NAME;
        if (string == null) {
            ExecutionTestCase.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void waitProcess(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            ExecutionTestCase.$$$reportNull$$$0(5);
        }
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.getTestRootDisposable());
        AtomicBoolean isRunning = new AtomicBoolean(true);
        alarm.addRequest(() -> {
            if (isRunning.get()) {
                processHandler.destroyProcess();
                LOG.error("process was running over " + this.myTimeoutMillis / 1000 + " seconds. Interrupted. ");
            }
        }, this.myTimeoutMillis);
        processHandler.waitFor();
        isRunning.set(false);
        Disposer.dispose((Disposable)alarm);
    }

    public void waitFor(Runnable r) {
        Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.getTestRootDisposable());
        Thread thread = Thread.currentThread();
        AtomicBoolean isRunning = new AtomicBoolean(true);
        alarm.addRequest(() -> {
            if (isRunning.get()) {
                thread.interrupt();
                LOG.error("test was running over " + this.myTimeoutMillis / 1000 + " seconds. Interrupted. ");
            }
        }, this.myTimeoutMillis);
        r.run();
        isRunning.set(false);
        Thread.interrupted();
        Disposer.dispose((Disposable)alarm);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutionTestCase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleOutputDir";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutionTestCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSrcPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "systemPrintln";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runBareRunnable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "waitProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

