/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.actions.ImportModuleAction;
import com.intellij.ide.impl.NewProjectUtil;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.NewProjectWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.actions.NewModuleAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.testFramework.IndexingTestUtil;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.TestObservation;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectWizardTestCase<T extends AbstractProjectWizard>
extends HeavyPlatformTestCase {
    protected static final String DEFAULT_SDK = "default";
    protected T myWizard;
    @Nullable
    private Project myCreatedProject;
    private Sdk myOldDefaultProjectSdk;
    private File contentRoot;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.contentRoot = this.createTempDirectoryWithSuffix("new").toFile();
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        this.myOldDefaultProjectSdk = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        Sdk projectSdk = ProjectRootManager.getInstance((Project)this.getProject()).getProjectSdk();
        for (Sdk jdk : ProjectJdkTable.getInstance().getAllJdks()) {
            if (projectSdk == jdk) continue;
            ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().removeJdk(jdk));
        }
        ProjectTypeStep.resetGroupForTests();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            this.setWizard(null);
            if (this.myCreatedProject != null) {
                PlatformTestUtil.forceCloseProjectWithoutSaving(this.myCreatedProject);
                this.myCreatedProject = null;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    LanguageLevelProjectExtensionImpl extension = LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectManager.getInstance().getDefaultProject());
                    extension.resetDefaults();
                    ProjectRootManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setProjectSdk(this.myOldDefaultProjectSdk);
                    JavaAwareProjectJdkTableImpl.removeInternalJdkInTests();
                });
                SelectTemplateSettings.getInstance().setLastTemplate(null, null);
                PlatformTestUtil.dispatchAllEventsInIdeEventQueue();
            });
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                try {
                    super.tearDown();
                }
                catch (Exception e) {
                    this.addSuppressedException(e);
                }
            });
        }
    }

    void setWizard(@Nullable T wizard) {
        if (this.myWizard != null) {
            Disposer.dispose((Disposable)this.myWizard.getDisposable());
        }
        this.myWizard = wizard;
    }

    private Project createProjectFromWizard() {
        try {
            this.myCreatedProject = NewProjectUtil.createFromWizard(this.myWizard);
        }
        catch (Throwable e) {
            this.myCreatedProject = (Project)ContainerUtil.find((Object[])ProjectManager.getInstance().getOpenProjects(), project -> this.myWizard.getProjectName().equals(project.getName()));
            throw new RuntimeException(e);
        }
        ProjectWizardTestCase.assertNotNull((Object)this.myCreatedProject);
        this.waitForConfiguration(this.myCreatedProject);
        return this.myCreatedProject;
    }

    private Module createModuleFromWizard(@NotNull Project project) {
        if (project == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(0);
        }
        Module createdModule = new NewModuleAction().createModuleFromWizard(project, null, this.myWizard);
        this.waitForConfiguration(project);
        return createdModule;
    }

    protected void waitForConfiguration(@NotNull Project project) {
        if (project == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(1);
        }
        UIUtil.dispatchAllInvocationEvents();
        IndexingTestUtil.waitUntilIndexesAreReady(project);
        TestObservation.waitForConfiguration(TimeUnit.MINUTES.toMillis(10L), project);
    }

    private static void setSelectedTemplate(@NotNull Step step, @NotNull String group, @Nullable String name) {
        ProjectTypeStep projectTypeStep;
        if (step == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(2);
        }
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(3);
        }
        if (!(projectTypeStep = ProjectWizardTestCase.assertInstanceOf(step, ProjectTypeStep.class)).setSelectedTemplate(group, name)) {
            throw new IllegalArgumentException(group + "/" + name + " template not found. Available groups: " + projectTypeStep.availableTemplateGroupsToString());
        }
    }

    private static void adjustSelectedStep(@NotNull Step step, @NotNull Consumer<? super NewProjectWizardStep> adjuster) {
        if (step == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(4);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(5);
        }
        ProjectTypeStep projectTypeStep = ProjectWizardTestCase.assertInstanceOf(step, ProjectTypeStep.class);
        ModuleWizardStep moduleWizardStep = projectTypeStep.getCustomStep();
        ProjectWizardTestCase.assertInstanceOf(moduleWizardStep, NewProjectWizardStep.class);
        NewProjectWizardStep npwStep = (NewProjectWizardStep)moduleWizardStep;
        adjuster.accept((NewProjectWizardStep)npwStep);
    }

    private void runWizard(@Nullable Consumer<? super Step> adjuster) {
        block5: {
            ModuleWizardStep currentStep;
            do {
                currentStep = (ModuleWizardStep)this.myWizard.getCurrentStepObject();
                if (adjuster != null) {
                    try {
                        adjuster.accept((Step)currentStep);
                    }
                    catch (CancelWizardException e) {
                        this.myWizard.doCancelAction();
                        return;
                    }
                }
                if (this.myWizard.isLast()) break block5;
                this.myWizard.doNextAction();
            } while (currentStep != this.myWizard.getCurrentStepObject());
            throw new RuntimeException(String.valueOf(currentStep) + " is not validated");
        }
        if (!this.myWizard.doFinishAction()) {
            throw new RuntimeException(String.valueOf(this.myWizard.getCurrentStepObject()) + " is not validated");
        }
    }

    protected void createWizard(@Nullable Project project) {
        this.setWizard(this.createWizard(project, this.contentRoot));
        UIUtil.dispatchAllInvocationEvents();
    }

    protected Project createProject(Consumer<? super Step> adjuster) throws IOException {
        this.createWizard(null);
        this.runWizard(adjuster);
        this.myWizard.disposeIfNeeded();
        return this.createProjectFromWizard();
    }

    protected Project createProjectFromTemplate(@NotNull String group, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(6);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(7);
        }
        return this.createProject(step -> {
            ProjectWizardTestCase.setSelectedTemplate(step, group, null);
            ProjectWizardTestCase.adjustSelectedStep(step, adjuster);
        });
    }

    protected Module createModule(@NotNull Project project, @NotNull Consumer<? super Step> adjuster) throws IOException {
        if (project == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(8);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(9);
        }
        this.createWizard(project);
        this.runWizard(adjuster);
        this.myWizard.disposeIfNeeded();
        return this.createModuleFromWizard(project);
    }

    protected Module createModuleFromTemplate(@NotNull Project project, @NotNull String group, @NotNull Consumer<? super NewProjectWizardStep> adjuster) throws IOException {
        if (project == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(10);
        }
        if (group == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(11);
        }
        if (adjuster == null) {
            ProjectWizardTestCase.$$$reportNull$$$0(12);
        }
        return this.createModule(project, step -> {
            ProjectWizardTestCase.setSelectedTemplate(step, group, null);
            ProjectWizardTestCase.adjustSelectedStep(step, adjuster);
        });
    }

    protected File getContentRoot() {
        return this.contentRoot;
    }

    protected T createWizard(Project project, File directory) {
        throw new RuntimeException();
    }

    protected void configureJdk() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.addSdk(new SimpleJavaSdkType().createJdk(DEFAULT_SDK, SystemProperties.getJavaHome()));
            this.addSdk(new SimpleJavaSdkType().createJdk("_other", SystemProperties.getJavaHome()));
            LOG.debug("ProjectWizardTestCase.configureJdk:");
            LOG.debug(String.valueOf(Arrays.asList(ProjectJdkTable.getInstance().getAllJdks())));
        });
    }

    protected void addSdk(Sdk sdk) {
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
    }

    protected Module importModuleFrom(ProjectImportProvider provider, String path) {
        return this.importFrom(path, this.getProject(), null, provider);
    }

    protected Module importProjectFrom(String path, Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        Module module2 = this.importFrom(path, null, adjuster, providers);
        if (module2 != null) {
            this.myCreatedProject = module2.getProject();
        }
        return module2;
    }

    private Module importFrom(String path, @Nullable Project project, Consumer<? super Step> adjuster, ProjectImportProvider ... providers) {
        return ProjectWizardTestCase.computeInWriteSafeContext(() -> this.doImportModule(path, project, adjuster, providers));
    }

    private Module doImportModule(String path, @Nullable Project project, Consumer<? super Step> adjuster, ProjectImportProvider[] providers) {
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        ProjectWizardTestCase.assertNotNull((String)("Can't find " + path), (Object)file);
        ProjectWizardTestCase.assertTrue((boolean)providers[0].canImport(file, project));
        this.setWizard(ImportModuleAction.createImportWizard((Project)project, null, (VirtualFile)file, (ProjectImportProvider[])providers));
        ProjectWizardTestCase.assertNotNull(this.myWizard);
        if (this.myWizard.getStepCount() > 0) {
            this.runWizard(adjuster);
        }
        return (Module)ContainerUtil.getFirstItem((List)ImportModuleAction.createFromWizard((Project)project, this.myWizard));
    }

    private static <T> T computeInWriteSafeContext(Supplier<? extends T> supplier) {
        Ref module2 = Ref.create();
        ApplicationManager.getApplication().invokeLater(() -> module2.set(supplier.get()));
        UIUtil.dispatchAllInvocationEvents();
        return (T)module2.get();
    }

    protected Sdk createSdk(String name, SdkTypeId sdkType) {
        Sdk sdk = ProjectJdkTable.getInstance().createSdk(name, sdkType);
        ApplicationManager.getApplication().runWriteAction(() -> ProjectJdkTable.getInstance().addJdk(sdk, this.getTestRootDisposable()));
        return sdk;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adjuster";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/projectWizard/ProjectWizardTestCase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromWizard";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "waitForConfiguration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedTemplate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustSelectedStep";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createProjectFromTemplate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createModule";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "createModuleFromTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CancelWizardException
    extends RuntimeException {
        private CancelWizardException() {
        }
    }
}

