/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.structureView.logical.impl.LogicalStructureViewService;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LogicalStructureNode;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import junit.framework.ComparisonFailure;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a3\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\u0002\b\u000b\u001a\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"MAX_DEPTH", "", "assertLogicalStructure", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "nodePath", "", "expectedStructureInitializer", "Lkotlin/Function1;", "Lcom/intellij/testFramework/LogicalStructureNode;", "Lkotlin/ExtensionFunctionType;", "createActualNode", "element", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "intellij.java.testFramework"})
@SourceDebugExtension(value={"SMAP\nLogicalStructureTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogicalStructureTestUtils.kt\ncom/intellij/testFramework/LogicalStructureTestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,181:1\n1863#2:182\n1864#2:185\n1310#3,2:183\n*S KotlinDebug\n*F\n+ 1 LogicalStructureTestUtils.kt\ncom/intellij/testFramework/LogicalStructureTestUtilsKt\n*L\n29#1:182\n29#1:185\n30#1:183,2\n*E\n"})
public final class LogicalStructureTestUtilsKt {
    private static final int MAX_DEPTH = 20;

    public static final void assertLogicalStructure(@NotNull PsiFile psiFile, @Nullable String nodePath, @NotNull Function1<? super LogicalStructureNode, Unit> expectedStructureInitializer) {
        Object $this$forEach$iv;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter(expectedStructureInitializer, (String)"expectedStructureInitializer");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        StructureViewBuilder builder = LogicalStructureViewService.Companion.getInstance(project2).getLogicalStructureBuilder(psiFile);
        TestCase.assertNotNull((Object)builder);
        StructureViewBuilder structureViewBuilder = builder;
        Intrinsics.checkNotNull((Object)structureViewBuilder);
        StructureView structureView = structureViewBuilder.createStructureView(null, project2);
        StructureViewTreeElement targetStructureElement = null;
        StructureViewTreeElement structureViewTreeElement = structureView.getTreeModel().getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)structureViewTreeElement, (String)"getRoot(...)");
        targetStructureElement = structureViewTreeElement;
        Object object = nodePath;
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null) {
            $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object object2;
                String pathPart;
                block5: {
                    Object element$iv = iterator.next();
                    pathPart = (String)element$iv;
                    boolean bl = false;
                    TreeElement[] treeElementArray = targetStructureElement.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)treeElementArray, (String)"getChildren(...)");
                    Object[] $this$firstOrNull$iv = treeElementArray;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        TreeElement it = (TreeElement)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getPresentation().getPresentableText(), (Object)pathPart)) continue;
                        object2 = element$iv2;
                        break block5;
                    }
                    object2 = null;
                }
                Object object3 = object2;
                StructureViewTreeElement child = object3 instanceof StructureViewTreeElement ? (StructureViewTreeElement)object3 : null;
                TestCase.assertNotNull((String)("Can't find a child '" + pathPart + "'"), (Object)child);
                Intrinsics.checkNotNull((Object)child);
            }
        }
        Object actualRoot = null;
        actualRoot = LogicalStructureTestUtilsKt.createActualNode(targetStructureElement);
        if (nodePath != null) {
            Object it = $this$forEach$iv = new LogicalStructureNode(null, "", "", null, 8, null);
            boolean bl = false;
            ((LogicalStructureNode)it).subNode((LogicalStructureNode)actualRoot);
            actualRoot = $this$forEach$iv;
        }
        LogicalStructureNode expectedRoot = new LogicalStructureNode(null, "", "", null, 8, null);
        expectedStructureInitializer.invoke((Object)expectedRoot);
        if (!LogicalStructureNode.isEqualTo$default(expectedRoot, (LogicalStructureNode)actualRoot, false, 0, 4, null)) {
            expectedRoot.synchronizeImportantElements((LogicalStructureNode)actualRoot);
            throw new ComparisonFailure("The models are not equals: ", expectedRoot.print("", false), ((LogicalStructureNode)actualRoot).print("", false));
        }
    }

    public static /* synthetic */ void assertLogicalStructure$default(PsiFile psiFile, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        LogicalStructureTestUtilsKt.assertLogicalStructure(psiFile, string, (Function1<? super LogicalStructureNode, Unit>)function1);
    }

    private static final LogicalStructureNode createActualNode(StructureViewTreeElement element) {
        Object object;
        String string;
        ItemPresentation itemPresentation = element.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)itemPresentation, (String)"getPresentation(...)");
        ItemPresentation presentation = itemPresentation;
        Icon icon = presentation.getIcon(false);
        String string2 = presentation.getPresentableText();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = presentation.getLocationString()) == null) {
            string = "";
        }
        if ((object = presentation instanceof PresentationData ? (PresentationData)presentation : null) == null || (object = object.getColoredText()) == null) {
            object = CollectionsKt.emptyList();
        }
        LogicalStructureNode node = new LogicalStructureNode(icon, string2, string, (List<? extends PresentableNodeDescriptor.ColoredFragment>)object);
        for (TreeElement child : element.getChildren()) {
            if (!(child instanceof StructureViewTreeElement)) continue;
            node.subNode(LogicalStructureTestUtilsKt.createActualNode((StructureViewTreeElement)child));
        }
        node.navigationElement((Function0<? extends PsiElement>)((Function0)() -> LogicalStructureTestUtilsKt.createActualNode$lambda$3(element)));
        return node;
    }

    private static final PsiElement createActualNode$lambda$3(StructureViewTreeElement $element) {
        PsiTreeElementBase psiTreeElementBase = $element instanceof PsiTreeElementBase ? (PsiTreeElementBase)$element : null;
        return psiTreeElementBase != null ? psiTreeElementBase.getElement() : null;
    }
}

