/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.kotlin;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.testFramework.fixtures.MavenDependencyUtil;
import com.intellij.util.text.VersionComparatorUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Assume;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/testFramework/fixtures/kotlin/KotlinTester;", "", "<init>", "()V", "canUseKotlin", "", "assumeCanUseKotlin", "", "assumeKotlinPluginVersion", "version", "", "KOTLIN_VERSION", "KT_STD_JDK_8_MAVEN_ID", "KT_STD_MAVEN_ID", "configureKotlinStdLib", "model", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "intellij.java.testFramework"})
public final class KotlinTester {
    @NotNull
    public static final KotlinTester INSTANCE = new KotlinTester();
    @NotNull
    public static final String KOTLIN_VERSION = "1.3.70";
    @NotNull
    public static final String KT_STD_JDK_8_MAVEN_ID = "org.jetbrains.kotlin:kotlin-stdlib-jdk8:1.3.70";
    @NotNull
    public static final String KT_STD_MAVEN_ID = "org.jetbrains.kotlin:kotlin-stdlib:1.3.70";

    private KotlinTester() {
    }

    private final boolean canUseKotlin() {
        boolean bl;
        try {
            Class.forName("org.jetbrains.kotlin.idea.run.KotlinRunConfiguration");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final void assumeCanUseKotlin() {
        Assume.assumeTrue((String)"Kotlin plugin JARs aren't found in the classpath; build 'KotlinPlugin' artifact.", (boolean)this.canUseKotlin());
    }

    public final void assumeKotlinPluginVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)"org.jetbrains.kotlin"));
        String actualKotlinVersion = ideaPluginDescriptor != null ? ideaPluginDescriptor.getVersion() : null;
        Assume.assumeTrue((String)("Kotlin plugin version should be at least " + version + " but was: " + actualKotlinVersion), (VersionComparatorUtil.compare((String)version, (String)actualKotlinVersion) <= 0 ? 1 : 0) != 0);
    }

    public final void configureKotlinStdLib(@NotNull ModifiableRootModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        MavenDependencyUtil.addFromMaven(model, KT_STD_MAVEN_ID);
        MavenDependencyUtil.addFromMaven(model, KT_STD_JDK_8_MAVEN_ID);
    }
}

