/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters;

import java.lang.reflect.Array;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Roles;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            Object result = null;
            if (null != value && value.length() > 0) {
                result = evaluator.evaluate(value);
            }
            if (null == result && configuration.getChildCount() == 0 && null != (value = configuration.getAttribute("default-value")) && value.length() > 0) {
                result = evaluator.evaluate(value);
            }
            return result;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e);
        }
    }

    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        Object result = this.fromExpression(configuration, evaluator);
        this.failIfNotTypeCompatible(result, type, configuration);
        return result;
    }

    protected final String fromXML(String name) {
        return Roles.camelizeName(name);
    }

    protected final void failIfNotTypeCompatible(Object value, Class<?> type, PlexusConfiguration configuration) throws ComponentConfigurationException {
        if (null != value && null != type && !type.isInstance(value)) {
            String reason = String.format("Cannot assign configuration entry '%s' with value '%s' of type %s to property of type %s", configuration.getName(), configuration.getValue(), value.getClass().getCanonicalName(), type.getCanonicalName());
            throw new ComponentConfigurationException(configuration, reason);
        }
    }

    protected final Class<?> getClassForImplementationHint(Class<?> type, PlexusConfiguration configuration, ClassLoader loader) throws ComponentConfigurationException {
        String hint = configuration.getAttribute("implementation");
        if (null == hint) {
            return type;
        }
        try {
            int dims = 0;
            while (hint.endsWith("[]")) {
                hint = hint.substring(0, hint.length() - 2);
                ++dims;
            }
            Class<?> implType = loader.loadClass(hint);
            while (dims > 0) {
                implType = Array.newInstance(implType, 0).getClass();
                --dims;
            }
            return implType;
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", e);
        }
    }

    protected final Object instantiateObject(Class<?> type) throws ComponentConfigurationException {
        try {
            return type.newInstance();
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type, e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type, e);
        }
    }
}

