/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ConfigurationListener;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ParameterizedConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.composite.AbstractCollectionConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;

public class ArrayConverter
extends AbstractCollectionConverter
implements ParameterizedConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return type.isArray();
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        return this.fromConfiguration(lookup, configuration, type, null, enclosingType, loader, evaluator, listener);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Type[] typeArguments, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator);
        if (type.isInstance(value)) {
            return value;
        }
        try {
            Collection<Object> elements;
            Type elementType = ArrayConverter.findElementType(type, typeArguments);
            if (null == value) {
                elements = this.fromChildren(lookup, configuration, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof String) {
                PlexusConfiguration xml = ArrayConverter.csvToXml(configuration, (String)value);
                elements = this.fromChildren(lookup, xml, type, enclosingType, loader, evaluator, listener, elementType);
            } else if (value instanceof Collection) {
                elements = (Collection<Object>)value;
            } else {
                this.failIfNotTypeCompatible(value, type, configuration);
                elements = Collections.emptyList();
            }
            return elements.toArray((Object[])Array.newInstance(type.getComponentType(), elements.size()));
        }
        catch (ComponentConfigurationException e) {
            if (null == e.getFailedConfiguration()) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
        catch (ArrayStoreException e) {
            throw new ComponentConfigurationException(configuration, "Cannot store value into array", e);
        }
    }

    @Override
    protected final Collection<Object> instantiateCollection(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) {
        return new ArrayList<Object>(configuration.getChildCount());
    }

    private static Type findElementType(Class<?> rawArrayType, Type[] typeArguments) {
        if (null != typeArguments && typeArguments.length > 0) {
            return typeArguments[0];
        }
        return rawArrayType.getComponentType();
    }
}

