/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.launch;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Guice;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.MutableBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.space.BeanScanning;
import org.jetbrains.kotlin.org.eclipse.sisu.space.ClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.space.SpaceModule;
import org.jetbrains.kotlin.org.eclipse.sisu.space.URLClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ParameterKeys;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.WireModule;
import org.junit.After;
import org.junit.Before;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class InjectedTest
implements Module {
    private String basedir;
    @Inject
    private MutableBeanLocator locator;

    @Before
    @BeforeMethod
    @BeforeEach
    public void setUp() throws Exception {
        Guice.createInjector(new WireModule(new SetUpModule(), this.spaceModule()));
    }

    @After
    @AfterMethod
    @AfterEach
    public void tearDown() throws Exception {
        this.locator.clear();
    }

    public SpaceModule spaceModule() {
        return new SpaceModule(this.space(), this.scanning());
    }

    public ClassSpace space() {
        return new URLClassSpace(this.getClass().getClassLoader());
    }

    public BeanScanning scanning() {
        return BeanScanning.CACHE;
    }

    @Override
    public void configure(Binder binder) {
    }

    public void configure(Properties properties) {
    }

    public final <T> T lookup(Class<T> type) {
        return this.lookup(Key.get(type));
    }

    public final <T> T lookup(Class<T> type, String name) {
        return this.lookup(type, Names.named(name));
    }

    public final <T> T lookup(Class<T> type, Class<? extends Annotation> qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final <T> T lookup(Class<T> type, Annotation qualifier) {
        return this.lookup(Key.get(type, qualifier));
    }

    public final String getBasedir() {
        if (null == this.basedir) {
            this.basedir = System.getProperty("basedir", new File("").getAbsolutePath());
        }
        return this.basedir;
    }

    private <T> T lookup(Key<T> key) {
        Iterator i = this.locator.locate(key).iterator();
        return i.hasNext() ? (T)((Map.Entry)i.next()).getValue() : null;
    }

    final class SetUpModule
    implements Module {
        SetUpModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.install(InjectedTest.this);
            Properties properties = new Properties();
            properties.put("basedir", InjectedTest.this.getBasedir());
            InjectedTest.this.configure(properties);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(properties);
            binder.requestInjection(InjectedTest.this);
        }
    }
}

