/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.space;

import org.jetbrains.kotlin.org.eclipse.sisu.space.Tokens;

public enum GlobberStrategy {
    ANYTHING{

        @Override
        public final String compile(String glob) {
            return null;
        }

        @Override
        public final boolean matches(String globPattern, String name) {
            return true;
        }
    }
    ,
    SUFFIX{

        @Override
        public final String compile(String glob) {
            return glob.substring(1);
        }

        @Override
        public final boolean matches(String globPattern, String name) {
            return name.endsWith(globPattern);
        }
    }
    ,
    PREFIX{

        @Override
        public final String compile(String glob) {
            return glob.substring(0, glob.length() - 1);
        }

        @Override
        public final boolean matches(String globPattern, String name) {
            return name.startsWith(globPattern);
        }
    }
    ,
    EXACT{

        @Override
        public final boolean matches(String globPattern, String name) {
            return globPattern.equals(name);
        }
    }
    ,
    PATTERN{

        @Override
        public final boolean matches(String globPattern, String name) {
            int checkIndex = 0;
            for (String token : Tokens.splitByStar(globPattern)) {
                if (checkIndex == 0 && globPattern.charAt(0) != '*') {
                    if (!name.startsWith(token)) {
                        return false;
                    }
                    checkIndex = token.length();
                    continue;
                }
                int matchIndex = name.indexOf(token, checkIndex);
                if (matchIndex < 0) {
                    return false;
                }
                checkIndex = matchIndex + token.length();
            }
            return checkIndex == name.length() || globPattern.charAt(globPattern.length() - 1) == '*';
        }
    };


    public static final GlobberStrategy selectFor(String glob) {
        if (null == glob || "*".equals(glob)) {
            return ANYTHING;
        }
        int firstWildcard = glob.indexOf(42);
        if (firstWildcard < 0) {
            return EXACT;
        }
        int lastWildcard = glob.lastIndexOf(42);
        if (firstWildcard == lastWildcard) {
            if (firstWildcard == 0) {
                return SUFFIX;
            }
            if (lastWildcard == glob.length() - 1) {
                return PREFIX;
            }
        }
        return PATTERN;
    }

    public String compile(String glob) {
        return glob;
    }

    public abstract boolean matches(String var1, String var2);

    public final boolean basenameMatches(String globPattern, String path) {
        if (this == ANYTHING || this == SUFFIX) {
            return this.matches(globPattern, path);
        }
        return this.matches(globPattern, path.substring(1 + path.lastIndexOf(47)));
    }
}

