/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@PhaseDescription(name="ReplaceKFunctionInvokeWithFunctionInvoke")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ReplaceKFunctionInvokeWithFunctionInvoke;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "implicitCastKFunctionReceiverIntoFunctionIfNeeded", "parentClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "backend.jvm.lower"})
public final class ReplaceKFunctionInvokeWithFunctionInvoke
extends IrVisitorVoid
implements FileLoweringPass {
    public ReplaceKFunctionInvokeWithFunctionInvoke(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)irFile), (IrVisitorVoid)this);
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren((IrElementVisitor)this, null);
    }

    /*
     * WARNING - void declaration
     */
    public void visitCall(@NotNull IrCall expression2) {
        IrTypeOperatorCallImpl irTypeOperatorCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        expression2.acceptChildren((IrElementVisitor)this, null);
        IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
        if (!Intrinsics.areEqual((Object)callee.getName(), (Object)OperatorNameConventions.INVOKE)) {
            return;
        }
        IrDeclarationParent irDeclarationParent = callee.getParent();
        IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
        if (irClass == null) {
            return;
        }
        IrClass parentClass = irClass;
        if (!IrTypeUtilsKt.isKFunction((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)parentClass))) && !IrTypeUtilsKt.isKSuspendFunction((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)parentClass)))) {
            this.implicitCastKFunctionReceiverIntoFunctionIfNeeded(expression2, parentClass);
            return;
        }
        expression2.setSymbol((IrSimpleFunctionSymbol)CollectionsKt.single((List)callee.getOverriddenSymbols()));
        IrCall irCall = expression2;
        IrExpression irExpression = expression2.getDispatchReceiver();
        if (irExpression != null) {
            void it;
            IrExpression irExpression2 = irExpression;
            IrCall irCall2 = irCall;
            boolean bl = false;
            IrSimpleType newType = IrUtilsKt.getDefaultType((IrClass)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)expression2.getSymbol().getOwner())));
            irTypeOperatorCallImpl = BuildersKt.IrTypeOperatorCallImpl((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)((IrType)newType), (IrTypeOperator)IrTypeOperator.IMPLICIT_CAST, (IrType)((IrType)newType), (IrExpression)it);
            irCall = irCall2;
        } else {
            irTypeOperatorCallImpl = null;
        }
        irCall.setDispatchReceiver((IrExpression)irTypeOperatorCallImpl);
    }

    private final void implicitCastKFunctionReceiverIntoFunctionIfNeeded(IrCall expression2, IrClass parentClass) {
        IrExpression receiver = expression2.getDispatchReceiver();
        if (receiver != null && (IrTypeUtilsKt.isKFunction((IrType)receiver.getType()) || IrTypeUtilsKt.isKSuspendFunction((IrType)receiver.getType()))) {
            IrSimpleType newType = IrUtilsKt.getDefaultType((IrClass)parentClass);
            expression2.setDispatchReceiver((IrExpression)BuildersKt.IrTypeOperatorCallImpl((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)((IrType)newType), (IrTypeOperator)IrTypeOperator.IMPLICIT_CAST, (IrType)((IrType)newType), (IrExpression)receiver));
        }
    }
}

