/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.backend.common.ir.ValueRemapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.ES6ConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrJsUtilsKt;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ES6SyntheticPrimaryConstructorLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "generateInitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nES6ConstructorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ES6ConstructorLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6SyntheticPrimaryConstructorLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,376:1\n238#2,4:377\n*S KotlinDebug\n*F\n+ 1 ES6ConstructorLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ES6SyntheticPrimaryConstructorLowering\n*L\n118#1:377,4\n*E\n"})
public final class ES6SyntheticPrimaryConstructorLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;

    public ES6SyntheticPrimaryConstructorLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.context.getEs6mode() || !(declaration instanceof IrConstructor) || IrJsUtilsKt.hasStrictSignature((IrConstructor)declaration, this.context)) {
            return null;
        }
        if (!PrimaryConstructorLoweringKt.isSyntheticPrimaryConstructor(declaration)) {
            return null;
        }
        return CollectionsKt.listOf((Object)this.generateInitFunction((IrConstructor)declaration));
    }

    private final IrSimpleFunction generateInitFunction(IrConstructor $this$generateInitFunction) {
        IrSimpleFunction irSimpleFunction;
        IrConstructor constructor = $this$generateInitFunction;
        IrClass irClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$generateInitFunction));
        String constructorName = "init_" + ES6ConstructorLoweringKt.access$getConstructorPostfix(irClass);
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$generateInitFunction_u24lambda_u240 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl2 = false;
        $this$generateInitFunction_u24lambda_u240.setName(Name.identifier((String)constructorName));
        $this$generateInitFunction_u24lambda_u240.setReturnType(this.context.getIrBuiltIns().getUnitType());
        $this$generateInitFunction_u24lambda_u240.setVisibility(DescriptorVisibilities.PRIVATE);
        $this$generateInitFunction_u24lambda_u240.setModality(Modality.FINAL);
        $this$generateInitFunction_u24lambda_u240.setInline(constructor.isInline());
        $this$generateInitFunction_u24lambda_u240.setExternal(constructor.isExternal());
        $this$generateInitFunction_u24lambda_u240.setOrigin((IrDeclarationOrigin)ES6ConstructorLoweringKt.getES6_INIT_FUNCTION());
        IrSimpleFunction factory = irSimpleFunction = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv);
        boolean bl3 = false;
        factory.setParent((IrDeclarationParent)irClass);
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)factory), (IrTypeParametersContainer)((IrTypeParametersContainer)irClass), null, null, (int)6, null);
        factory.setAnnotations($this$generateInitFunction.getAnnotations());
        IrValueParameter irValueParameter = irClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrValueParameter thisParameter = IrUtilsKt.copyTo$default((IrValueParameter)irValueParameter, (IrFunction)((IrFunction)factory), null, (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (IrParameterKind)IrParameterKind.ExtensionReceiver, (int)4094, null);
        factory.setParameters(CollectionsKt.listOf((Object)thisParameter));
        factory.setBody(constructor.getBody());
        IrBody irBody = factory.getBody();
        if (irBody != null) {
            IrElement irElement = (IrElement)irBody;
            IrValueParameter irValueParameter2 = irClass.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)irElement, (IrElementTransformerVoid)((IrElementTransformerVoid)new ValueRemapper(MapsKt.mapOf((Pair)TuplesKt.to((Object)irValueParameter2.getSymbol(), (Object)thisParameter.getSymbol())))));
        }
        IrBody irBody2 = factory.getBody();
        if (irBody2 != null) {
            IrBody cfr_ignored_0 = (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)irBody2), (IrDeclarationParent)((IrDeclarationParent)factory));
        }
        JsIrAttributesKt.setConstructorFactory($this$generateInitFunction, factory);
        return irSimpleFunction;
    }
}

