/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCase;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDefault;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFor;
import org.jetbrains.kotlin.js.backend.ast.JsForIn;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsIf;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLabel;
import org.jetbrains.kotlin.js.backend.ast.JsLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsLoop;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsSwitch;
import org.jetbrains.kotlin.js.backend.ast.JsSwitchMember;
import org.jetbrains.kotlin.js.backend.ast.JsThrow;
import org.jetbrains.kotlin.js.backend.ast.JsTry;
import org.jetbrains.kotlin.js.backend.ast.JsUnaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.JsWhile;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.inline.clean.TemporaryVariableElimination;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001a\u001a\u00020\u0013J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010\u001e\u001a\u00020\u001cH\u0002J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u000eH\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\nH\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;", "", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;)V", "root", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "definitions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "", "usages", "definedValues", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "temporary", "", "capturedInClosure", "hasChanges", "", "localVariables", "", "namesToSubstitute", "statementsToRemove", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "namesWithSideEffects", "apply", "analyze", "", "perform", "cleanUp", "assignVariable", "name", "value", "useVariable", "shouldConsiderUnused", "shouldConsiderTemporary", "isTrivial", "expr", "SubstitutionCandidateFinder", "js.translator"})
@SourceDebugExtension(value={"SMAP\nTemporaryVariableElimination.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TemporaryVariableElimination.kt\norg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,658:1\n1#2:659\n1740#3,3:660\n*S KotlinDebug\n*F\n+ 1 TemporaryVariableElimination.kt\norg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination\n*L\n654#1:660,3\n*E\n"})
public final class TemporaryVariableElimination {
    @NotNull
    private final JsFunction function;
    @NotNull
    private final JsBlock root;
    @NotNull
    private final Map<JsName, Integer> definitions;
    @NotNull
    private final Map<JsName, Integer> usages;
    @NotNull
    private final Map<JsName, JsExpression> definedValues;
    @NotNull
    private final Set<JsName> temporary;
    @NotNull
    private final Set<JsName> capturedInClosure;
    private boolean hasChanges;
    @NotNull
    private final Set<JsName> localVariables;
    @NotNull
    private final Set<JsName> namesToSubstitute;
    @NotNull
    private final Set<JsNode> statementsToRemove;
    @NotNull
    private final Set<JsName> namesWithSideEffects;

    public TemporaryVariableElimination(@NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        this.function = function2;
        JsBlock jsBlock = this.function.getBody();
        Intrinsics.checkNotNullExpressionValue((Object)jsBlock, (String)"getBody(...)");
        this.root = jsBlock;
        this.definitions = new LinkedHashMap();
        this.usages = new LinkedHashMap();
        this.definedValues = new LinkedHashMap();
        this.temporary = new LinkedHashSet();
        this.capturedInClosure = new LinkedHashSet();
        this.localVariables = CollectUtilsKt.collectLocalVariables$default(this.function, false, 1, null);
        this.namesToSubstitute = new LinkedHashSet();
        this.statementsToRemove = new LinkedHashSet();
        this.namesWithSideEffects = new LinkedHashSet();
    }

    public final boolean apply() {
        this.analyze();
        this.perform();
        this.cleanUp();
        return this.hasChanges;
    }

    private final void analyze() {
        new RecursiveJsVisitor(this){
            private final Set<JsName> currentScope;
            private Set<JsName> localVars;
            final /* synthetic */ TemporaryVariableElimination this$0;
            {
                this.this$0 = $receiver;
                List<JsParameter> list = TemporaryVariableElimination.access$getFunction$p($receiver).getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
                this.currentScope = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), analyze.1::currentScope$lambda$0));
                this.localVars = new LinkedHashSet<E>();
            }

            public final Set<JsName> getCurrentScope() {
                return this.currentScope;
            }

            public final Set<JsName> getLocalVars() {
                return this.localVars;
            }

            public final void setLocalVars(Set<JsName> set) {
                Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
                this.localVars = set;
            }

            public void visitExpressionStatement(JsExpressionStatement x) {
                JsBinaryOperation jsBinaryOperation;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                JsBinaryOperation jsBinaryOperation2 = jsBinaryOperation = jsExpression instanceof JsBinaryOperation ? (JsBinaryOperation)jsExpression : null;
                if (jsBinaryOperation != null) {
                    JsBinaryOperation expression2 = jsBinaryOperation;
                    boolean bl = false;
                    this.processBinaryExpression(expression2, MetadataProperties.getSynthetic(x), (Function0<Unit>)((Function0)() -> analyze.1.visitExpressionStatement$lambda$2$lambda$1(this, x)));
                    return;
                }
                super.visitExpressionStatement(x);
            }

            public void visitBinaryExpression(JsBinaryOperation x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.processBinaryExpression(x, false, (Function0<Unit>)((Function0)() -> analyze.1.visitBinaryExpression$lambda$3(this, x)));
            }

            private final void processBinaryExpression(JsBinaryOperation expression2, boolean synthetic, Function0<Unit> orElse) {
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    JsName name = (JsName)assignment.component1();
                    JsExpression value = (JsExpression)assignment.component2();
                    if (TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) {
                        Intrinsics.checkNotNull((Object)name);
                        Intrinsics.checkNotNull((Object)value);
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name, value);
                        this.addVar(name);
                        this.accept((JsNode)value);
                        if (synthetic) {
                            ((Collection)TemporaryVariableElimination.access$getTemporary$p(this.this$0)).add(name);
                        }
                        return;
                    }
                }
                orElse.invoke();
            }

            public void visitVars(JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsName name = v.getName();
                    JsExpression value = v.getInitExpression();
                    if (!TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) continue;
                    if (MetadataProperties.getSynthetic(x)) {
                        ((Collection)TemporaryVariableElimination.access$getTemporary$p(this.this$0)).add(name);
                    }
                    if (value == null) continue;
                    Intrinsics.checkNotNull((Object)name);
                    TemporaryVariableElimination.access$assignVariable(this.this$0, name, value);
                    this.addVar(name);
                    this.accept((JsNode)value);
                }
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                JsName name = nameRef.getName();
                if (name != null && TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, name);
                    if (!this.currentScope.contains(name)) {
                        JsExpression jsExpression = Namer.getUndefinedExpression();
                        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getUndefinedExpression(...)");
                        TemporaryVariableElimination.access$assignVariable(this.this$0, name, jsExpression);
                    }
                    return;
                }
                super.visitNameRef(nameRef);
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitObjectLiteral(JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                for (JsPropertyInitializer initializer : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer.getValueExpr());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitLoop(JsLoop x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.localVars;
                try {
                    this_$iv.localVars = new LinkedHashSet<E>();
                    boolean bl = false;
                    super.visitLoop(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    CollectionsKt.removeAll((Collection)this_$iv.currentScope, (Iterable)this_$iv.localVars);
                    this_$iv.localVars = localVarsBackup$iv;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitIf(JsIf x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.accept((JsNode)x.getIfExpression());
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.localVars;
                try {
                    this_$iv.localVars = new LinkedHashSet<E>();
                    boolean bl = false;
                    this.accept((JsNode)x.getThenStatement());
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    CollectionsKt.removeAll((Collection)this_$iv.currentScope, (Iterable)this_$iv.localVars);
                    this_$iv.localVars = localVarsBackup$iv;
                }
                JsStatement jsStatement = x.getElseStatement();
                if (jsStatement != null) {
                    JsStatement it = jsStatement;
                    boolean bl = false;
                    analyze.1 this_$iv2 = this;
                    boolean $i$f$withNewScope2 = false;
                    Set<JsName> localVarsBackup$iv2 = this_$iv2.localVars;
                    try {
                        this_$iv2.localVars = new LinkedHashSet<E>();
                        boolean bl2 = false;
                        this.accept((JsNode)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        CollectionsKt.removeAll((Collection)this_$iv2.currentScope, (Iterable)this_$iv2.localVars);
                        this_$iv2.localVars = localVarsBackup$iv2;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCase(JsCase x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.localVars;
                try {
                    this_$iv.localVars = new LinkedHashSet<E>();
                    boolean bl = false;
                    super.visitCase(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    CollectionsKt.removeAll((Collection)this_$iv.currentScope, (Iterable)this_$iv.localVars);
                    this_$iv.localVars = localVarsBackup$iv;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitDefault(JsDefault x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.localVars;
                try {
                    this_$iv.localVars = new LinkedHashSet<E>();
                    boolean bl = false;
                    super.visitDefault(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    CollectionsKt.removeAll((Collection)this_$iv.currentScope, (Iterable)this_$iv.localVars);
                    this_$iv.localVars = localVarsBackup$iv;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitCatch(JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                analyze.1 this_$iv = this;
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup$iv = this_$iv.localVars;
                try {
                    this_$iv.localVars = new LinkedHashSet<E>();
                    boolean bl = false;
                    super.visitCatch(x);
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    CollectionsKt.removeAll((Collection)this_$iv.currentScope, (Iterable)this_$iv.localVars);
                    this_$iv.localVars = localVarsBackup$iv;
                }
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                for (JsName freeVar : CollectUtilsKt.collectFreeVariables(x)) {
                    TemporaryVariableElimination.access$useVariable(this.this$0, freeVar);
                    TemporaryVariableElimination.access$useVariable(this.this$0, freeVar);
                    ((Collection)TemporaryVariableElimination.access$getCapturedInClosure$p(this.this$0)).add(freeVar);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final <T> T withNewScope(Function0<? extends T> block) {
                boolean $i$f$withNewScope = false;
                Set<JsName> localVarsBackup = this.localVars;
                try {
                    this.localVars = new LinkedHashSet<E>();
                    Object object = block.invoke();
                    return (T)object;
                }
                finally {
                    InlineMarker.finallyStart((int)1);
                    CollectionsKt.removeAll((Collection)this.currentScope, (Iterable)this.localVars);
                    this.localVars = localVarsBackup;
                    InlineMarker.finallyEnd((int)1);
                }
            }

            private final void addVar(JsName name) {
                ((Collection)this.currentScope).add(name);
                this.localVars.add(name);
            }

            private static final JsName currentScope$lambda$0(JsParameter it) {
                return it.getName();
            }

            private static final Unit visitExpressionStatement$lambda$2$lambda$1(analyze.1 this$0, JsExpressionStatement $x) {
                super.visitExpressionStatement($x);
                return Unit.INSTANCE;
            }

            private static final Unit visitBinaryExpression$lambda$3(analyze.1 this$0, JsBinaryOperation $x) {
                super.visitBinaryExpression($x);
                return Unit.INSTANCE;
            }
        }.accept((JsNode)this.root);
    }

    private final void perform() {
        new RecursiveJsVisitor(this){
            private final List<Pair<JsName, JsNode>> lastAssignedVars;
            final /* synthetic */ TemporaryVariableElimination this$0;
            {
                this.this$0 = $receiver;
                this.lastAssignedVars = new ArrayList<E>();
            }

            public final List<Pair<JsName, JsNode>> getLastAssignedVars() {
                return this.lastAssignedVars;
            }

            public void visitExpressionStatement(JsExpressionStatement x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                JsExpression expression2 = jsExpression;
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(expression2);
                if (assignment != null) {
                    JsName name = (JsName)assignment.component1();
                    JsExpression value = (JsExpression)assignment.component2();
                    Intrinsics.checkNotNull((Object)name);
                    Intrinsics.checkNotNull((Object)value);
                    this.handleDefinition(name, value, x);
                } else if (this.handleExpression(expression2)) {
                    this.invalidateTemporaries();
                }
            }

            public void visitVars(JsVars x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                for (JsVars.JsVar v : x.getVars()) {
                    JsExpression initializer = v.getInitExpression();
                    if (initializer == null) continue;
                    JsName jsName = v.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                    Intrinsics.checkNotNull((Object)v);
                    this.handleDefinition(jsName, initializer, v);
                }
            }

            private final void handleDefinition(JsName name, JsExpression value, JsNode node) {
                boolean sideEffects;
                boolean isAssigment = node instanceof JsExpressionStatement && JsAstUtils.decomposeAssignment(((JsExpressionStatement)node).getExpression()) != null;
                boolean bl = sideEffects = this.handleExpression(value) || !TemporaryVariableElimination.access$getLocalVariables$p(this.this$0).contains(name) || isAssigment;
                if (TemporaryVariableElimination.access$shouldConsiderTemporary(this.this$0, name)) {
                    if (TemporaryVariableElimination.access$isTrivial(this.this$0, value)) {
                        ((Collection)TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0)).add(node);
                        ((Collection)TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0)).add(name);
                    } else {
                        ((Collection)this.lastAssignedVars).add(new Pair((Object)name, (Object)node));
                        if (sideEffects) {
                            ((Collection)TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0)).add(name);
                        }
                    }
                } else if (sideEffects) {
                    this.invalidateTemporaries();
                } else {
                    this.invalidateTemporariesUsingName(name);
                }
            }

            public void visitIf(JsIf x) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    JsExpression jsExpression = x.getIfExpression();
                    Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getIfExpression(...)");
                    this.handleExpression(jsExpression);
                    this.invalidateTemporaries();
                    this.accept((JsNode)x.getThenStatement());
                    this.invalidateTemporaries();
                    JsStatement jsStatement = x.getElseStatement();
                    if (jsStatement == null) break block0;
                    JsStatement it = jsStatement;
                    boolean bl = false;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitReturn(JsReturn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                if (jsExpression != null) {
                    JsExpression it = jsExpression;
                    boolean bl = false;
                    this.handleExpression(it);
                }
                this.invalidateTemporaries();
            }

            public void visitThrow(JsThrow x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
            }

            public void visit(JsSwitch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                List<JsSwitchMember> list = x.getCases();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getCases(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsSwitchMember it = (JsSwitchMember)element$iv;
                    boolean bl = false;
                    this.accept((JsNode)it);
                    this.invalidateTemporaries();
                }
            }

            public void visitObjectLiteral(JsObjectLiteral x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                for (JsPropertyInitializer initializer : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer.getValueExpr());
                }
            }

            public void visitWhile(JsWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitWhile(x);
                this.invalidateTemporaries();
            }

            public void visitDoWhile(JsDoWhile x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitDoWhile(x);
                this.invalidateTemporaries();
            }

            public void visitForIn(JsForIn x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsExpression jsExpression = x.getObjectExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getObjectExpression(...)");
                this.handleExpression(jsExpression);
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitFor(JsFor x) {
                SourceInfoAwareJsNode it;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsVars jsVars = x.getInitVars();
                if (jsVars != null) {
                    it = jsVars;
                    boolean bl = false;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression = x.getInitExpression();
                if (jsExpression != null) {
                    it = jsExpression;
                    boolean bl = false;
                    this.handleExpression((JsExpression)it);
                }
                this.invalidateTemporaries();
                JsExpression jsExpression2 = x.getCondition();
                if (jsExpression2 != null) {
                    it = jsExpression2;
                    boolean bl = false;
                    this.accept((JsNode)it);
                }
                JsExpression jsExpression3 = x.getIncrementExpression();
                if (jsExpression3 != null) {
                    it = jsExpression3;
                    boolean bl = false;
                    this.accept((JsNode)it);
                }
                this.invalidateTemporaries();
                this.accept((JsNode)x.getBody());
                this.invalidateTemporaries();
            }

            public void visitTry(JsTry x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitTry(x);
                this.invalidateTemporaries();
            }

            public void visitCatch(JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitCatch(x);
                this.invalidateTemporaries();
            }

            public void visitLabel(JsLabel x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
                super.visitLabel(x);
                this.invalidateTemporaries();
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.invalidateTemporaries();
            }

            private final void invalidateTemporaries() {
                this.lastAssignedVars.clear();
            }

            private final void invalidateTemporariesUsingName(JsName name) {
                CollectionsKt.removeAll(this.lastAssignedVars, arg_0 -> perform.1.invalidateTemporariesUsingName$lambda$7(name, arg_0));
            }

            private final boolean handleExpression(JsExpression expression2) {
                SubstitutionCandidateFinder candidateFinder = this.this$0.new SubstitutionCandidateFinder();
                candidateFinder.accept((JsNode)expression2);
                List<JsName> candidates = candidateFinder.getSubstitutableVariableReferences();
                while (!((Collection)this.lastAssignedVars).isEmpty()) {
                    Pair pair = (Pair)CollectionsKt.last(this.lastAssignedVars);
                    JsName assignedVar = (JsName)pair.component1();
                    JsNode assignedStatement = (JsNode)pair.component2();
                    int candidateIndex = candidates.lastIndexOf(assignedVar);
                    if (candidateIndex < 0) break;
                    ((Collection)TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0)).add(assignedVar);
                    ((Collection)TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0)).add(assignedStatement);
                    if (TemporaryVariableElimination.access$getNamesWithSideEffects$p(this.this$0).contains(assignedVar)) {
                        candidateFinder.setSideEffectOccurred(true);
                    }
                    candidates = candidates.subList(0, candidateIndex);
                    this.lastAssignedVars.remove(CollectionsKt.getLastIndex(this.lastAssignedVars));
                }
                return candidateFinder.getSideEffectOccurred();
            }

            private static final boolean invalidateTemporariesUsingName$lambda$7(JsName $name, Pair pair) {
                Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
                JsNode expr = (JsNode)pair.component2();
                Ref.BooleanRef nameUsed = new Ref.BooleanRef();
                new RecursiveJsVisitor($name, nameUsed){
                    final /* synthetic */ JsName $name;
                    final /* synthetic */ Ref.BooleanRef $nameUsed;
                    {
                        this.$name = $name;
                        this.$nameUsed = $nameUsed;
                    }

                    public void visitNameRef(JsNameRef nameRef) {
                        Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                        if (Intrinsics.areEqual((Object)nameRef.getName(), (Object)this.$name)) {
                            this.$nameUsed.element = true;
                        }
                        super.visitNameRef(nameRef);
                    }
                }.accept(expr);
                return nameUsed.element;
            }
        }.accept((JsNode)this.root);
    }

    private final void cleanUp() {
        new JsVisitorWithContextImpl(this){
            final /* synthetic */ TemporaryVariableElimination this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(JsVars x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                List<JsVars.JsVar> list = x.getVars();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getVars(...)");
                Collection collection = list;
                Collection collection2 = TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0);
                if (TypeIntrinsics.asMutableCollection((Object)collection).removeAll(collection2)) {
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                }
                List<JsVars.JsVar> list2 = x.getVars();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getVars(...)");
                List<Pair<List<JsVars.JsVar>, S>> ranges = UtilsKt.splitToRanges(list2, arg_0 -> cleanUp.1.visit$lambda$0(this.this$0, arg_0));
                if (ranges.size() == 1 && !((Boolean)ranges.get(0).getSecond()).booleanValue()) {
                    return super.visit(x, ctx);
                }
                TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                for (Pair pair : ranges) {
                    void $this$visit_u24lambda_u244;
                    JsContext<JsNode> jsContext;
                    Object element$iv;
                    Object $this$mapNotNullTo$iv$iv;
                    List subList = (List)pair.component1();
                    boolean isRemoved = (Boolean)pair.component2();
                    Iterable $this$mapNotNull$iv = subList;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        JsExpression it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator2.next();
                        boolean bl = false;
                        JsVars.JsVar it = (JsVars.JsVar)element$iv$iv;
                        boolean bl2 = false;
                        if (it.getInitExpression() == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List initializers = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = initializers;
                    boolean $i$f$forEach2 = false;
                    $this$mapNotNullTo$iv$iv = $this$forEach$iv.iterator();
                    while ($this$mapNotNullTo$iv$iv.hasNext()) {
                        element$iv = $this$mapNotNullTo$iv$iv.next();
                        JsExpression it = (JsExpression)element$iv;
                        boolean bl = false;
                        this.accept((JsNode)it);
                    }
                    if (isRemoved) {
                        for (JsExpression initializer : initializers) {
                            void $this$visit_u24lambda_u243;
                            $this$mapNotNullTo$iv$iv = new JsExpressionStatement((JsExpression)this.accept((JsNode)initializer));
                            element$iv = $this$mapNotNullTo$iv$iv;
                            jsContext = ctx;
                            boolean bl = false;
                            MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u243, true);
                            jsContext.addPrevious((JsNode)$this$mapNotNullTo$iv$iv);
                        }
                        continue;
                    }
                    Object $this$toTypedArray$iv = subList;
                    boolean $i$f$toTypedArray = false;
                    Object thisCollection$iv = $this$toTypedArray$iv;
                    Object object = thisCollection$iv.toArray(new JsVars.JsVar[0]);
                    $this$toTypedArray$iv = object = new JsVars(Arrays.copyOf(object, ((JsVars.JsVar[])object).length));
                    jsContext = ctx;
                    boolean bl = false;
                    MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u244, true);
                    jsContext.addPrevious((JsNode)object);
                }
                ctx.removeMe();
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(JsExpressionStatement x, JsContext<JsNode> ctx) {
                Pair<JsName, JsExpression> assignment;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                if (TemporaryVariableElimination.access$getStatementsToRemove$p(this.this$0).contains(x)) {
                    ctx.removeMe();
                    TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                    return false;
                }
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getExpression(...)");
                JsExpression expression2 = jsExpression;
                if (expression2 instanceof JsNameRef && ((JsNameRef)expression2).getQualifier() == null && CollectionsKt.contains((Iterable)TemporaryVariableElimination.access$getLocalVariables$p(this.this$0), (Object)((JsNameRef)expression2).getName())) {
                    MetadataProperties.setSynthetic(x, true);
                }
                if ((assignment = JsAstUtils.decomposeAssignmentToVariable(expression2)) != null) {
                    JsName name = (JsName)assignment.component1();
                    JsExpression value = (JsExpression)assignment.component2();
                    Intrinsics.checkNotNull((Object)name);
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, name)) {
                        void $this$visit_u24lambda_u245;
                        TemporaryVariableElimination.access$setHasChanges$p(this.this$0, true);
                        JsNode jsNode = this.accept((JsNode)new JsExpressionStatement(value));
                        JsExpressionStatement jsExpressionStatement = (JsExpressionStatement)jsNode;
                        JsContext<JsNode> jsContext = ctx;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)$this$visit_u24lambda_u245);
                        MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u245, true);
                        jsContext.replaceMe(jsNode);
                        return false;
                    }
                }
                return super.visit(x, ctx);
            }

            public boolean visit(JsObjectLiteral x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                for (JsPropertyInitializer initializer : x.getPropertyInitializers()) {
                    this.accept((JsNode)initializer.getValueExpr());
                }
                return super.visit(x, ctx);
            }

            /*
             * WARNING - void declaration
             */
            public boolean visit(JsNameRef x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                JsName name = x.getName();
                if (name != null && x.getQualifier() == null && TemporaryVariableElimination.access$getNamesToSubstitute$p(this.this$0).contains(name)) {
                    void $this$visit_u24lambda_u246;
                    JsExpression jsExpression;
                    V v = TemporaryVariableElimination.access$getDefinedValues$p(this.this$0).get(name);
                    Intrinsics.checkNotNull(v);
                    JsExpression replacement = (JsExpression)this.accept((JsNode)v);
                    JsExpression jsExpression2 = jsExpression = replacement.deepCopy();
                    JsContext<JsNode> jsContext = ctx;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)$this$visit_u24lambda_u246);
                    MetadataProperties.setSynthetic((HasMetadata)$this$visit_u24lambda_u246, true);
                    jsContext.replaceMe((JsNode)jsExpression);
                    return false;
                }
                return super.visit(x, ctx);
            }

            public boolean visit(JsFunction x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(JsBreak x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            public boolean visit(JsContinue x, JsContext<?> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public void endVisit(JsBinaryOperation x, JsContext<JsNode> ctx) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
                Pair<JsName, JsExpression> assignment = JsAstUtils.decomposeAssignmentToVariable(x);
                if (assignment != null) {
                    JsName name = (JsName)assignment.getFirst();
                    Intrinsics.checkNotNull((Object)name);
                    if (TemporaryVariableElimination.access$shouldConsiderUnused(this.this$0, name)) {
                        void $this$endVisit_u24lambda_u247;
                        JsNode jsNode = this.accept((JsNode)x.getArg2());
                        JsExpression jsExpression = (JsExpression)jsNode;
                        JsContext<JsNode> jsContext = ctx;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)$this$endVisit_u24lambda_u247);
                        MetadataProperties.setSynthetic((HasMetadata)$this$endVisit_u24lambda_u247, true);
                        jsContext.replaceMe(jsNode);
                    }
                }
                super.endVisit(x, ctx);
            }

            private static final boolean visit$lambda$0(TemporaryVariableElimination this$0, JsVars.JsVar it) {
                JsName jsName = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                return TemporaryVariableElimination.access$shouldConsiderUnused(this$0, jsName);
            }
        }.accept((JsNode)this.root);
    }

    private final void assignVariable(JsName name, JsExpression value) {
        Map<JsName, Integer> map = this.definitions;
        Integer n = this.definitions.get(name);
        Integer n2 = (n != null ? n : 0) + 1;
        map.put(name, n2);
        this.definedValues.put(name, value);
    }

    private final void useVariable(JsName name) {
        Map<JsName, Integer> map = this.usages;
        Integer n = this.usages.get(name);
        Integer n2 = (n != null ? n : 0) + 1;
        map.put(name, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderUnused(JsName name) {
        Integer n = this.definitions.get(name);
        if (n == null) return false;
        int n2 = n;
        if (n2 <= 0) return false;
        Integer n3 = this.usages.get(name);
        if ((n3 != null ? n3 : 0) != 0) return false;
        if (!this.temporary.contains(name)) return false;
        if (MetadataProperties.getImported(name)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldConsiderTemporary(JsName name) {
        Integer n = this.definitions.get(name);
        int n2 = 1;
        if (n == null) return false;
        if (n != n2) return false;
        if (!this.temporary.contains(name)) return false;
        if (this.capturedInClosure.contains(name)) {
            return false;
        }
        JsExpression expr = this.definedValues.get(name);
        if (expr != null) {
            if (this.isTrivial(expr)) return true;
        }
        Integer n3 = this.usages.get(name);
        int n4 = 1;
        if (n3 == null) return false;
        if (n3 != n4) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isTrivial(JsExpression expr) {
        JsExpression jsExpression = expr;
        if (jsExpression instanceof JsNameRef) {
            boolean bl;
            JsExpression qualifier = ((JsNameRef)expr).getQualifier();
            JsName jsName = ((JsNameRef)expr).getName();
            if (jsName != null) {
                if (MetadataProperties.getConstant(jsName)) {
                    return true;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) {
                return true;
            }
            if (MetadataProperties.getSideEffects(expr) == SideEffectKind.PURE && (qualifier == null || this.isTrivial(qualifier))) {
                if (CollectionsKt.contains((Iterable)this.temporary, (Object)((JsNameRef)expr).getName())) return false;
                return true;
            }
            JsName name = ((JsNameRef)expr).getName();
            if (!CollectionsKt.contains((Iterable)this.localVariables, (Object)name)) return false;
            Integer n = this.definitions.get(name);
            if (n == null) return true;
            if (n == 0) {
                return true;
            }
            int n2 = 1;
            if (n != n2) return false;
            if (!CollectionsKt.contains((Iterable)this.namesToSubstitute, (Object)name)) return true;
            JsExpression jsExpression2 = this.definedValues.get(name);
            if (jsExpression2 == null) return false;
            JsExpression it = jsExpression2;
            boolean bl2 = false;
            boolean bl3 = this.isTrivial(it);
            if (!bl3) return false;
            return true;
        }
        if (jsExpression instanceof JsLiteral.JsValueLiteral) {
            if (expr.toString().length() >= 10) return false;
            return true;
        }
        if (jsExpression instanceof JsInvocation) {
            JsExpression it;
            if (MetadataProperties.getSideEffects(expr) != SideEffectKind.PURE) return false;
            JsExpression jsExpression3 = ((JsInvocation)expr).getQualifier();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression3, (String)"getQualifier(...)");
            if (!this.isTrivial(jsExpression3)) return false;
            List<JsExpression> list = ((JsInvocation)expr).getArguments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                if (!iterator2.hasNext()) return true;
                Object element$iv = iterator2.next();
                it = (JsExpression)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
            } while (this.isTrivial(it));
            return false;
        }
        if (!(jsExpression instanceof JsArrayAccess)) return false;
        JsExpression jsExpression4 = ((JsArrayAccess)expr).getArrayExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression4, (String)"getArrayExpression(...)");
        if (!this.isTrivial(jsExpression4)) return false;
        JsExpression jsExpression5 = ((JsArrayAccess)expr).getIndexExpression();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression5, (String)"getIndexExpression(...)");
        if (!this.isTrivial(jsExpression5)) return false;
        if (MetadataProperties.getSideEffects(expr) != SideEffectKind.PURE) return false;
        return true;
    }

    public static final /* synthetic */ JsFunction access$getFunction$p(TemporaryVariableElimination $this) {
        return $this.function;
    }

    public static final /* synthetic */ void access$assignVariable(TemporaryVariableElimination $this, JsName name, JsExpression value) {
        $this.assignVariable(name, value);
    }

    public static final /* synthetic */ Set access$getTemporary$p(TemporaryVariableElimination $this) {
        return $this.temporary;
    }

    public static final /* synthetic */ void access$useVariable(TemporaryVariableElimination $this, JsName name) {
        $this.useVariable(name);
    }

    public static final /* synthetic */ Set access$getCapturedInClosure$p(TemporaryVariableElimination $this) {
        return $this.capturedInClosure;
    }

    public static final /* synthetic */ boolean access$isTrivial(TemporaryVariableElimination $this, JsExpression expr) {
        return $this.isTrivial(expr);
    }

    public static final /* synthetic */ Set access$getStatementsToRemove$p(TemporaryVariableElimination $this) {
        return $this.statementsToRemove;
    }

    public static final /* synthetic */ Set access$getNamesWithSideEffects$p(TemporaryVariableElimination $this) {
        return $this.namesWithSideEffects;
    }

    public static final /* synthetic */ void access$setHasChanges$p(TemporaryVariableElimination $this, boolean bl) {
        $this.hasChanges = bl;
    }

    public static final /* synthetic */ boolean access$shouldConsiderUnused(TemporaryVariableElimination $this, JsName name) {
        return $this.shouldConsiderUnused(name);
    }

    public static final /* synthetic */ Map access$getDefinedValues$p(TemporaryVariableElimination $this) {
        return $this.definedValues;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020(H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination$SubstitutionCandidateFinder;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "<init>", "(Lorg/jetbrains/kotlin/js/inline/clean/TemporaryVariableElimination;)V", "substitutableVariableReferences", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getSubstitutableVariableReferences", "()Ljava/util/List;", "sideEffectOccurred", "", "getSideEffectOccurred", "()Z", "setSideEffectOccurred", "(Z)V", "visitFunction", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitObjectLiteral", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "visitNew", "Lorg/jetbrains/kotlin/js/backend/ast/JsNew;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitConditional", "Lorg/jetbrains/kotlin/js/backend/ast/JsConditional;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitArray", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "js.translator"})
    private final class SubstitutionCandidateFinder
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsName> substitutableVariableReferences = new ArrayList();
        private boolean sideEffectOccurred;

        @NotNull
        public final List<JsName> getSubstitutableVariableReferences() {
            return this.substitutableVariableReferences;
        }

        public final boolean getSideEffectOccurred() {
            return this.sideEffectOccurred;
        }

        public final void setSideEffectOccurred(boolean bl) {
            this.sideEffectOccurred = bl;
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            for (JsPropertyInitializer initializer : x.getPropertyInitializers()) {
                this.accept((JsNode)initializer.getValueExpr());
            }
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitNew(@NotNull JsNew x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            super.visitNew(x);
            if (MetadataProperties.getSideEffects(x) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
            super.visitInvocation(invocation);
            if (MetadataProperties.getSideEffects(invocation) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            this.accept((JsNode)x.getTestExpression());
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            super.visitArrayAccess(x);
            if (MetadataProperties.getSideEffects(x) == SideEffectKind.AFFECTS_STATE) {
                this.sideEffectOccurred = true;
            }
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            super.visitArray(x);
            this.sideEffectOccurred = true;
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            super.visitPrefixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            switch (jsUnaryOperator == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()]) {
                case 1: 
                case 2: {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            super.visitPostfixOperation(x);
            JsUnaryOperator jsUnaryOperator = x.getOperator();
            switch (jsUnaryOperator == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsUnaryOperator.ordinal()]) {
                case 1: 
                case 2: {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
            JsName name = nameRef.getName();
            if (name != null && (TemporaryVariableElimination.this.localVariables.contains(name) || MetadataProperties.getConstant(name))) {
                if ((MetadataProperties.getConstant(name) || !TemporaryVariableElimination.this.namesToSubstitute.contains(name) && TemporaryVariableElimination.this.shouldConsiderTemporary(name)) && !this.sideEffectOccurred) {
                    ((Collection)this.substitutableVariableReferences).add(name);
                }
            } else {
                super.visitNameRef(nameRef);
                if (MetadataProperties.getSideEffects(nameRef) == SideEffectKind.AFFECTS_STATE) {
                    this.sideEffectOccurred = true;
                }
            }
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            if (x.getOperator() == JsBinaryOperator.ASG) {
                JsExpression left = x.getArg1();
                JsExpression right = x.getArg2();
                if (left instanceof JsNameRef) {
                    JsExpression qualifier = ((JsNameRef)left).getQualifier();
                    if (qualifier != null) {
                        this.accept((JsNode)qualifier);
                    }
                } else if (left instanceof JsArrayAccess) {
                    this.accept((JsNode)((JsArrayAccess)left).getArrayExpression());
                    this.accept((JsNode)((JsArrayAccess)left).getIndexExpression());
                }
                this.accept((JsNode)right);
                this.sideEffectOccurred = true;
            } else if (x.getOperator() == JsBinaryOperator.AND || x.getOperator() == JsBinaryOperator.OR) {
                this.accept((JsNode)x.getArg1());
                this.sideEffectOccurred = true;
                this.accept((JsNode)x.getArg2());
            } else {
                super.visitBinaryExpression(x);
            }
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[JsUnaryOperator.values().length];
                try {
                    nArray[JsUnaryOperator.INC.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[JsUnaryOperator.DEC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

