/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.parser.sourcemaps;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsDoWhile;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithEmbeddedSource;
import org.jetbrains.kotlin.js.backend.ast.JsLocationWithSource;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapGroup;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper$applySourceMap$;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSegment;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper;", "", "sourceMap", "Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;", "sourceMapPathMapper", "Lkotlin/Function1;", "", "<init>", "(Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMap;Lkotlin/jvm/functions/Function1;)V", "remap", "", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "applySourceMap", "nodes", "", "JsNodeFlatListCollector", "js.parser"})
@SourceDebugExtension(value={"SMAP\nSourceMapLocationRemapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapLocationRemapper.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n477#2:148\n1#3:149\n1374#4:150\n1460#4,5:151\n*S KotlinDebug\n*F\n+ 1 SourceMapLocationRemapper.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper\n*L\n69#1:148\n47#1:150\n47#1:151,5\n*E\n"})
public final class SourceMapLocationRemapper {
    @NotNull
    private final SourceMap sourceMap;
    @NotNull
    private final Function1<String, String> sourceMapPathMapper;

    public SourceMapLocationRemapper(@NotNull SourceMap sourceMap, @NotNull Function1<? super String, String> sourceMapPathMapper) {
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(sourceMapPathMapper, (String)"sourceMapPathMapper");
        this.sourceMap = sourceMap;
        this.sourceMapPathMapper = sourceMapPathMapper;
    }

    public /* synthetic */ SourceMapLocationRemapper(SourceMap sourceMap, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function1 = SourceMapLocationRemapper::_init_$lambda$0;
        }
        this(sourceMap, (Function1<? super String, String>)function1);
    }

    public final void remap(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JsNodeFlatListCollector listCollector = new JsNodeFlatListCollector();
        node.accept(listCollector);
        this.applySourceMap(listCollector.getNodeList());
    }

    private final void applySourceMap(List<? extends JsNode> nodes) {
        Ref.ObjectRef lastGroup = new Ref.ObjectRef();
        Ref.IntRef lastGroupIndex = new Ref.IntRef();
        Ref.ObjectRef lastSegment = new Ref.ObjectRef();
        Ref.IntRef lastSegmentIndex = new Ref.IntRef();
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)nodes);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)applySourceMap$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        for (SourceInfoAwareJsNode node : sequence) {
            JsLocationWithSource jsLocationWithSource;
            String sourceFileName;
            SourceMapSegment segment;
            SourceMapSegment sourceMapSegment = segment = SourceMapLocationRemapper.applySourceMap$findCorrespondingSegment(this, (Ref.ObjectRef<SourceMapGroup>)lastGroup, lastSegmentIndex, lastGroupIndex, (Ref.ObjectRef<SourceMapSegment>)lastSegment, node);
            String string = sourceFileName = sourceMapSegment != null ? sourceMapSegment.getSourceFileName() : null;
            if (sourceFileName != null) {
                JsLocation location = new JsLocation((String)this.sourceMapPathMapper.invoke((Object)sourceFileName), segment.getSourceLineNumber(), segment.getSourceColumnNumber(), segment.getName());
                jsLocationWithSource = new JsLocationWithEmbeddedSource(location, null, (Function0<? extends Reader>)((Function0)() -> SourceMapLocationRemapper.applySourceMap$lambda$4(this, segment)));
            } else {
                jsLocationWithSource = null;
            }
            node.setSource(jsLocationWithSource);
        }
    }

    private static final String _init_$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final SourceMapSegment applySourceMap$findCorrespondingSegment(SourceMapLocationRemapper this$0, Ref.ObjectRef<SourceMapGroup> lastGroup, Ref.IntRef lastSegmentIndex, Ref.IntRef lastGroupIndex, Ref.ObjectRef<SourceMapSegment> lastSegment, SourceInfoAwareJsNode node) {
        SourceMapSegment segment;
        Object object = node.getSource();
        JsLocation jsLocation = object instanceof JsLocation ? (JsLocation)object : null;
        if (jsLocation == null) {
            return null;
        }
        JsLocation source = jsLocation;
        object = this$0.sourceMap.getGroups();
        int n = source.getStartLine();
        if (!(0 <= n ? n < object.size() : false)) {
            int it = n;
            boolean bl = false;
            return null;
        }
        SourceMapGroup group = (SourceMapGroup)object.get(n);
        if (!Intrinsics.areEqual((Object)lastGroup.element, (Object)group)) {
            if (lastGroup.element != null) {
                Object object2 = lastGroup.element;
                Intrinsics.checkNotNull((Object)object2);
                List segmentsToSkip = CollectionsKt.toMutableList((Collection)CollectionsKt.drop((Iterable)((SourceMapGroup)object2).getSegments(), (int)lastSegmentIndex.element));
                if (lastGroupIndex.element + 1 < source.getStartLine()) {
                    void $this$flatMapTo$iv$iv;
                    Collection collection = segmentsToSkip;
                    Iterable $this$flatMap$iv = this$0.sourceMap.getGroups().subList(lastGroupIndex.element + 1, source.getStartLine());
                    boolean $i$f$flatMap = false;
                    Iterable iterable = $this$flatMap$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                        SourceMapGroup it = (SourceMapGroup)element$iv$iv;
                        boolean bl = false;
                        Iterable list$iv$iv = it.getSegments();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Iterable iterable2 = (List)destination$iv$iv;
                    CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
                }
                SourceMapSegment sourceMapSegment = (SourceMapSegment)CollectionsKt.lastOrNull((List)segmentsToSkip);
                if (sourceMapSegment != null) {
                    SourceMapSegment it = sourceMapSegment;
                    boolean bl = false;
                    lastSegment.element = it;
                }
            }
            lastGroup.element = group;
            lastGroupIndex.element = source.getStartLine();
            lastSegmentIndex.element = 0;
        }
        while (lastSegmentIndex.element < group.getSegments().size() && (segment = group.getSegments().get(lastSegmentIndex.element)).getGeneratedColumnNumber() <= source.getStartChar()) {
            lastSegment.element = segment;
            n = lastSegmentIndex.element;
            lastSegmentIndex.element = n + 1;
        }
        return (SourceMapSegment)lastSegment.element;
    }

    private static final Reader applySourceMap$lambda$4(SourceMapLocationRemapper this$0, SourceMapSegment $segment) {
        return (Reader)this$0.sourceMap.getSourceContentResolver().invoke((Object)$segment.getSourceFileName());
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0006H\u0014J-\u0010#\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00062\u0016\u0010$\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060%\"\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\u00020(*\u00020\u00062\u0006\u0010)\u001a\u00020\u0006H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper$JsNodeFlatListCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "<init>", "()V", "nodeList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "getNodeList", "()Ljava/util/List;", "visitDoWhile", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsDoWhile;", "visitBinaryExpression", "Lorg/jetbrains/kotlin/js/backend/ast/JsBinaryOperation;", "visitConditional", "Lorg/jetbrains/kotlin/js/backend/ast/JsConditional;", "visitArrayAccess", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayAccess;", "visitArray", "Lorg/jetbrains/kotlin/js/backend/ast/JsArrayLiteral;", "visitPrefixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPrefixOperation;", "visitPostfixOperation", "Lorg/jetbrains/kotlin/js/backend/ast/JsPostfixOperation;", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "visitInvocation", "invocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsInvocation;", "visitFunction", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitElement", "node", "handleNode", "children", "", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNode;[Lorg/jetbrains/kotlin/js/backend/ast/JsNode;)V", "isNotBefore", "", "other", "js.parser"})
    @SourceDebugExtension(value={"SMAP\nSourceMapLocationRemapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SourceMapLocationRemapper.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper$JsNodeFlatListCollector\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n37#2:148\n36#2,3:149\n37#2:152\n36#2,3:153\n1869#3,2:156\n1869#3,2:158\n1869#3,2:173\n1869#3,2:175\n11546#4,9:160\n13472#4:169\n13473#4:171\n11555#4:172\n1#5:170\n*S KotlinDebug\n*F\n+ 1 SourceMapLocationRemapper.kt\norg/jetbrains/kotlin/js/parser/sourcemaps/SourceMapLocationRemapper$JsNodeFlatListCollector\n*L\n97#1:148\n97#1:149,3\n106#1:152\n106#1:153,3\n110#1:156,2\n111#1:158,2\n130#1:173,2\n134#1:175,2\n120#1:160,9\n120#1:169\n120#1:171\n120#1:172\n120#1:170\n*E\n"})
    public static final class JsNodeFlatListCollector
    extends RecursiveJsVisitor {
        @NotNull
        private final List<JsNode> nodeList = new ArrayList();

        @NotNull
        public final List<JsNode> getNodeList() {
            return this.nodeList;
        }

        @Override
        public void visitDoWhile(@NotNull JsDoWhile x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            ((Collection)this.nodeList).add(x);
            this.accept((JsNode)x.getBody());
            this.accept((JsNode)x.getCondition());
        }

        @Override
        public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArg1(), x.getArg2()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitConditional(@NotNull JsConditional x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getTestExpression(), x.getThenExpression(), x.getElseExpression()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitArrayAccess(@NotNull JsArrayAccess x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArrayExpression(), x.getIndexExpression()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitArray(@NotNull JsArrayLiteral x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode jsNode = x;
            List<JsExpression> list = x.getExpressions();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getExpressions(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JsExpression[] jsExpressionArray = thisCollection$iv.toArray(new JsExpression[0]);
            this.handleNode(jsNode, Arrays.copyOf(jsExpressionArray, jsExpressionArray.length));
        }

        @Override
        public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArg()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            JsNode[] jsNodeArray = new JsNode[]{x.getArg()};
            this.handleNode(x, jsNodeArray);
        }

        @Override
        public void visitNameRef(@NotNull JsNameRef nameRef) {
            Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
            JsNode[] jsNodeArray = new JsNode[]{nameRef.getQualifier()};
            this.handleNode(nameRef, jsNodeArray);
        }

        @Override
        public void visitInvocation(@NotNull JsInvocation invocation) {
            Intrinsics.checkNotNullParameter((Object)invocation, (String)"invocation");
            JsNode jsNode = invocation;
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.add((Object)invocation.getQualifier());
            List<JsExpression> list = invocation.getArguments();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getArguments(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new JsExpression[0]));
            this.handleNode(jsNode, (JsNode[])spreadBuilder.toArray((Object[])new JsNode[spreadBuilder.size()]));
        }

        @Override
        public void visitFunction(@NotNull JsFunction x) {
            JsNode it;
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            ((Collection)this.nodeList).add(x);
            List<JsParameter> list = x.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JsParameter)element$iv;
                boolean bl = false;
                this.accept((JsNode)it);
            }
            List<JsStatement> list2 = x.getBody().getStatements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getStatements(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (JsStatement)element$iv;
                boolean bl = false;
                this.accept((JsNode)it);
            }
        }

        @Override
        protected void visitElement(@NotNull JsNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ((Collection)this.nodeList).add(node);
            node.acceptChildren(this);
        }

        /*
         * WARNING - void declaration
         */
        private final void handleNode(JsNode node, JsNode ... children) {
            void $this$mapNotNullTo$iv$iv;
            JsNode[] $this$mapNotNull$iv = children;
            boolean $i$f$mapNotNull = false;
            JsNode[] jsNodeArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (it == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List nonNullChildren = (List)destination$iv$iv;
            if (nonNullChildren.isEmpty()) {
                ((Collection)this.nodeList).add(node);
            } else {
                JsNode it;
                JsNode firstChild = (JsNode)CollectionsKt.first((List)nonNullChildren);
                if (this.isNotBefore(node, firstChild)) {
                    this.accept(firstChild);
                    ((Collection)this.nodeList).add(node);
                    Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)nonNullChildren, (int)1);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (JsNode)element$iv;
                        boolean bl = false;
                        this.accept(it);
                    }
                } else {
                    ((Collection)this.nodeList).add(node);
                    Iterable $this$forEach$iv = nonNullChildren;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (JsNode)element$iv;
                        boolean bl = false;
                        this.accept(it);
                    }
                }
            }
        }

        private final boolean isNotBefore(JsNode $this$isNotBefore, JsNode other) {
            JsLocationWithSource jsLocationWithSource = $this$isNotBefore.getSource();
            JsLocation jsLocation = jsLocationWithSource instanceof JsLocation ? (JsLocation)jsLocationWithSource : null;
            if (jsLocation == null) {
                return false;
            }
            JsLocation first = jsLocation;
            JsLocationWithSource jsLocationWithSource2 = other.getSource();
            JsLocation jsLocation2 = jsLocationWithSource2 instanceof JsLocation ? (JsLocation)jsLocationWithSource2 : null;
            if (jsLocation2 == null) {
                return false;
            }
            JsLocation second = jsLocation2;
            if (!Intrinsics.areEqual((Object)first.getFile(), (Object)second.getFile())) {
                return false;
            }
            return first.getStartLine() > second.getStartLine() || first.getStartLine() == second.getStartLine() && first.getStartChar() >= second.getStartChar();
        }
    }
}

