/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.inspections.IncorrectListNumberingInspection;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeInsightSettings;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownCodeInsightSettings;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "ListNumberingFix", "intellij.markdown"})
@ApiStatus.Internal
public final class IncorrectListNumberingInspection
extends LocalInspectionTool {
    @NotNull
    private final MarkdownCodeInsightSettings settings = MarkdownCodeInsightSettings.Companion.getInstance();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (((MarkdownCodeInsightSettings.State)this.settings.getState()).getListNumberingType() == MarkdownCodeInsightSettings.ListNumberingType.PREVIOUS_NUMBER) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new MarkdownElementVisitor(this, holder){
            final /* synthetic */ IncorrectListNumberingInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitList(MarkdownList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                super.visitList(list2);
                PsiElement psiElement = (PsiElement)list2;
                IElementType iElementType = MarkdownElementTypes.ORDERED_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"ORDERED_LIST");
                if (!PsiUtilsKt.hasType(psiElement, iElementType)) {
                    return;
                }
                boolean listNumberingIsSequential = ((MarkdownCodeInsightSettings.State)IncorrectListNumberingInspection.access$getSettings$p(this.this$0).getState()).getListNumberingType() == MarkdownCodeInsightSettings.ListNumberingType.SEQUENTIAL;
                Lazy quickFix$delegate = LazyKt.lazy(() -> buildVisitor.1.visitList$lambda$0(list2, listNumberingIsSequential));
                Iterator<T> iterator = ((Iterable)ListUtils.INSTANCE.getItems(list2)).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    PsiElement markerElement;
                    int actualNumber;
                    int index = n++;
                    MarkdownListItem item = (MarkdownListItem)iterator.next();
                    Integer n2 = ListRenumberUtils.INSTANCE.obtainMarkerNumber(item);
                    if (n2 == null) {
                        continue;
                    }
                    int expectedNumber = listNumberingIsSequential ? index + 1 : 1;
                    if (expectedNumber == (actualNumber = n2.intValue())) continue;
                    Intrinsics.checkNotNull((Object)item.getMarkerElement());
                    Object[] objectArray = new Object[]{expectedNumber, actualNumber};
                    String string = MarkdownBundle.message("markdown.incorrectly.numbered.list.item.inspection.text", objectArray);
                    objectArray = new LocalQuickFix[]{buildVisitor.1.visitList$lambda$1((Lazy<ListNumberingFix>)quickFix$delegate)};
                    this.$holder.registerProblem(markerElement, string, ProblemHighlightType.WEAK_WARNING, (LocalQuickFix[])objectArray);
                }
            }

            private static final ListNumberingFix visitList$lambda$0(MarkdownList $list, boolean $listNumberingIsSequential) {
                return new ListNumberingFix($list, $listNumberingIsSequential);
            }

            private static final ListNumberingFix visitList$lambda$1(Lazy<ListNumberingFix> $quickFix$delegate) {
                Lazy<ListNumberingFix> lazy = $quickFix$delegate;
                return (ListNumberingFix)((Object)lazy.getValue());
            }
        };
    }

    public static final /* synthetic */ MarkdownCodeInsightSettings access$getSettings$p(IncorrectListNumberingInspection $this) {
        return $this.settings;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0096\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix;", "Lcom/intellij/codeInspection/LocalQuickFixOnPsiElement;", "list", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "sequentially", "", "<init>", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;Z)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nIncorrectListNumberingInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncorrectListNumberingInspection.kt\norg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n23#2:80\n*S KotlinDebug\n*F\n+ 1 IncorrectListNumberingInspection.kt\norg/intellij/plugins/markdown/editor/lists/inspections/IncorrectListNumberingInspection$ListNumberingFix\n*L\n72#1:80\n*E\n"})
    private static final class ListNumberingFix
    extends LocalQuickFixOnPsiElement {
        private final boolean sequentially;

        public ListNumberingFix(@NotNull MarkdownList list2, boolean sequentially) {
            Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
            super((PsiElement)list2);
            this.sequentially = sequentially;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @NotNull
        public String getText() {
            String string = MarkdownBundle.message("markdown.fix.list.items.numbering,quick.fix.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!(startElement instanceof MarkdownList)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Document document = psiFile.getViewProvider().getDocument();
            if (document == null) {
                ListNumberingFix $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ListNumberingFix.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Failed to find document for the quick fix");
                return;
            }
            ListRenumberUtils.INSTANCE.renumberInBulk((MarkdownList)startElement, document, false, true, false, this.sequentially);
        }
    }
}

