/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.relativizer;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.lang.JavaVersion;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.relativizer.PathRelativizer;
import org.jetbrains.jps.incremental.relativizer.PathRelativizerService;
import org.jetbrains.jps.model.library.sdk.JpsSdk;

final class JavaSdkPathRelativizer
implements PathRelativizer {
    @NotNull
    private final Map<String, String> javaSdkPathMap;

    JavaSdkPathRelativizer(@NotNull Set<? extends JpsSdk<?>> javaSdks) {
        if (javaSdks == null) {
            JavaSdkPathRelativizer.$$$reportNull$$$0(0);
        }
        this.javaSdkPathMap = javaSdks.stream().collect(Collectors.toMap(sdk -> {
            JavaVersion version = JavaVersion.tryParse((String)sdk.getVersionString());
            return "$JDK_" + (version == null ? "0" : version.toString()) + "$";
        }, sdk -> PathRelativizerService.normalizePath(sdk.getHomePath()), (sdk1, sdk2) -> sdk1));
    }

    @Override
    @Nullable
    public String toRelativePath(@NotNull String path) {
        if (path == null) {
            JavaSdkPathRelativizer.$$$reportNull$$$0(1);
        }
        for (Map.Entry<String, String> entry : this.javaSdkPathMap.entrySet()) {
            if (!FileUtil.startsWith((String)path, (String)entry.getValue())) continue;
            return entry.getKey() + path.substring(entry.getValue().length());
        }
        return null;
    }

    @Override
    @Nullable
    public String toAbsolutePath(@NotNull String path) {
        if (path == null) {
            JavaSdkPathRelativizer.$$$reportNull$$$0(2);
        }
        for (Map.Entry<String, String> it : this.javaSdkPathMap.entrySet()) {
            if (!path.startsWith(it.getKey())) continue;
            return it.getValue() + path.substring(it.getKey().length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSdks";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/relativizer/JavaSdkPathRelativizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toRelativePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toAbsolutePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

