/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.unsafe;

import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.minlog.Log;
import com.esotericsoftware.kryo.kryo5.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeUtil {
    public static final Unsafe unsafe;
    public static final long byteArrayBaseOffset;
    public static final long floatArrayBaseOffset;
    public static final long doubleArrayBaseOffset;
    public static final long intArrayBaseOffset;
    public static final long longArrayBaseOffset;
    public static final long shortArrayBaseOffset;
    public static final long charArrayBaseOffset;
    public static final long booleanArrayBaseOffset;

    public static ByteBuffer newDirectBuffer(long address, int size) {
        if (!UnsafeUtil.isNewDirectBufferAvailable()) {
            throw new UnsupportedOperationException("No direct ByteBuffer constructor is available.");
        }
        try {
            return (ByteBuffer)DirectBuffers.directByteBufferConstructor.newInstance(address, size);
        }
        catch (Exception ex) {
            throw new KryoException("Error creating a ByteBuffer at address: " + address, ex);
        }
    }

    public static boolean isNewDirectBufferAvailable() {
        return DirectBuffers.directByteBufferConstructor != null;
    }

    public static void dispose(ByteBuffer buffer) {
        if (!(buffer instanceof DirectBuffer)) {
            return;
        }
        if (DirectBuffers.cleanerMethod != null) {
            try {
                DirectBuffers.cleanMethod.invoke(DirectBuffers.cleanerMethod.invoke((Object)buffer, new Object[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        long tempBooleanArrayBaseOffset;
        long tempCharArrayBaseOffset;
        long tempShortArrayBaseOffset;
        long tempLongArrayBaseOffset;
        long tempIntArrayBaseOffset;
        long tempDoubleArrayBaseOffset;
        long tempFloatArrayBaseOffset;
        long tempByteArrayBaseOffset;
        Unsafe tempUnsafe;
        block5: {
            tempUnsafe = null;
            tempByteArrayBaseOffset = 0L;
            tempFloatArrayBaseOffset = 0L;
            tempDoubleArrayBaseOffset = 0L;
            tempIntArrayBaseOffset = 0L;
            tempLongArrayBaseOffset = 0L;
            tempShortArrayBaseOffset = 0L;
            tempCharArrayBaseOffset = 0L;
            tempBooleanArrayBaseOffset = 0L;
            try {
                if (!Util.isAndroid) {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    tempUnsafe = (Unsafe)field.get(null);
                    tempByteArrayBaseOffset = tempUnsafe.arrayBaseOffset(byte[].class);
                    tempCharArrayBaseOffset = tempUnsafe.arrayBaseOffset(char[].class);
                    tempShortArrayBaseOffset = tempUnsafe.arrayBaseOffset(short[].class);
                    tempIntArrayBaseOffset = tempUnsafe.arrayBaseOffset(int[].class);
                    tempFloatArrayBaseOffset = tempUnsafe.arrayBaseOffset(float[].class);
                    tempLongArrayBaseOffset = tempUnsafe.arrayBaseOffset(long[].class);
                    tempDoubleArrayBaseOffset = tempUnsafe.arrayBaseOffset(double[].class);
                    tempBooleanArrayBaseOffset = tempUnsafe.arrayBaseOffset(boolean[].class);
                } else if (Log.DEBUG) {
                    Log.debug("kryo", "Unsafe is not available on Android.");
                }
            }
            catch (Exception ex) {
                if (!Log.DEBUG) break block5;
                Log.debug("kryo", "Unsafe is not available.", ex);
            }
        }
        byteArrayBaseOffset = tempByteArrayBaseOffset;
        charArrayBaseOffset = tempCharArrayBaseOffset;
        shortArrayBaseOffset = tempShortArrayBaseOffset;
        intArrayBaseOffset = tempIntArrayBaseOffset;
        floatArrayBaseOffset = tempFloatArrayBaseOffset;
        longArrayBaseOffset = tempLongArrayBaseOffset;
        doubleArrayBaseOffset = tempDoubleArrayBaseOffset;
        booleanArrayBaseOffset = tempBooleanArrayBaseOffset;
        unsafe = tempUnsafe;
    }

    private static final class DirectBuffers {
        private static Constructor<? extends ByteBuffer> directByteBufferConstructor;
        private static Method cleanerMethod;
        private static Method cleanMethod;

        private DirectBuffers() {
        }

        static {
            ByteBuffer buffer = ByteBuffer.allocateDirect(1);
            try {
                directByteBufferConstructor = buffer.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
                directByteBufferConstructor.setAccessible(true);
            }
            catch (Exception ex) {
                if (Log.DEBUG) {
                    Log.debug("kryo", "No direct ByteBuffer constructor is available.", ex);
                }
                directByteBufferConstructor = null;
            }
            try {
                cleanerMethod = DirectBuffer.class.getMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                cleanMethod = cleanerMethod.getReturnType().getMethod("clean", new Class[0]);
            }
            catch (Exception ex) {
                if (Log.DEBUG) {
                    Log.debug("kryo", "No direct ByteBuffer clean method is available.", ex);
                }
                cleanerMethod = null;
            }
        }
    }
}

