/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.JavaLightDuplicateProfileImplementation;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.JavaSpecificHasher;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JavaDuplicatesProfile
extends DuplicatesProfile
implements LightDuplicateProfile {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaDuplicatesProfile.class.getName()));
    private final JavaLanguage myLanguage = (JavaLanguage)Language.findInstance(JavaLanguage.class);
    private final LightDuplicateProfile myLightDuplicateProfile = new JavaLightDuplicateProfileImplementation();

    @Override
    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/JavaDuplicatesProfile", "createVisitor"));
        }
        DuplocateVisitor duplocateVisitor = this.createVisitor(collector, false);
        if (duplocateVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaDuplicatesProfile", "createVisitor"));
        }
        return duplocateVisitor;
    }

    @Override
    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/JavaDuplicatesProfile", "createVisitor"));
        }
        JavaSpecificHasher javaSpecificHasher = new JavaSpecificHasher(DuplocatorSettings.getInstance(), collector, forIndexing);
        if (javaSpecificHasher == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaDuplicatesProfile", "createVisitor"));
        }
        return javaSpecificHasher;
    }

    @Override
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/JavaDuplicatesProfile", "isMyLanguage"));
        }
        return language == this.myLanguage;
    }

    @Override
    @NotNull
    public DuplocatorState getDuplocatorState(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/JavaDuplicatesProfile", "getDuplocatorState"));
        }
        final DuplocatorSettings mySettings = DuplocatorSettings.getInstance();
        DuplocatorState duplocatorState = new DuplocatorState(){

            @Override
            public int getLowerBound() {
                return mySettings.LOWER_BOUND;
            }

            @Override
            public int getDiscardCost() {
                return mySettings.DISCARD_COST;
            }
        };
        if (duplocatorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/JavaDuplicatesProfile", "getDuplocatorState"));
        }
        return duplocatorState;
    }

    @Override
    public String getComment(@NotNull DupInfo info, int index) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/JavaDuplicatesProfile", "getComment"));
        }
        PsiFragment[] fragments = info.getFragmentOccurences(index);
        PsiFile psiFile = fragments[0].getFile();
        return psiFile instanceof PsiJavaFile ? ((PsiJavaFile)psiFile).getPackageName() : null;
    }

    @Override
    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        PsiElement[] elements = fragment.getElements();
        if (elements.length == 0) {
            return false;
        }
        PsiElement element = elements[0];
        return JavaDuplicatesProfile.shouldPutInIndex(element);
    }

    private static boolean shouldPutInIndex(PsiElement element) {
        if (element instanceof PsiStatement) {
            PsiStatement lastStatement;
            PsiCodeBlock block;
            PsiStatement firstStatement;
            if (element instanceof PsiBlockStatement && (firstStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)(block = ((PsiBlockStatement)element).getCodeBlock()).getLBrace(), PsiStatement.class)) == (lastStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)block.getRBrace(), PsiStatement.class)) && !JavaDuplicatesProfile.shouldPutInIndex((PsiElement)firstStatement)) {
                return false;
            }
            if (!(element instanceof PsiExpressionStatement || element instanceof PsiLabeledStatement || element instanceof PsiContinueStatement || element instanceof PsiEmptyStatement || element instanceof PsiBreakStatement || element instanceof PsiThrowStatement && ((PsiThrowStatement)element).getException() instanceof PsiReferenceExpression || element instanceof PsiReturnStatement || element instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)element).isDefaultCase())) {
                return true;
            }
        }
        if (element instanceof PsiExpression && element.getParent() instanceof PsiExpressionStatement) {
            PsiReferenceExpression expression;
            ASTNode node;
            return !(element instanceof PsiMethodCallExpression ? (node = (expression = ((PsiMethodCallExpression)element).getMethodExpression()).getNode()).findChildByType(JavaTokenType.THIS_KEYWORD) != null || node.findChildByType(JavaTokenType.SUPER_KEYWORD) != null : element instanceof PsiAssignmentExpression);
        }
        return false;
    }

    @Override
    public boolean isMyDuplicate(@NotNull DupInfo info, int index) {
        PsiElement[] elements;
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/JavaDuplicatesProfile", "isMyDuplicate"));
        }
        PsiFragment[] fragments = info.getFragmentOccurences(index);
        if (fragments.length > 0 && (elements = fragments[0].getElements()).length > 0 && elements[0] != null) {
            Language language = elements[0].getLanguage();
            LOG.info(language.getDisplayName());
            return language == this.myLanguage;
        }
        return false;
    }

    @Override
    public void process(@NotNull LighterAST ast, @NotNull LightDuplicateProfile.Callback callback) {
        if (ast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ast", "com/intellij/dupLocator/JavaDuplicatesProfile", "process"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/dupLocator/JavaDuplicatesProfile", "process"));
        }
        this.myLightDuplicateProfile.process(ast, callback);
    }

    @Override
    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/dupLocator/JavaDuplicatesProfile", "acceptsFile"));
        }
        return this.myLightDuplicateProfile.acceptsFile(file);
    }
}

