/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.cfg.WhenMissingCase;
import org.jetbrains.kotlin.cfg.WhenOnClassExhaustivenessChecker;
import org.jetbrains.kotlin.cfg.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/cfg/WhenOnEnumExhaustivenessChecker;", "Lorg/jetbrains/kotlin/cfg/WhenOnClassExhaustivenessChecker;", "()V", "getMissingCases", "", "Lorg/jetbrains/kotlin/cfg/WhenMissingCase;", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "subjectDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "nullable", "", "isApplicable", "subjectType", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin-compiler"})
final class WhenOnEnumExhaustivenessChecker
extends WhenOnClassExhaustivenessChecker {
    public static final WhenOnEnumExhaustivenessChecker INSTANCE;

    @Override
    @NotNull
    public List<WhenMissingCase> getMissingCases(@NotNull KtWhenExpression expression, @NotNull BindingContext context, @Nullable ClassDescriptor subjectDescriptor, boolean nullable) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        boolean bl = DescriptorUtils.isEnumClass(subjectDescriptor);
        if (_Assertions.ENABLED && !bl) {
            String string = "isWhenOnEnumExhaustive should be called with an enum class descriptor";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ClassDescriptor classDescriptor = subjectDescriptor;
        if (classDescriptor == null) {
            Intrinsics.throwNpe();
        }
        Iterable $i$a$1$assert = DescriptorUtils.getAllDescriptors(classDescriptor.getUnsubstitutedInnerClassesScope());
        void var7_8 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            DeclarationDescriptor p1 = (DeclarationDescriptor)element$iv$iv;
            if (!DescriptorUtils.isEnumEntry(p1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof ClassDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set entryDescriptors = CollectionsKt.toSet((List)destination$iv$iv);
        return CollectionsKt.plus((Collection)this.getMissingClassCases(expression, entryDescriptors, context), (Iterable)WhenOnNullableExhaustivenessChecker.INSTANCE.getMissingCases(expression, context, nullable));
    }

    @Override
    public boolean isApplicable(@NotNull KotlinType subjectType) {
        Intrinsics.checkParameterIsNotNull(subjectType, "subjectType");
        return WhenChecker.getClassDescriptorOfTypeIfEnum(subjectType) != null;
    }

    private WhenOnEnumExhaustivenessChecker() {
        INSTANCE = this;
    }

    static {
        new WhenOnEnumExhaustivenessChecker();
    }
}

