/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.repl;

import com.google.common.collect.Maps;
import java.io.PrintWriter;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

public class ReplClassLoader
extends ClassLoader {
    private final Map<JvmClassName, byte[]> classes;

    public ReplClassLoader(@NotNull ClassLoader parent2) {
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "<init>"));
        }
        super(parent2);
        this.classes = Maps.newLinkedHashMap();
    }

    @Override
    @NotNull
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "findClass"));
        }
        byte[] classBytes = this.classes.get(JvmClassName.byFqNameWithoutInnerClasses(name2));
        if (classBytes != null) {
            Class<?> clazz = this.defineClass(name2, classBytes, 0, classBytes.length);
            if (clazz == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "findClass"));
            }
            return clazz;
        }
        Class<?> clazz = super.findClass(name2);
        if (clazz == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "findClass"));
        }
        return clazz;
    }

    public void addClass(@NotNull JvmClassName className2, @NotNull byte[] bytes) {
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "addClass"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "addClass"));
        }
        byte[] oldBytes = this.classes.put(className2, bytes);
        if (oldBytes != null) {
            throw new IllegalStateException("Rewrite at key " + className2);
        }
    }

    public void dumpClasses(@NotNull PrintWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/kotlin/cli/common/repl/ReplClassLoader", "dumpClasses"));
        }
        for (byte[] classBytes : this.classes.values()) {
            new ClassReader(classBytes).accept(new TraceClassVisitor(writer), 0);
        }
    }
}

