/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0003\b\u0010\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0014J\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u00022\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011J\u001f\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0002H\u0086\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ClassOneToManyMap;", "Lorg/jetbrains/kotlin/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "add", "", "key", "Lorg/jetbrains/kotlin/name/FqName;", "value", "dumpValue", "get", "remove", "removeValues", "removed", "", "set", "values", "kotlin-compiler"})
public class ClassOneToManyMap
extends BasicStringMap<Collection<? extends String>> {
    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        return IncrementalCacheImplKt.dumpCollection(value);
    }

    public final void add(@NotNull FqName key, @NotNull FqName value) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(value, "value");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "key.asString()");
        String string2 = value.asString();
        Intrinsics.checkExpressionValueIsNotNull(string2, "value.asString()");
        lazyStorage.append(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> get(@NotNull FqName key) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull(key, "key");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "key.asString()");
        Collection collection2 = (Collection)lazyStorage.get(string);
        if (collection2 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)collection2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string2 = (String)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                FqName fqName2 = new FqName((String)p1);
                collection3.add(fqName2);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = SetsKt.emptySet();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull FqName key, @NotNull Collection<FqName> values) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(values, "values");
        if (values.isEmpty()) {
            this.remove(key);
            return;
        }
        LazyStorage<String, List> lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "key.asString()");
        Iterable iterable = values;
        String string2 = string;
        LazyStorage<String, List> lazyStorage2 = lazyStorage;
        void var4_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            FqName fqName2 = (FqName)item$iv$iv;
            collection = destination$iv$iv;
            String string3 = p1.asString();
            collection.add(string3);
        }
        collection = (List)destination$iv$iv;
        lazyStorage2.set(string2, (List)collection);
    }

    public final void remove(@NotNull FqName key) {
        Intrinsics.checkParameterIsNotNull(key, "key");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "key.asString()");
        lazyStorage.remove(string);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeValues(@NotNull FqName key, @NotNull Set<FqName> removed) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(key, "key");
        Intrinsics.checkParameterIsNotNull(removed, "removed");
        Iterable iterable = $receiver$iv = (Iterable)this.get(key);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            if (!(removed.contains(it) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notRemoved = (List)destination$iv$iv;
        this.set(key, notRemoved);
    }

    public ClassOneToManyMap(@NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull(storageFile, "storageFile");
        super(storageFile, StringCollectionExternalizer.INSTANCE);
    }
}

