/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsArrayAccess;
import org.jetbrains.kotlin.js.backend.ast.JsArrayLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsConditional;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNew;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsPostfixOperation;
import org.jetbrains.kotlin.js.backend.ast.JsPrefixOperation;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

public class JsFirstExpressionVisitor
extends RecursiveJsVisitor {
    private boolean needsParentheses = false;

    public static boolean exec(JsExpressionStatement statement) {
        JsExpression expression = statement.getExpression();
        if (expression instanceof JsFunction) {
            return false;
        }
        JsFirstExpressionVisitor visitor2 = new JsFirstExpressionVisitor();
        visitor2.accept(statement.getExpression());
        return visitor2.needsParentheses;
    }

    private JsFirstExpressionVisitor() {
    }

    @Override
    public void visitArrayAccess(@NotNull JsArrayAccess x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitArrayAccess"));
        }
        this.accept(x.getArrayExpression());
    }

    @Override
    public void visitArray(@NotNull JsArrayLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitArray"));
        }
    }

    @Override
    public void visitBinaryExpression(@NotNull JsBinaryOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitBinaryExpression"));
        }
        this.accept(x.getArg1());
    }

    @Override
    public void visitConditional(@NotNull JsConditional x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitConditional"));
        }
        this.accept(x.getTestExpression());
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitFunction"));
        }
        this.needsParentheses = true;
    }

    @Override
    public void visitInvocation(@NotNull JsInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitInvocation"));
        }
        this.accept(invocation.getQualifier());
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        if (nameRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameRef", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitNameRef"));
        }
        if (!nameRef.isLeaf()) {
            this.accept(nameRef.getQualifier());
        }
    }

    @Override
    public void visitNew(@NotNull JsNew x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitNew"));
        }
    }

    @Override
    public void visitObjectLiteral(@NotNull JsObjectLiteral x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitObjectLiteral"));
        }
        this.needsParentheses = true;
    }

    @Override
    public void visitPostfixOperation(@NotNull JsPostfixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitPostfixOperation"));
        }
        this.accept(x.getArg());
    }

    @Override
    public void visitPrefixOperation(@NotNull JsPrefixOperation x) {
        if (x == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "x", "org/jetbrains/kotlin/js/backend/JsFirstExpressionVisitor", "visitPrefixOperation"));
        }
    }
}

