/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.translate.context.TemporaryVariable;

public final class TemporaryConstVariable
extends TemporaryVariable {
    private boolean initialized;

    public TemporaryConstVariable(@NotNull JsName variableName, @NotNull JsExpression assignmentExpression) {
        if (variableName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "org/jetbrains/kotlin/js/translate/context/TemporaryConstVariable", "<init>"));
        }
        if (assignmentExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignmentExpression", "org/jetbrains/kotlin/js/translate/context/TemporaryConstVariable", "<init>"));
        }
        super(variableName, assignmentExpression);
        this.initialized = false;
    }

    @NotNull
    public JsExpression value() {
        if (this.initialized) {
            JsNameRef jsNameRef = this.reference();
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TemporaryConstVariable", "value"));
            }
            return jsNameRef;
        }
        this.initialized = true;
        JsExpression jsExpression = this.assignmentExpression();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/context/TemporaryConstVariable", "value"));
        }
        return jsExpression;
    }
}

