/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfoExtensionsKt;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsicWithReceiverComputed;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.ArrayFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.CompositeFIF;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.KotlinFunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.UtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;

public final class TopLevelFIF
extends CompositeFIF {
    public static final DescriptorPredicate EQUALS_IN_ANY = PatternBuilder.pattern("kotlin", "Any", "equals");
    @NotNull
    private static final KotlinFunctionIntrinsic KOTLIN_ANY_EQUALS = new KotlinFunctionIntrinsic("equals", new JsExpression[0]){

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            if (CallInfoExtensionsKt.isSuperInvocation(callInfo)) {
                JsExpression dispatchReceiver = callInfo.getDispatchReceiver();
                assert (arguments2.size() == 1 && dispatchReceiver != null);
                JsBinaryOperation jsBinaryOperation = JsAstUtils.equality(dispatchReceiver, arguments2.get(0));
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
                }
                return jsBinaryOperation;
            }
            JsExpression jsExpression = super.apply(callInfo, arguments2, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$1", "apply"));
            }
            return jsExpression;
        }
    };
    @NotNull
    public static final KotlinFunctionIntrinsic KOTLIN_EQUALS = new KotlinFunctionIntrinsic("equals", new JsExpression[0]);
    @NotNull
    private static final KotlinFunctionIntrinsic KOTLIN_SUBSEQUENCE = new KotlinFunctionIntrinsic("subSequence", new JsExpression[0]);
    @NotNull
    private static final DescriptorPredicate HASH_CODE_IN_ANY = PatternBuilder.pattern("kotlin", "Any", "hashCode");
    @NotNull
    private static final KotlinFunctionIntrinsic KOTLIN_HASH_CODE = new KotlinFunctionIntrinsic("hashCode", new JsExpression[0]);
    @NotNull
    private static final FunctionIntrinsic RETURN_RECEIVER_INTRINSIC = new FunctionIntrinsicWithReceiverComputed(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            assert (receiver != null);
            JsExpression jsExpression = receiver;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$2", "apply"));
            }
            return jsExpression;
        }
    };
    private static final FunctionIntrinsic JS_CLASS_FUN_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "apply"));
            }
            JsExpression jsExpression = TopLevelFIF.getReferenceToOnlyTypeParameter(callInfo, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$3", "apply"));
            }
            return jsExpression;
        }
    };
    private static final FunctionIntrinsic ENUM_VALUES_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "apply"));
            }
            JsExpression enumClassRef = TopLevelFIF.getReferenceToOnlyTypeParameter(callInfo, context);
            SimpleFunctionDescriptor fd = DescriptorFactory.createEnumValuesMethod(context.getCurrentModule().getBuiltIns().getEnum());
            JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef(context.getNameForDescriptor(fd), enumClassRef), new JsExpression[0]);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$4", "apply"));
            }
            return jsInvocation;
        }
    };
    private static final FunctionIntrinsic ENUM_VALUE_OF_INTRINSIC = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            JsExpression arg = arguments2.get(2);
            JsExpression enumClassRef = TopLevelFIF.getReferenceToOnlyTypeParameter(callInfo, context);
            SimpleFunctionDescriptor fd = DescriptorFactory.createEnumValueOfMethod(context.getCurrentModule().getBuiltIns().getEnum());
            JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef(context.getNameForDescriptor(fd), enumClassRef), arg);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$5", "apply"));
            }
            return jsInvocation;
        }
    };
    private static final FunctionIntrinsic STRING_SUBSTRING = new FunctionIntrinsicWithReceiverComputed(){

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
            }
            JsInvocation jsInvocation = new JsInvocation((JsExpression)new JsNameRef("substring", receiver), arguments2);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$6", "apply"));
            }
            return jsInvocation;
        }
    };
    @NotNull
    public static final KotlinFunctionIntrinsic TO_STRING = new KotlinFunctionIntrinsic("toString", new JsExpression[0]);
    @NotNull
    public static final FunctionIntrinsic CHAR_TO_STRING = new FunctionIntrinsic(){

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments2, @NotNull TranslationContext context) {
            if (callInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$7", "apply"));
            }
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$7", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$7", "apply"));
            }
            JsExpression jsExpression = JsAstUtils.charToString(callInfo.getDispatchReceiver());
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF$7", "apply"));
            }
            return jsExpression;
        }
    };
    @NotNull
    public static final FunctionIntrinsicFactory INSTANCE = new TopLevelFIF();

    private static JsExpression getReferenceToOnlyTypeParameter(@NotNull CallInfo callInfo, @NotNull TranslationContext context) {
        if (callInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callInfo", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF", "getReferenceToOnlyTypeParameter"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/TopLevelFIF", "getReferenceToOnlyTypeParameter"));
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = callInfo.getResolvedCall();
        Map<TypeParameterDescriptor, KotlinType> typeArguments = resolvedCall2.getTypeArguments();
        assert (typeArguments.size() == 1);
        KotlinType type2 = typeArguments.values().iterator().next();
        return UtilsKt.getReferenceToJsClass(type2, context);
    }

    private TopLevelFIF() {
        this.add(EQUALS_IN_ANY, KOTLIN_ANY_EQUALS);
        this.add(PatternBuilder.pattern("Char.toString"), CHAR_TO_STRING);
        this.add(PatternBuilder.pattern("kotlin", "toString").isExtensionOf(KotlinBuiltIns.FQ_NAMES.any.asString()), TO_STRING);
        this.add(PatternBuilder.pattern("kotlin", "equals").isExtensionOf(KotlinBuiltIns.FQ_NAMES.any.asString()), KOTLIN_EQUALS);
        this.add(HASH_CODE_IN_ANY, KOTLIN_HASH_CODE);
        this.add(PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, "equals"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("String|Boolean|Char|Number.equals"), KOTLIN_EQUALS);
        this.add(PatternBuilder.pattern("String.subSequence"), STRING_SUBSTRING);
        this.add(PatternBuilder.pattern("CharSequence.subSequence"), KOTLIN_SUBSEQUENCE);
        this.add(PatternBuilder.pattern("kotlin", "iterator").isExtensionOf(KotlinBuiltIns.FQ_NAMES.iterator.asString()), RETURN_RECEIVER_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin.js", "Json", "get"), ArrayFIF.GET_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin.js", "Json", "set"), ArrayFIF.SET_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin.js", "jsClass"), JS_CLASS_FUN_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin", "enumValues"), ENUM_VALUES_INTRINSIC);
        this.add(PatternBuilder.pattern("kotlin", "enumValueOf"), ENUM_VALUE_OF_INTRINSIC);
    }
}

