/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.providers;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.jam.JsfJamManagedBean;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.jsf.model.xml.managedBeans.ManagedBean;
import com.intellij.jsf.model.xml.referencedBeans.ReferencedBean;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiTarget;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import icons.J2EEIcons;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ELResolverManagedBeanReferenceProvider
extends PsiReferenceProvider {
    public static final String[] METHODS = new String[]{"getValue"};

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiLiteralExpression literalExpression;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof PsiLiteralExpression && (literalExpression = (PsiLiteralExpression)element).getValue() instanceof String) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new ManagedBeanReference(literalExpression)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public static class ManagedBeanReference
    extends PsiReferenceBase<PsiLiteralExpression> {
        public ManagedBeanReference(PsiLiteralExpression element) {
            super((PsiElement)element, true);
        }

        public PsiElement resolve() {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
            if (module != null) {
                return ManagedBeanReference.collectBeans(module).get(((PsiLiteralExpression)this.getElement()).getValue());
            }
            return null;
        }

        private static Map<String, PsiElement> collectBeans(@NotNull Module module) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider$ManagedBeanReference", "collectBeans"));
            }
            HashMap beans = new HashMap();
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                List<FacesDomModel> models = FacesDomModelManager.getInstance(module.getProject()).getAllModels(webFacet);
                for (FacesDomModel facesDomModel : models) {
                    String name;
                    for (ManagedBean managedBean : facesDomModel.getFacesConfig().getManagedBeans()) {
                        name = (String)managedBean.getManagedBeanName().getValue();
                        if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                        beans.put(name, PomService.convertToPsi((PsiTarget)DomTarget.getTarget((DomElement)managedBean)));
                    }
                    for (ReferencedBean referencedBean : facesDomModel.getFacesConfig().getReferencedBeans()) {
                        name = (String)referencedBean.getReferencedBeanName().getValue();
                        if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                        beans.put(name, PomService.convertToPsi((PsiTarget)DomTarget.getTarget((DomElement)referencedBean)));
                    }
                }
            }
            for (JsfJamManagedBean bean : JsfJamModel.getModel(module).getManagedBeans(true)) {
                String name = bean.getName();
                if (StringUtil.isEmptyOrSpaces((String)name)) continue;
                beans.put(name, PomService.convertToPsi((PsiTarget)bean.getPsiTarget()));
            }
            return beans;
        }

        @NotNull
        public Object[] getVariants() {
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement());
            if (module != null) {
                HashSet names = new HashSet();
                Map<String, PsiElement> map = ManagedBeanReference.collectBeans(module);
                for (Map.Entry<String, PsiElement> entry : map.entrySet()) {
                    LookupElementBuilder item = LookupElementBuilder.create((String)entry.getKey());
                    PsiElement psiElement = entry.getValue();
                    if (psiElement != null) {
                        item = item.withIcon(psiElement.getContainingFile().getIcon(0));
                        item = item.withTypeText(psiElement.getContainingFile().getPresentation().getPresentableText());
                    } else {
                        item = item.withIcon(J2EEIcons.ManagedBean);
                    }
                    names.add(item);
                }
                Object[] objectArray = names.toArray(new LookupElement[names.size()]);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider$ManagedBeanReference", "getVariants"));
                }
                return objectArray;
            }
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/ELResolverManagedBeanReferenceProvider$ManagedBeanReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
    }
}

