/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.model.jam.JsfJamRenderer;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.renderKits.RenderKit;
import com.intellij.jsf.model.xml.renderKits.Renderer;
import com.intellij.jsf.resources.FacesUIBundle;
import com.intellij.jsf.toolWindow.tree.nodes.AbstractJsfTypeNode;
import com.intellij.jsf.toolWindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfDomModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.JsfIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RenderersNode
extends AbstractJsfTypeNode {
    public RenderersNode(Module module, JsfModuleNode jsfModuleNode, boolean showFromLibraries) {
        super(jsfModuleNode, module, JsfNodeTypes.RENDERER, showFromLibraries);
        this.setUniformIcon(JsfIcons.Renderer);
    }

    protected void doUpdate() {
        this.setPlainText(FacesUIBundle.message("renderers.node.name", new Object[0]));
    }

    @Override
    protected void addAnnotatedNodes(Collection<JsfModelElementNode> nodes) {
        List<JsfJamRenderer> jamElements = JsfJamModel.getModel(this.getModule()).getRenderers(this.isShowFromLibraries());
        for (JsfJamRenderer renderer : jamElements) {
            nodes.add(new AnnotatedMembersNode<PsiClass>(this.getModule(), renderer.getPsiElement(), this));
        }
    }

    @Override
    @NotNull
    protected Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel domModel) {
        if (domModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domModel", "com/intellij/jsf/toolWindow/tree/nodes/RenderersNode", "getFacesDomModelNodes"));
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<RenderKit> renderKits = domModel.getFacesConfig().getRenderKits();
        for (RenderKit renderKit : renderKits) {
            for (final Renderer renderer : renderKit.getRenderers()) {
                nodes.add(new JsfDomModelElementNode<Renderer>(this.getProject(), (NodeDescriptor)this, renderer, JsfIcons.Renderer){

                    @Override
                    protected String getActualNodeName() {
                        return renderer.getComponentFamily().getStringValue();
                    }

                    @Override
                    protected String getNodeTextExt() {
                        return renderer.getRendererClass().getStringValue();
                    }
                });
            }
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/RenderersNode", "getFacesDomModelNodes"));
        }
        return arrayList;
    }
}

