/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.ExecuteBatchQuery;
import com.intellij.database.remote.dbimport.PreparedBatchQuery;
import com.intellij.database.remote.dbimport.PreparedQuery;
import com.intellij.database.remote.dbimport.Query;
import com.intellij.database.remote.dbimport.QueryWithParameters;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportQueryGenerator {
    private final Rdbms myRdbms;
    private final List<ColumnInfo> myInfos;
    private final RemoteBatchPreparedStatementImpl myStatement;
    private final int myLinesPerStatement;
    private List<ErrorRecord> myErrorRecords;
    private List<PreparedBatchQuery> myBatchQueries;
    private Consumer<ErrorRecord> myConsumer;
    private boolean myBatchSupported;

    public ImportQueryGenerator(@NotNull Rdbms rdbms, @NotNull RemoteBatchPreparedStatementImpl statement, @NotNull List<ColumnInfo> infos, boolean batchSupported, int linesPerStatement) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "<init>"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "<init>"));
        }
        this.myRdbms = rdbms;
        this.myInfos = infos;
        this.myLinesPerStatement = linesPerStatement;
        this.myStatement = statement;
        this.myBatchSupported = batchSupported;
        this.myBatchQueries = ContainerUtil.newArrayList();
        this.myErrorRecords = ContainerUtil.newArrayList();
        this.myConsumer = new Consumer<ErrorRecord>(){

            public void consume(ErrorRecord record) {
                ImportQueryGenerator.this.myErrorRecords.add(record);
            }
        };
    }

    @NotNull
    public List<Query> generate(@NotNull String lastSql, @NotNull BatchRecords records) throws SQLException, RemoteException {
        if (lastSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastSql", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "generate"));
        }
        if (records == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "records", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "generate"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        List<BatchRecords> splitted = records.split(this.myLinesPerStatement);
        for (int i = 0; i < splitted.size() - 1; ++i) {
            this.flush(splitted.get(i), result);
        }
        BatchRecords last = (BatchRecords)ContainerUtil.getLastItem(splitted);
        List<Query> list = this.generateLastQueries(result, (BatchRecords)ObjectUtils.assertNotNull((Object)last), lastSql);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "generate"));
        }
        return list;
    }

    @NotNull
    public List<ErrorRecord> getErrors() {
        List<ErrorRecord> records = this.myErrorRecords;
        this.myErrorRecords = ContainerUtil.newArrayList();
        List<ErrorRecord> list = records;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "getErrors"));
        }
        return list;
    }

    private void flush(BatchRecords parameters, List<Query> result) {
        if (this.myBatchSupported) {
            PreparedBatchQuery query = (PreparedBatchQuery)this.getQuery(parameters);
            result.add(query);
            this.myBatchQueries.add(query);
            return;
        }
        result.add(this.getQuery(parameters));
    }

    private QueryWithParameters getQuery(BatchRecords currentQueryParameters) {
        return this.myBatchSupported ? new PreparedBatchQuery(this.myRdbms, currentQueryParameters, this.myStatement, this.myConsumer, this.myInfos, this.myBatchQueries) : new PreparedQuery(this.myRdbms, currentQueryParameters, this.myStatement, this.myInfos, this.myConsumer);
    }

    private List<Query> generateLastQueries(@NotNull List<Query> result, @NotNull BatchRecords batch, @NotNull String lastSql) throws SQLException, RemoteException {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        if (batch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "batch", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        if (lastSql == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastSql", "com/intellij/database/remote/dbimport/ImportQueryGenerator", "generateLastQueries"));
        }
        this.lastBatchQueries(result);
        if (batch.isEmpty()) {
            return result;
        }
        final RemotePreparedStatement statement = this.myStatement.withLines(lastSql, batch.getLinesCount());
        result.add(new PreparedQuery(this.myRdbms, batch, statement, this.myInfos, this.myConsumer){

            protected void statementCompleted() throws RemoteException, SQLException {
                super.statementCompleted();
                JdbcNativeUtil.closeRemoteStatementSafe(statement);
            }
        });
        return result;
    }

    private List<Query> lastBatchQueries(List<Query> result) {
        if (this.myBatchQueries.isEmpty()) {
            return result;
        }
        result.add(new ExecuteBatchQuery(this.myBatchQueries, this.myStatement));
        this.myBatchQueries = ContainerUtil.newArrayList();
        return result;
    }
}

