/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.descriptor.CssContextType;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFileType
extends LanguageFileType {
    @NonNls
    public static final String DEFAULT_EXTENSION = "css";
    public static final LanguageFileType INSTANCE = new CssFileType();
    @NonNls
    private static final String DESCRIPTION = "Cascading style sheet";

    public CssFileType() {
        super((Language)CSSLanguage.INSTANCE);
    }

    @NotNull
    public String getName() {
        if ("CSS" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssFileType", "getName"));
        }
        return "CSS";
    }

    @NotNull
    public String getDescription() {
        if (DESCRIPTION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssFileType", "getDescription"));
        }
        return DESCRIPTION;
    }

    @NotNull
    public String getDefaultExtension() {
        if (DEFAULT_EXTENSION == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/css/CssFileType", "getDefaultExtension"));
        }
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Css;
    }

    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/CssFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/css/CssFileType", "getCharset"));
        }
        Charset charset = CssFileType.getCharsetFromCssContent(content);
        return charset != null ? charset.name() : null;
    }

    public Charset extractCharsetFromFileContent(@Nullable Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/css/CssFileType", "extractCharsetFromFileContent"));
        }
        return CssFileType.getCharsetFromCssContent(content);
    }

    public static Charset getCharsetFromCssContent(byte[] content) {
        String strContent;
        Charset fromBOM = CharsetToolkit.guessFromBOM((byte[])content);
        if (fromBOM != null) {
            return fromBOM;
        }
        try {
            strContent = new String(content, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        return CssFileType.getCharsetFromCssContent(strContent);
    }

    @Nullable
    public static Charset getCharsetFromCssContent(@NotNull CharSequence content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/psi/css/CssFileType", "getCharsetFromCssContent"));
        }
        int charsetKeywordLength = CssContextType.CHARSET.toString().length();
        if (StringUtil.startsWith((CharSequence)content, (CharSequence)CssContextType.CHARSET.toString()) && content.length() > charsetKeywordLength) {
            int i;
            char ch = content.charAt(i);
            for (i = charsetKeywordLength; i < content.length() && Character.isWhitespace(ch = content.charAt(i)); ++i) {
            }
            if (ch != '\"') {
                return null;
            }
            if (++i >= content.length()) {
                return null;
            }
            ch = content.charAt(i);
            String name = "";
            while (i < content.length() && !Character.isWhitespace(ch) && ch != '\"') {
                name = name + ch;
                if (++i + 1 >= content.length()) continue;
                ch = content.charAt(i);
            }
            if (ch != '\"') {
                return null;
            }
            return CharsetToolkit.forName((String)name);
        }
        return null;
    }
}

