/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.generate;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.actions.generate.DefaultGenerateElementProvider;
import org.jetbrains.annotations.NonNls;

public class GenerateMappingProvider<T extends DomElement>
extends DefaultGenerateElementProvider<T> {
    private final Class<? extends DomElement>[] myPossibleParents;
    private final String myMappingId;

    public GenerateMappingProvider(String name, Class<T> childElementClass, @NonNls String mappingId, Class<? extends DomElement> ... possibleParents) {
        super(name, childElementClass);
        this.myPossibleParents = possibleParents;
        this.myMappingId = mappingId;
    }

    public T generate(Project project, Editor editor, PsiFile file) {
        Template template;
        DomElement t = super.generate(project, editor, file);
        if (t != null && (template = TemplateSettings.getInstance().getTemplateById(this.myMappingId)) != null) {
            DomElement copy = t.createStableCopy();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            XmlTag tag = copy.getXmlTag();
            assert (tag != null);
            editor.getCaretModel().moveToOffset(tag.getTextRange().getStartOffset());
            copy.undefine();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            TemplateManager.getInstance((Project)project).startTemplate(editor, template);
        }
        return (T)t;
    }

    public void navigate(DomElement element) {
    }

    public DomElement getParentDomElement(Project project, Editor editor, PsiFile file) {
        if (file instanceof XmlFile) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file.findElementAt(offset);
            if (element == null) {
                return null;
            }
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
            if (tag != null) {
                for (DomElement dom = DomManager.getDomManager((Project)project).getDomElement(tag); dom != null; dom = dom.getParent()) {
                    for (Class<? extends DomElement> possibleParent : this.myPossibleParents) {
                        if (!possibleParent.isInstance(dom)) continue;
                        return dom;
                    }
                }
            }
        }
        return null;
    }
}

