/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.reference;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.lang.properties.ResourceBundleReference;
import com.intellij.lang.properties.ResourceBundleReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.CommonReferenceProviderTypes;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.PsiMethodCallFilter;
import com.intellij.psi.filters.ScopeFilter;
import com.intellij.psi.filters.position.FilterPattern;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PathListReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.WebPathReferenceProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.struts.dom.converters.StrutsPagesReferenceProvider;
import com.intellij.struts.facet.StrutsFacet;
import com.intellij.struts.facet.StrutsFacetConfiguration;
import com.intellij.struts.inplace.Filters;
import com.intellij.struts.inplace.reference.PathReferenceAdapter;
import com.intellij.struts.inplace.reference.ReferenceProviderUtils;
import com.intellij.struts.inplace.reference.WrappedReferenceProvider;
import com.intellij.struts.inplace.reference.code.FindForwardReferenceProvider;
import com.intellij.struts.inplace.reference.config.ActionReferenceProvider;
import com.intellij.struts.inplace.reference.config.FormReferenceProvider;
import com.intellij.struts.inplace.reference.config.ForwardReferenceProvider;
import com.intellij.struts.inplace.reference.config.ModuleReferenceProvider;
import com.intellij.struts.inplace.reference.config.RolesReferenceProvider;
import com.intellij.struts.inplace.reference.config.TilesJSPPutsReferenceProvider;
import com.intellij.struts.inplace.reference.config.TilesPutsReferenceProvider;
import com.intellij.struts.inplace.reference.config.TilesReferenceProvider;
import com.intellij.struts.inplace.reference.config.TilesValueReferenceProvider;
import com.intellij.struts.inplace.reference.config.ValidatorFormReferenceProvider;
import com.intellij.struts.inplace.reference.config.ValidatorReferenceProvider;
import com.intellij.struts.inplace.reference.config.WebAppPathListProvider;
import com.intellij.struts.inplace.reference.property.FormPropertyReferenceProvider;
import com.intellij.struts.inplace.reference.property.IndexedFormPropertyReferenceProvider;
import com.intellij.struts.inplace.reference.property.SetPropertyReferenceProvider;
import com.intellij.struts.inplace.reference.property.ValidatorFormPropertyReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsReferenceContributor
extends PsiReferenceContributor {
    private final PsiReferenceProvider actionProvider = new ActionReferenceProvider();
    private final PsiReferenceProvider moduleProvider = new ModuleReferenceProvider();
    private final PsiReferenceProvider forwardProvider = new ForwardReferenceProvider(false);
    private final PsiReferenceProvider pathProvider;
    private final PsiReferenceProvider softPathProvider;
    private final PsiReferenceProvider relativePathProvider;
    private final PsiReferenceProvider rolesProvider = new RolesReferenceProvider(false);
    private final PsiReferenceProvider singleRoleProvider = new RolesReferenceProvider(true);
    private final PsiReferenceProvider tileProvider = new TilesReferenceProvider(false);
    private final PsiReferenceProvider myJspFormPropertyProvider = new FormPropertyReferenceProvider();
    private final PsiReferenceProvider propProvider;
    private final PsiReferenceProvider originalPropProvider;
    @NonNls
    public static final String VALIDATOR_RULES_XML = "/org/apache/struts/validator/validator-rules.xml";
    @NonNls
    private static final String DATA_SOURCE = "data-source";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar psiReferenceRegistrar) {
        if (psiReferenceRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiReferenceRegistrar", "com/intellij/struts/inplace/reference/StrutsReferenceContributor", "registerReferenceProviders"));
        }
        this.registerStrutsConfigReferences(psiReferenceRegistrar);
        this.registerJspReferences(psiReferenceRegistrar);
        this.registerJspTilesTags(psiReferenceRegistrar);
        this.registerTilesReferences(psiReferenceRegistrar);
        this.registerValidationReferences(psiReferenceRegistrar);
        StrutsReferenceContributor.registerWebAppReferences(psiReferenceRegistrar);
        StrutsReferenceContributor.registerCodeReferences(psiReferenceRegistrar);
    }

    public StrutsReferenceContributor() {
        StrutsPagesReferenceProvider pagesReferenceProvider = new StrutsPagesReferenceProvider();
        this.pathProvider = new PathReferenceAdapter(pagesReferenceProvider, false);
        this.softPathProvider = new PathReferenceAdapter(pagesReferenceProvider, true);
        this.relativePathProvider = new WebPathReferenceProvider(false, true, true);
        this.originalPropProvider = CommonReferenceProviderTypes.PROPERTIES_FILE_KEY_PROVIDER.getProvider();
        this.propProvider = new WrappedReferenceProvider(this.originalPropProvider){

            @Override
            protected boolean accept(@NotNull PsiElement psiElement) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$1", "accept"));
                }
                return StrutsReferenceContributor.isPropertiesValidationEnabled(psiElement);
            }
        };
    }

    private static boolean isPropertiesValidationEnabled(PsiElement psiElement) {
        WebFacet webFacet = WebUtil.getWebFacet((PsiElement)psiElement);
        if (webFacet == null) {
            return false;
        }
        StrutsFacet strutsFacet = StrutsFacet.getInstance(webFacet);
        return strutsFacet == null || !((StrutsFacetConfiguration)strutsFacet.getConfiguration()).getValidationConfiguration().mySuppressPropertiesValidation;
    }

    private static void registerCodeReferences(PsiReferenceRegistrar registrar) {
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PsiLiteralExpression.class).and((ElementPattern)new FilterPattern((ElementFilter)new ParentElementFilter((ElementFilter)new PsiMethodCallFilter("org.apache.struts.action.ActionMapping", new String[]{"findForward"}), 2))), (PsiReferenceProvider)new FindForwardReferenceProvider());
    }

    private void registerStrutsConfigReferences(PsiReferenceRegistrar registrar) {
        ReferenceProviderUtils.registerTags(registrar, this.rolesProvider, "roles", Filters.NAMESPACE_STRUTS_CONFIG, "action");
        ReferenceProviderUtils.registerTags(registrar, new SetPropertyReferenceProvider("className", "type"){

            @Override
            protected String getClassNameAttribute(XmlTag tag) {
                if (tag.getLocalName().equals(StrutsReferenceContributor.DATA_SOURCE)) {
                    return "type";
                }
                return super.getClassNameAttribute(tag);
            }
        }, "property", Filters.NAMESPACE_STRUTS_CONFIG, "set-property");
        ReferenceProviderUtils.registerTags(registrar, (PsiReferenceProvider)new PathListReferenceProvider(){

            protected PsiReference[] createReferences(final @NotNull PsiElement element, String s, int offset, boolean soft) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$3", "createReferences"));
                }
                PsiElement tag = element.getParent().getParent().getParent();
                boolean bl = soft = tag instanceof XmlTag && !((XmlTag)tag).getName().equals("plug-in");
                if (s.equals(StrutsReferenceContributor.VALIDATOR_RULES_XML)) {
                    PsiReferenceBase<PsiElement> reference = new PsiReferenceBase<PsiElement>(element, new TextRange(offset, offset + s.length())){

                        public PsiElement resolve() {
                            return StrutsReferenceContributor.resolveValidatorConfigInJAR(element.getProject());
                        }

                        @NotNull
                        public Object[] getVariants() {
                            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$3$1", "getVariants"));
                            }
                            return ArrayUtil.EMPTY_OBJECT_ARRAY;
                        }
                    };
                    return new PsiReference[]{reference};
                }
                return super.createReferences(element, s, offset, soft);
            }
        }, "value", Filters.NAMESPACE_STRUTS_CONFIG, "set-property");
        ReferenceProviderUtils.registerTags(registrar, (PsiReferenceProvider)new ResourceBundleReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$4", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$4", "getReferencesByElement"));
                }
                XmlTag tag = (XmlTag)element.getParent().getParent();
                String factory = tag.getAttributeValue("factory");
                boolean soft = factory != null;
                ResourceBundleReference reference = new ResourceBundleReference(element, soft);
                PsiReference[] psiReferenceArray = new PsiReference[]{reference};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$4", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, "parameter", Filters.NAMESPACE_STRUTS_CONFIG, "message-resources");
        ReferenceProviderUtils.registerTags(registrar, this.propProvider, "key", Filters.NAMESPACE_STRUTS_CONFIG, "exception");
        ReferenceProviderUtils.registerTags(registrar, this.moduleProvider, "module", Filters.NAMESPACE_STRUTS_CONFIG, "forward");
    }

    private static void registerWebAppReferences(PsiReferenceRegistrar registrar) {
        XmlUtil.registerXmlTagReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"param-value"}, (ElementFilter)new NamespaceFilter(XmlUtil.WEB_XML_URIS), (boolean)true, (PsiReferenceProvider)new WebAppPathListProvider());
    }

    private void registerJspReferences(PsiReferenceRegistrar registrar) {
        ReferenceProviderUtils.registerTags(registrar, this.actionProvider, "action", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "form", "frame", "img", "link", "rewrite");
        ReferenceProviderUtils.registerTags(registrar, this.moduleProvider, "module", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "frame", "img", "image", "link", "rewrite");
        ReferenceProviderUtils.registerTags(registrar, this.forwardProvider, "forward", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "frame", "link", "rewrite");
        ReferenceProviderUtils.registerTags(registrar, this.pathProvider, "page", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "frame", "link", "rewrite", "img", "image");
        ReferenceProviderUtils.registerTags(registrar, this.softPathProvider, "href", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "frame", "link", "rewrite");
        ReferenceProviderUtils.registerTags(registrar, this.softPathProvider, "src", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "img", "image");
        ReferenceProviderUtils.registerTags(registrar, this.myJspFormPropertyProvider, "property", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "button", "cancel", "checkbox", "file", "hidden", "img", "link", "multibox", "option", "options", "optionsCollection", "password", "radio", "select", "text", "textarea");
        ReferenceProviderUtils.registerTags(registrar, this.myJspFormPropertyProvider, "labelProperty", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "options");
        ReferenceProviderUtils.registerTags(registrar, this.myJspFormPropertyProvider, "focus", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "form");
        ReferenceProviderUtils.registerTags(registrar, new FormReferenceProvider(), "formName", Filters.NAMESPACE_TAGLIB_STRUTS_HTML, "javascript");
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"altKey", "titleKey", "pageKey", "srcKey"}, (ElementFilter)new ScopeFilter((ElementFilter)new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)Filters.NAMESPACE_TAGLIB_STRUTS_HTML, ReferenceProviderUtils.TAG_CLASS_FILTER), 2)), (PsiReferenceProvider)this.propProvider);
        ReferenceProviderUtils.registerTags(registrar, this.actionProvider, "action", Filters.NAMESPACE_TAGLIB_STRUTS_LOGIC, "redirect");
        ReferenceProviderUtils.registerTags(registrar, this.softPathProvider, "href", Filters.NAMESPACE_TAGLIB_STRUTS_LOGIC, "redirect");
        ReferenceProviderUtils.registerTags(registrar, this.pathProvider, "page", Filters.NAMESPACE_TAGLIB_STRUTS_LOGIC, "redirect");
        ReferenceProviderUtils.registerTags(registrar, this.actionProvider, "mapping", Filters.NAMESPACE_TAGLIB_STRUTS_BEAN, "struts");
        ReferenceProviderUtils.registerTags(registrar, this.forwardProvider, "forward", Filters.NAMESPACE_TAGLIB_STRUTS_LOGIC, "redirect");
        ReferenceProviderUtils.registerTags(registrar, this.forwardProvider, "forward", Filters.NAMESPACE_TAGLIB_STRUTS_BEAN, "include", "struts");
        ReferenceProviderUtils.registerTags(registrar, this.forwardProvider, "name", Filters.NAMESPACE_TAGLIB_STRUTS_LOGIC, "forward");
        ReferenceProviderUtils.registerTags(registrar, new PsiReferenceProvider(){

            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$5", "getReferencesByElement"));
                }
                if (processingContext == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$5", "getReferencesByElement"));
                }
                JavaClassReferenceProvider classReferenceProvider = new JavaClassReferenceProvider();
                classReferenceProvider.setOption(JavaClassReferenceProvider.ADVANCED_RESOLVE, (Object)Boolean.TRUE);
                PsiReference[] psiReferenceArray = classReferenceProvider.getReferencesByElement(psiElement, processingContext);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$5", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }, "type", Filters.NAMESPACE_TAGLIB_STRUTS_BEAN, "define");
    }

    private void registerJspTilesTags(PsiReferenceRegistrar registrar) {
        ReferenceProviderUtils.registerSubclass(registrar, Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "insert", "controllerClass", "org.apache.struts.tiles.Controller", "org.apache.struts.tiles.ControllerSupport", "org.apache.struts.action.Action");
        ReferenceProviderUtils.registerTags(registrar, this.tileProvider, "definition", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "insert");
        ReferenceProviderUtils.registerAttributes(registrar, this.relativePathProvider, "insert", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "page", "component", "template");
        ReferenceProviderUtils.registerTags(registrar, this.pathProvider, "controllerUrl", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "insert");
        ReferenceProviderUtils.registerTags(registrar, this.singleRoleProvider, "role", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "insert");
        ReferenceProviderUtils.registerTags(registrar, this.tileProvider, "extends", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "definition");
        ReferenceProviderUtils.registerAttributes(registrar, this.pathProvider, "definition", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "page", "template");
        ReferenceProviderUtils.registerTags(registrar, this.singleRoleProvider, "role", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "definition");
        ReferenceProviderUtils.registerTags(registrar, (PsiReferenceProvider)new TilesValueReferenceProvider(), "value", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "put");
        ReferenceProviderUtils.registerTags(registrar, new TilesJSPPutsReferenceProvider(), "name", Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "put");
        ReferenceProviderUtils.registerSubclass(registrar, Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "useAttribute", "classname");
        ReferenceProviderUtils.registerSubclass(registrar, Filters.NAMESPACE_TAGLIB_STRUTS_TILES, "initComponentDefinitions", "classname", "org.apache.struts.tiles.DefinitionsFactory");
    }

    private void registerTilesReferences(PsiReferenceRegistrar registrar) {
        ReferenceProviderUtils.registerAttributes(registrar, this.softPathProvider, "item", Filters.NAMESPACE_TILES_CONFIG, "link", "icon");
        ReferenceProviderUtils.registerTags(registrar, new SetPropertyReferenceProvider("classtype", null), "property", Filters.NAMESPACE_TILES_CONFIG, "set-property");
        ReferenceProviderUtils.registerTags(registrar, (PsiReferenceProvider)new TilesValueReferenceProvider(), "value", Filters.NAMESPACE_TILES_CONFIG, "put");
        ReferenceProviderUtils.registerTags(registrar, (PsiReferenceProvider)new TilesValueReferenceProvider(), "value", Filters.NAMESPACE_TILES_CONFIG, "put-attribute");
        ReferenceProviderUtils.registerTags(registrar, new TilesPutsReferenceProvider(), "name", Filters.NAMESPACE_TILES_CONFIG, "put");
    }

    private void registerValidationReferences(PsiReferenceRegistrar registrar) {
        ReferenceProviderUtils.registerTags(registrar, new ValidatorFormReferenceProvider(), "name", Filters.NAMESPACE_VALIDATOR_CONFIG, "form");
        ReferenceProviderUtils.registerTags(registrar, new ValidatorFormPropertyReferenceProvider(), "property", Filters.NAMESPACE_VALIDATOR_CONFIG, "field");
        ReferenceProviderUtils.registerTags(registrar, new IndexedFormPropertyReferenceProvider(), "indexedListProperty", Filters.NAMESPACE_VALIDATOR_CONFIG, "field");
        ValidatorReferenceProvider myWrappedValidatorProvider = new ValidatorReferenceProvider(){

            @Override
            @NotNull
            public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext context) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$6", "getReferencesByElement"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$6", "getReferencesByElement"));
                }
                String value = ((XmlAttributeValue)psiElement).getValue();
                if (StringUtil.isEmpty((String)value)) {
                    if (PsiReference.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$6", "getReferencesByElement"));
                    }
                    return PsiReference.EMPTY_ARRAY;
                }
                PsiReference[] psiReferenceArray = super.getReferencesByElement(psiElement, context);
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$6", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        };
        ReferenceProviderUtils.registerTags(registrar, myWrappedValidatorProvider, "depends", Filters.NAMESPACE_VALIDATOR_CONFIG, "validator");
        WrappedReferenceProvider msgProvider = new WrappedReferenceProvider(this.originalPropProvider){

            @Override
            protected boolean accept(@NotNull PsiElement psiElement) {
                String res;
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$7", "accept"));
                }
                if (!StrutsReferenceContributor.isPropertiesValidationEnabled(psiElement)) {
                    return false;
                }
                PsiElement element = psiElement.getContext();
                assert (element != null);
                PsiElement context = element.getContext();
                return !(context instanceof XmlTag) || (res = ((XmlTag)context).getAttributeValue("classname")) != null && !res.trim().isEmpty();
            }
        };
        ReferenceProviderUtils.registerTags(registrar, msgProvider, "msg", Filters.NAMESPACE_VALIDATOR_CONFIG, "validator");
        WrappedReferenceProvider myWrappedPropProvider = new WrappedReferenceProvider(this.originalPropProvider){

            @Override
            protected boolean accept(@NotNull PsiElement psiElement) {
                String res;
                if (psiElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts/inplace/reference/StrutsReferenceContributor$8", "accept"));
                }
                if (!StrutsReferenceContributor.isPropertiesValidationEnabled(psiElement)) {
                    return false;
                }
                PsiElement element = psiElement.getContext();
                assert (element != null);
                PsiElement context = element.getContext();
                return !(context instanceof XmlTag) || (res = ((XmlTag)context).getAttributeValue("resource")) == null || !res.equals("false");
            }
        };
        ReferenceProviderUtils.registerTags(registrar, myWrappedPropProvider, "key", Filters.NAMESPACE_VALIDATOR_CONFIG, "msg", "arg", "arg0", "arg1", "arg2", "arg3");
    }

    @Nullable
    public static PsiFile resolveValidatorConfigInJAR(Project project) {
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass("org.apache.struts.validator.ValidatorForm", GlobalSearchScope.allScope((Project)project));
        if (psiClass == null) {
            return null;
        }
        VirtualFile file = psiClass.getContainingFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        String formPath = file.getUrl();
        formPath = StringUtil.replace((String)formPath, (String)"ValidatorForm.class", (String)"validator-rules.xml");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(formPath);
        if (virtualFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(virtualFile);
    }
}

