/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.engine;

import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.hibernate.engine.HibernateConnectionManager;
import com.intellij.hibernate.engine.HibernateConsoleRunContext;
import com.intellij.hibernate.remote.HibernateFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.EventDispatcher;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HibernateConnectionManagerImpl
extends HibernateConnectionManager {
    private final EventDispatcher<ModificationTrackerListener> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    private final RemoteConsoleProcessSupport<PersistencePackagePointer, HibernateFacade> mySupport = new RemoteConsoleProcessSupport<PersistencePackagePointer, HibernateFacade>(HibernateFacade.class){

        protected void fireModificationCountChanged() {
            HibernateConnectionManagerImpl.this.incModificationCount();
            ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)HibernateConnectionManagerImpl.this.myDispatcher.getMulticaster()).modificationCountChanged((Object)HibernateConnectionManagerImpl.this));
        }

        @NotNull
        protected ConsoleRunConfiguration.RunContext createRunContext(PersistencePackagePointer target) {
            HibernateConsoleRunContext hibernateConsoleRunContext = new HibernateConsoleRunContext(target);
            if (hibernateConsoleRunContext == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/engine/HibernateConnectionManagerImpl$1", "createRunContext"));
            }
            return hibernateConsoleRunContext;
        }

        protected String getName(PersistencePackagePointer file) {
            return ((VirtualFile)file).getName();
        }
    };

    public HibernateConnectionManagerImpl(Project project) {
        Disposer.register((Disposable)project, this.mySupport);
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/hibernate/engine/HibernateConnectionManagerImpl", "getActiveConfigurations"));
        }
        return this.mySupport.getActiveConfigurations((Object)unitFile);
    }

    @Override
    public HibernateFacade getConnection(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/hibernate/engine/HibernateConnectionManagerImpl", "getConnection"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/hibernate/engine/HibernateConnectionManagerImpl", "getConnection"));
        }
        return (HibernateFacade)this.mySupport.acquire((Object)unitFile, (Object)configuration);
    }

    @Override
    public void releaseConnection(@NotNull PersistencePackagePointer unitFile, @Nullable ConsoleRunConfiguration configuration) {
        if (unitFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unitFile", "com/intellij/hibernate/engine/HibernateConnectionManagerImpl", "releaseConnection"));
        }
        this.mySupport.release((Object)unitFile, (Object)configuration);
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<HibernateConnectionManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }
}

