/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.SupportAnnotationDetector;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.LintUtils;
import com.android.tools.klint.detector.api.Location;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class CallSuperDetector
extends Detector
implements Detector.UastScanner {
    private static final String CALL_SUPER_ANNOTATION = "android.support.annotation.CallSuper";
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("MissingSuperCall", "Missing Super Call", "Some methods, such as `View#onDetachedFromWindow`, require that you also call the super implementation as part of your method.", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UMethod.class);
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(final @NonNull JavaContext context) {
        return new AbstractUastVisitor(){

            public boolean visitMethod(UMethod method) {
                CallSuperDetector.checkCallSuper(context, method);
                return super.visitMethod(method);
            }
        };
    }

    private static void checkCallSuper(@NonNull JavaContext context, @NonNull UMethod method) {
        PsiMethod superMethod = CallSuperDetector.getRequiredSuperMethod(context, (PsiMethod)method);
        if (superMethod != null && !SuperCallVisitor.callsSuper(method, superMethod)) {
            String methodName2 = method.getName();
            String message = "Overriding method should call `super." + methodName2 + "`";
            Location location = context.getUastNameLocation((UElement)method);
            context.reportUast(ISSUE, (UElement)method, location, message);
        }
    }

    @Nullable
    private static PsiMethod getRequiredSuperMethod(@NonNull JavaContext context, @NonNull PsiMethod method) {
        JavaEvaluator evaluator = context.getEvaluator();
        PsiMethod directSuper = evaluator.getSuperMethod(method);
        if (directSuper == null) {
            return null;
        }
        String name = method.getName();
        if (ON_DETACHED_FROM_WINDOW.equals(name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.view.View", false)) {
                return null;
            }
            return directSuper;
        }
        if (ON_VISIBILITY_CHANGED.equals(name)) {
            if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                return null;
            }
            return directSuper;
        }
        PsiMethod superMethod = directSuper;
        while (superMethod != null) {
            PsiAnnotation[] annotations2 = superMethod.getModifierList().getAnnotations();
            for (PsiAnnotation annotation : annotations2 = SupportAnnotationDetector.filterRelevantAnnotations(context.getEvaluator(), annotations2)) {
                String signature = annotation.getQualifiedName();
                if (CALL_SUPER_ANNOTATION.equals(signature)) {
                    return directSuper;
                }
                if (signature == null || !signature.endsWith(".OverrideMustInvoke")) continue;
                return directSuper;
            }
            superMethod = evaluator.getSuperMethod(superMethod);
        }
        return null;
    }

    private static class SuperCallVisitor
    extends AbstractUastVisitor {
        private final PsiMethod mMethod;
        private boolean mCallsSuper;

        public static boolean callsSuper(@NonNull UMethod method, @NonNull PsiMethod superMethod) {
            SuperCallVisitor visitor = new SuperCallVisitor(superMethod);
            method.accept((UastVisitor)visitor);
            return visitor.mCallsSuper;
        }

        private SuperCallVisitor(@NonNull PsiMethod method) {
            this.mMethod = method;
        }

        public boolean visitSuperExpression(USuperExpression node) {
            PsiElement resolved;
            UElement parent = LintUtils.skipParentheses(node.getContainingElement());
            if (parent instanceof UReferenceExpression && this.mMethod.equals(resolved = ((UReferenceExpression)parent).resolve())) {
                this.mCallsSuper = true;
            }
            return super.visitSuperExpression(node);
        }
    }
}

