/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.klint.checks.PermissionFinder;
import com.android.tools.klint.checks.PermissionHolder;
import com.android.tools.klint.checks.PermissionRequirement;
import com.android.tools.klint.client.api.ExternalReferenceExpression;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.client.api.LintClient;
import com.android.tools.klint.client.api.UastLintUtils;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.ConstantEvaluator;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Project;
import com.android.tools.klint.detector.api.ResourceEvaluator;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.android.tools.klint.detector.api.TextFormat;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.java.JavaUAnnotation;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SupportAnnotationDetector
extends Detector
implements Detector.UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(SupportAnnotationDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue RANGE = Issue.create("Range", "Outside Range", "Some parameters are required to in a particular numerical range; this check makes sure that arguments passed fall within the range. For arrays, Strings and collections this refers to the size or length.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue RESOURCE_TYPE = Issue.create("ResourceType", "Wrong Resource Type", "Ensures that resource id's passed to APIs are of the right type; for example, calling `Resources.getColor(R.string.name)` is wrong.", Category.CORRECTNESS, 7, Severity.FATAL, IMPLEMENTATION);
    public static final Issue COLOR_USAGE = Issue.create("ResourceAsColor", "Should pass resolved color instead of resource id", "Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", Category.CORRECTNESS, 7, Severity.ERROR, IMPLEMENTATION);
    public static final Issue TYPE_DEF = Issue.create("WrongConstant", "Incorrect constant", "Ensures that when parameter in a method only allows a specific set of constants, calls obey those rules.", Category.SECURITY, 6, Severity.ERROR, IMPLEMENTATION);
    public static final Issue CHECK_RESULT = Issue.create("CheckResult", "Ignoring results", "Some methods have no side effects, an calling them without doing something without the result is suspicious. ", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue CHECK_PERMISSION = Issue.create("UseCheckPermission", "Using the result of check permission calls", "You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION);
    public static final Issue MISSING_PERMISSION = Issue.create("MissingPermission", "Missing Permissions", "This check scans through your code and libraries and looks at the APIs being used, and checks this against the set of permissions required to access those APIs. If the code using those APIs is called at runtime, then the program will crash.\n\nFurthermore, for permissions that are revocable (with targetSdkVersion 23), client code must also be prepared to handle the calls throwing an exception if the user rejects the request for permission at runtime.", Category.CORRECTNESS, 9, Severity.ERROR, IMPLEMENTATION);
    public static final Issue THREAD = Issue.create("WrongThread", "Wrong Thread", "Ensures that a method which expects to be called on a specific thread, is actually called from that thread. For example, calls on methods in widgets should always be made on the UI thread.", Category.CORRECTNESS, 6, Severity.ERROR, IMPLEMENTATION).addMoreInfo("http://developer.android.com/guide/components/processes-and-threads.html#Threads");
    public static final String CHECK_RESULT_ANNOTATION = "android.support.annotation.CheckResult";
    public static final String INT_RANGE_ANNOTATION = "android.support.annotation.IntRange";
    public static final String FLOAT_RANGE_ANNOTATION = "android.support.annotation.FloatRange";
    public static final String SIZE_ANNOTATION = "android.support.annotation.Size";
    public static final String PERMISSION_ANNOTATION = "android.support.annotation.RequiresPermission";
    public static final String UI_THREAD_ANNOTATION = "android.support.annotation.UiThread";
    public static final String MAIN_THREAD_ANNOTATION = "android.support.annotation.MainThread";
    public static final String WORKER_THREAD_ANNOTATION = "android.support.annotation.WorkerThread";
    public static final String BINDER_THREAD_ANNOTATION = "android.support.annotation.BinderThread";
    public static final String ANY_THREAD_ANNOTATION = "android.support.annotation.AnyThread";
    public static final String PERMISSION_ANNOTATION_READ = "android.support.annotation.RequiresPermission.Read";
    public static final String PERMISSION_ANNOTATION_WRITE = "android.support.annotation.RequiresPermission.Write";
    public static final String THREAD_SUFFIX = "Thread";
    public static final String ATTR_SUGGEST = "suggest";
    public static final String ATTR_TO = "to";
    public static final String ATTR_FROM = "from";
    public static final String ATTR_FROM_INCLUSIVE = "fromInclusive";
    public static final String ATTR_TO_INCLUSIVE = "toInclusive";
    public static final String ATTR_MULTIPLE = "multiple";
    public static final String ATTR_MIN = "min";
    public static final String ATTR_MAX = "max";
    public static final String ATTR_ALL_OF = "allOf";
    public static final String ATTR_ANY_OF = "anyOf";
    public static final String ATTR_CONDITIONAL = "conditional";
    public static final String SECURITY_EXCEPTION = "java.lang.SecurityException";
    private PermissionHolder mPermissions;

    private void checkMethodAnnotation(@NonNull JavaContext context, @NonNull PsiMethod method, @NonNull UCallExpression call, @NonNull UAnnotation annotation, @NonNull List<UAnnotation> allMethodAnnotations, @NonNull List<UAnnotation> allClassAnnotations) {
        String signature = annotation.getQualifiedName();
        if (signature == null) {
            return;
        }
        if (CHECK_RESULT_ANNOTATION.equals(signature) || signature.endsWith(".CheckReturnValue")) {
            SupportAnnotationDetector.checkResult(context, call, method, annotation);
        } else if (signature.equals(PERMISSION_ANNOTATION)) {
            PermissionRequirement requirement = PermissionRequirement.create(annotation);
            this.checkPermission(context, (UElement)call, method, null, requirement);
        } else if (signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.")) {
            SupportAnnotationDetector.checkThreading(context, (UElement)call, method, signature, annotation, allMethodAnnotations, allClassAnnotations);
        }
    }

    private void checkParameterAnnotations(@NonNull JavaContext context, @NonNull UExpression argument, @NonNull UCallExpression call, @NonNull PsiMethod method, @NonNull List<UAnnotation> annotations2) {
        boolean handledResourceTypes = false;
        for (UAnnotation annotation : annotations2) {
            String signature = annotation.getQualifiedName();
            if (signature == null) continue;
            if ("android.support.annotation.ColorInt".equals(signature)) {
                SupportAnnotationDetector.checkColor(context, (UElement)argument);
                continue;
            }
            if (signature.equals("android.support.annotation.Px")) {
                SupportAnnotationDetector.checkPx(context, (UElement)argument);
                continue;
            }
            if (signature.equals(INT_RANGE_ANNOTATION)) {
                SupportAnnotationDetector.checkIntRange(context, annotation, (UElement)argument, annotations2);
                continue;
            }
            if (signature.equals(FLOAT_RANGE_ANNOTATION)) {
                SupportAnnotationDetector.checkFloatRange(context, annotation, (UElement)argument);
                continue;
            }
            if (signature.equals(SIZE_ANNOTATION)) {
                SupportAnnotationDetector.checkSize(context, annotation, (UElement)argument);
                continue;
            }
            if (signature.startsWith(PERMISSION_ANNOTATION)) {
                this.checkParameterPermission(context, signature, (UElement)call, method, argument);
                continue;
            }
            if (signature.equals("android.support.annotation.IntDef")) {
                boolean flag = PermissionRequirement.getAnnotationBooleanValue(annotation, "flag") == Boolean.TRUE;
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)argument, null, flag, annotations2);
                continue;
            }
            if (signature.equals("android.support.annotation.StringDef")) {
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)argument, null, false, annotations2);
                continue;
            }
            if (!signature.endsWith("Res") || handledResourceTypes) continue;
            handledResourceTypes = true;
            EnumSet<ResourceType> types = null;
            for (UAnnotation a : annotations2) {
                String s = a.getQualifiedName();
                if (s == null || !s.endsWith("Res")) continue;
                String typeString = s.substring("android.support.annotation.".length(), s.length() - "Res".length()).toLowerCase(Locale.US);
                ResourceType type2 = ResourceType.getEnum((String)typeString);
                if (type2 != null) {
                    if (types == null) {
                        types = EnumSet.of(type2);
                        continue;
                    }
                    types.add(type2);
                    continue;
                }
                if (!typeString.equals("any")) continue;
                types = SupportAnnotationDetector.getAnyRes();
                break;
            }
            if (types == null) continue;
            SupportAnnotationDetector.checkResourceType(context, (UElement)argument, types, call, method);
        }
    }

    private static EnumSet<ResourceType> getAnyRes() {
        EnumSet<ResourceType> types = EnumSet.allOf(ResourceType.class);
        types.remove(ResourceEvaluator.COLOR_INT_MARKER_TYPE);
        types.remove(ResourceEvaluator.PX_MARKER_TYPE);
        return types;
    }

    private void checkParameterPermission(@NonNull JavaContext context, @NonNull String signature, @NonNull UElement call, @NonNull PsiMethod method, @NonNull UExpression argument) {
        PermissionFinder.Operation operation = null;
        if (signature.equals(PERMISSION_ANNOTATION_READ)) {
            operation = PermissionFinder.Operation.READ;
        } else if (signature.equals(PERMISSION_ANNOTATION_WRITE)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            PsiType type2 = argument.getExpressionType();
            if (type2 != null && "android.content.Intent".equals(type2.getCanonicalText())) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result = PermissionFinder.findRequiredPermissions(operation, context, (UElement)argument);
        if (result != null) {
            this.checkPermission(context, call, method, result, result.requirement);
        }
    }

    private static void checkColor(@NonNull JavaContext context, @NonNull UElement argument) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression2 = (UIfExpression)argument;
            if (expression2.getThenExpression() != null) {
                SupportAnnotationDetector.checkColor(context, (UElement)expression2.getThenExpression());
            }
            if (expression2.getElseExpression() != null) {
                SupportAnnotationDetector.checkColor(context, (UElement)expression2.getElseExpression());
            }
            return;
        }
        EnumSet<ResourceType> types = ResourceEvaluator.getResourceTypes(context, argument);
        if (types != null && types.contains(ResourceType.COLOR) && !SupportAnnotationDetector.isIgnoredInIde(COLOR_USAGE, context, argument)) {
            String message = String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.asSourceString());
            context.report(COLOR_USAGE, argument, context.getUastLocation(argument), message);
        }
    }

    private static void checkPx(@NonNull JavaContext context, @NonNull UElement argument) {
        if (argument instanceof UIfExpression) {
            UIfExpression expression2 = (UIfExpression)argument;
            if (expression2.getThenExpression() != null) {
                SupportAnnotationDetector.checkPx(context, (UElement)expression2.getThenExpression());
            }
            if (expression2.getElseExpression() != null) {
                SupportAnnotationDetector.checkPx(context, (UElement)expression2.getElseExpression());
            }
            return;
        }
        EnumSet<ResourceType> types = ResourceEvaluator.getResourceTypes(context, argument);
        if (types != null && types.contains(ResourceType.DIMEN)) {
            String message = String.format("Should pass resolved pixel dimension instead of resource id here: `getResources().getDimension*(%1$s)`", argument.asSourceString());
            context.report(COLOR_USAGE, argument, context.getUastLocation(argument), message);
        }
    }

    private static boolean isIgnoredInIde(@NonNull Issue issue, @NonNull JavaContext context, @NonNull UElement node) {
        Issue synonym = Issue.create("ResourceType", issue.getBriefDescription(TextFormat.RAW), issue.getExplanation(TextFormat.RAW), issue.getCategory(), issue.getPriority(), issue.getDefaultSeverity(), issue.getImplementation());
        return context.getDriver().isSuppressed(context, synonym, node);
    }

    private void checkPermission(@NonNull JavaContext context, @NonNull UElement node, @Nullable PsiMethod method, @Nullable PermissionFinder.Result result, @NonNull PermissionRequirement requirement) {
        if (requirement.isConditional()) {
            return;
        }
        PermissionHolder permissions = this.getPermissions(context);
        if (!requirement.isSatisfied(permissions)) {
            if (!requirement.isSatisfied(permissions = SupportAnnotationDetector.addLocalPermissions(permissions, node))) {
                PermissionFinder.Operation operation;
                String name;
                if (SupportAnnotationDetector.isIgnoredInIde(MISSING_PERMISSION, context, node)) {
                    return;
                }
                if (result != null) {
                    name = result.name;
                    operation = result.operation;
                } else {
                    assert (method != null);
                    PsiClass containingClass = method.getContainingClass();
                    name = containingClass != null ? containingClass.getName() + "." + method.getName() : method.getName();
                    operation = PermissionFinder.Operation.CALL;
                }
                String message = SupportAnnotationDetector.getMissingPermissionMessage(requirement, name, permissions, operation);
                context.report(MISSING_PERMISSION, node, context.getUastLocation(node), message);
            }
        } else if (requirement.isRevocable(permissions) && context.getMainProject().getTargetSdkVersion().getFeatureLevel() >= 23) {
            UMethod methodNode;
            boolean handlesMissingPermission = SupportAnnotationDetector.handlesSecurityException(node);
            if (!handlesMissingPermission && (methodNode = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true)) != null) {
                CheckPermissionVisitor visitor = new CheckPermissionVisitor(node);
                methodNode.accept((UastVisitor)visitor);
                handlesMissingPermission = visitor.checksPermission();
            }
            if (!handlesMissingPermission && !SupportAnnotationDetector.isIgnoredInIde(MISSING_PERMISSION, context, node)) {
                String message = SupportAnnotationDetector.getUnhandledPermissionMessage();
                context.report(MISSING_PERMISSION, node, context.getUastLocation(node), message);
            }
        }
    }

    private static boolean handlesSecurityException(@NonNull UElement node) {
        PsiClassType[] thrownTypes;
        UTryExpression tryCatch;
        UElement parent = node;
        while ((tryCatch = (UTryExpression)UastUtils.getParentOfType((UElement)parent, UTryExpression.class, (boolean)true)) != null) {
            for (UCatchClause catchClause : tryCatch.getCatchClauses()) {
                if (!SupportAnnotationDetector.containsSecurityException(catchClause.getTypes())) continue;
                return true;
            }
            parent = tryCatch;
        }
        UMethod declaration2 = (UMethod)UastUtils.getParentOfType((UElement)parent, UMethod.class, (boolean)false);
        return declaration2 != null && SupportAnnotationDetector.containsSecurityException(Arrays.asList(thrownTypes = declaration2.getThrowsList().getReferencedTypes()));
    }

    @NonNull
    private static PermissionHolder addLocalPermissions(@NonNull PermissionHolder permissions, @NonNull UElement node) {
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
        if (method == null) {
            return permissions;
        }
        UAnnotation annotation = method.findAnnotation(PERMISSION_ANNOTATION);
        permissions = SupportAnnotationDetector.mergeAnnotationPermissions(permissions, annotation);
        UClass containingClass = UastUtils.getContainingUClass((UElement)method);
        if (containingClass != null) {
            annotation = containingClass.findAnnotation(PERMISSION_ANNOTATION);
            permissions = SupportAnnotationDetector.mergeAnnotationPermissions(permissions, annotation);
        }
        return permissions;
    }

    @NonNull
    private static PermissionHolder mergeAnnotationPermissions(@NonNull PermissionHolder permissions, @Nullable UAnnotation annotation) {
        if (annotation != null) {
            PermissionRequirement requirement = PermissionRequirement.create(annotation);
            permissions = PermissionHolder.SetPermissionLookup.join(permissions, requirement);
        }
        return permissions;
    }

    public static String getMissingPermissionMessage(@NonNull PermissionRequirement requirement, @NonNull String callName, @NonNull PermissionHolder permissions, @NonNull PermissionFinder.Operation operation) {
        return String.format("Missing permissions required %1$s %2$s: %3$s", operation.prefix(), callName, requirement.describeMissingPermissions(permissions));
    }

    public static String getUnhandledPermissionMessage() {
        return "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
    }

    private static boolean containsSecurityException(@NonNull List<? extends PsiType> types) {
        for (PsiType psiType : types) {
            PsiClass cls;
            if (!(psiType instanceof PsiClassType) || (cls = ((PsiClassType)psiType).resolve()) == null || !SECURITY_EXCEPTION.equals(cls.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    private PermissionHolder getPermissions(@NonNull JavaContext context) {
        if (this.mPermissions == null) {
            HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
            HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
            LintClient client = context.getClient();
            Project mainProject = context.getMainProject();
            for (File manifest : mainProject.getManifestFiles()) {
                SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
            }
            for (Project library : mainProject.getAllLibraries()) {
                for (File manifest : library.getManifestFiles()) {
                    SupportAnnotationDetector.addPermissions(client, permissions, revocable, manifest);
                }
            }
            AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
            AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
            this.mPermissions = new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
        }
        return this.mPermissions;
    }

    private static void addPermissions(@NonNull LintClient client, @NonNull Set<String> permissions, @NonNull Set<String> revocable, @NonNull File manifest) {
        Document document = XmlUtils.parseDocumentSilently((String)client.readFile(manifest), (boolean)true);
        if (document == null) {
            return;
        }
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        NodeList children = root.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String name;
            String protectionLevel;
            Element element;
            Node item = children.item(i);
            if (item.getNodeType() != 1) continue;
            String nodeName = item.getNodeName();
            if (nodeName.equals("uses-permission") || nodeName.equals("uses-permission-sdk-23") || nodeName.equals("uses-permission-sdk-m")) {
                element = (Element)item;
                String name2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (name2.isEmpty()) continue;
                permissions.add(name2);
                continue;
            }
            if (!nodeName.equals("permission") || !"dangerous".equals(protectionLevel = (element = (Element)item).getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")) || (name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name")).isEmpty()) continue;
            revocable.add(name);
        }
    }

    private static void checkResult(@NonNull JavaContext context, @NonNull UCallExpression node, @NonNull PsiMethod method, @NonNull UAnnotation annotation) {
        if (SupportAnnotationDetector.isExpressionValueUnused((UExpression)node)) {
            String methodName2 = JavaContext.getMethodName((UElement)node);
            String suggested = PermissionRequirement.getAnnotationStringValue(annotation, ATTR_SUGGEST);
            Issue issue = CHECK_RESULT;
            if (methodName2 != null && methodName2.startsWith("check") && methodName2.contains("Permission")) {
                issue = CHECK_PERMISSION;
            }
            if (SupportAnnotationDetector.isIgnoredInIde(issue, context, (UElement)node)) {
                return;
            }
            String message = String.format("The result of `%1$s` is not used", methodName2);
            if (suggested != null) {
                message = String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", methodName2, suggested);
            } else if ("intersect".equals(methodName2)) {
                context.getEvaluator();
                if (JavaEvaluator.isMemberInClass((PsiMember)method, "android.graphics.Rect")) {
                    message = message + ". If the rectangles do not intersect, no change is made and the original rectangle is not modified. These methods return false to indicate that this has happened.";
                }
            }
            context.report(issue, (UElement)node, context.getUastLocation((UElement)node), message);
        }
    }

    private static boolean isExpressionValueUnused(UExpression expression2) {
        return UastUtils.getQualifiedParentOrThis((UExpression)expression2).getContainingElement() instanceof UBlockExpression;
    }

    private static void checkThreading(@NonNull JavaContext context, @NonNull UElement node, @NonNull PsiMethod method, @NonNull String signature, @NonNull UAnnotation annotation, @NonNull List<UAnnotation> allMethodAnnotations, @NonNull List<UAnnotation> allClassAnnotations) {
        List<String> threadContext = SupportAnnotationDetector.getThreadContext(context, node);
        if (threadContext != null && !SupportAnnotationDetector.isCompatibleThread(threadContext, signature) && !SupportAnnotationDetector.isIgnoredInIde(THREAD, context, node)) {
            List<String> targetThreads;
            String name;
            if (SupportAnnotationDetector.containsAnnotation(allClassAnnotations, annotation)) {
                if (SupportAnnotationDetector.containsThreadingAnnotation(allMethodAnnotations)) {
                    return;
                }
            } else {
                assert (SupportAnnotationDetector.containsAnnotation(allMethodAnnotations, annotation));
                Boolean isFirst = null;
                for (UAnnotation other : allMethodAnnotations) {
                    if (other == annotation) {
                        if (isFirst != null) continue;
                        isFirst = true;
                        continue;
                    }
                    if (!SupportAnnotationDetector.isThreadingAnnotation(other)) continue;
                    if (isFirst == null) {
                        return;
                    }
                    String s = other.getQualifiedName();
                    if (s == null || !SupportAnnotationDetector.isCompatibleThread(threadContext, s)) continue;
                    return;
                }
            }
            if ((name = method.getName()).startsWith("post")) {
                context.getEvaluator();
                if (JavaEvaluator.isMemberInClass((PsiMember)method, "android.view.View")) {
                    return;
                }
            }
            if ((targetThreads = SupportAnnotationDetector.getThreads(context, method)) == null) {
                targetThreads = Collections.singletonList(signature);
            }
            String message = String.format("%1$s %2$s must be called from the `%3$s` thread, currently inferred thread is `%4$s` thread", method.isConstructor() ? "Constructor" : "Method", method.getName(), SupportAnnotationDetector.describeThreads(targetThreads, true), SupportAnnotationDetector.describeThreads(threadContext, false));
            context.report(THREAD, node, context.getUastLocation(node), message);
        }
    }

    public static boolean containsAnnotation(@NonNull List<UAnnotation> array, @NonNull UAnnotation annotation) {
        for (UAnnotation a : array) {
            if (a != annotation) continue;
            return true;
        }
        return false;
    }

    public static boolean containsThreadingAnnotation(@NonNull List<UAnnotation> array) {
        for (UAnnotation annotation : array) {
            if (!SupportAnnotationDetector.isThreadingAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThreadingAnnotation(@NonNull UAnnotation annotation) {
        String signature = annotation.getQualifiedName();
        return signature != null && signature.endsWith(THREAD_SUFFIX) && signature.startsWith("android.support.annotation.");
    }

    @NonNull
    public static String describeThreads(@NonNull List<String> annotations2, boolean any) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < annotations2.size(); ++i) {
            if (i > 0) {
                if (i == annotations2.size() - 1) {
                    if (any) {
                        sb.append(" or ");
                    } else {
                        sb.append(" and ");
                    }
                } else {
                    sb.append(", ");
                }
            }
            sb.append(SupportAnnotationDetector.describeThread(annotations2.get(i)));
        }
        return sb.toString();
    }

    @NonNull
    public static String describeThread(@NonNull String annotation) {
        if (annotation.equals(UI_THREAD_ANNOTATION)) {
            return "UI";
        }
        if (annotation.equals(MAIN_THREAD_ANNOTATION)) {
            return "main";
        }
        if (annotation.equals(BINDER_THREAD_ANNOTATION)) {
            return "binder";
        }
        if (annotation.equals(WORKER_THREAD_ANNOTATION)) {
            return "worker";
        }
        if (annotation.equals(ANY_THREAD_ANNOTATION)) {
            return "any";
        }
        return "other";
    }

    public static boolean isCompatibleThread(@NonNull List<String> callers, @NonNull String callee) {
        assert (!callers.isEmpty());
        for (String caller : callers) {
            if (SupportAnnotationDetector.isCompatibleThread(caller, callee)) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatibleThread(@NonNull String caller, @NonNull String callee) {
        if (callee.equals(caller)) {
            return true;
        }
        if (callee.equals(ANY_THREAD_ANNOTATION)) {
            return true;
        }
        return callee.equals(UI_THREAD_ANNOTATION) ? caller.equals(MAIN_THREAD_ANNOTATION) : callee.equals(MAIN_THREAD_ANNOTATION) && caller.equals(UI_THREAD_ANNOTATION);
    }

    @Nullable
    private static List<String> getThreadContext(@NonNull JavaContext context, @NonNull UElement methodCall) {
        PsiMethod method = (PsiMethod)UastUtils.getParentOfType((UElement)methodCall, UMethod.class, (boolean)true, (Class[])new Class[]{UAnonymousClass.class});
        return SupportAnnotationDetector.getThreads(context, method);
    }

    @Nullable
    private static List<String> getThreads(@NonNull JavaContext context, @Nullable PsiMethod method) {
        if (method != null) {
            ArrayList<String> result = null;
            PsiClass cls = method.getContainingClass();
            while (method != null) {
                for (PsiAnnotation annotation : method.getModifierList().getAnnotations()) {
                    String name = annotation.getQualifiedName();
                    if (name == null || !name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                    if (result == null) {
                        result = new ArrayList<String>(4);
                    }
                    result.add(name);
                }
                if (result != null) {
                    return result;
                }
                method = context.getEvaluator().getSuperMethod(method);
            }
            while (cls != null) {
                PsiModifierList modifierList = cls.getModifierList();
                if (modifierList != null) {
                    for (PsiAnnotation annotation : modifierList.getAnnotations()) {
                        String name = annotation.getQualifiedName();
                        if (name == null || !name.startsWith("android.support.annotation.") || !name.endsWith(THREAD_SUFFIX)) continue;
                        if (result == null) {
                            result = new ArrayList(4);
                        }
                        result.add(name);
                    }
                    if (result != null) {
                        return result;
                    }
                }
                cls = cls.getSuperClass();
            }
        }
        return null;
    }

    private static boolean isNumber(@NonNull UElement argument) {
        if (argument instanceof ULiteralExpression) {
            Object value2 = ((ULiteralExpression)argument).getValue();
            return value2 instanceof Number;
        }
        if (argument instanceof UPrefixExpression) {
            UPrefixExpression expression2 = (UPrefixExpression)argument;
            UExpression operand2 = expression2.getOperand();
            return SupportAnnotationDetector.isNumber((UElement)operand2);
        }
        return false;
    }

    private static boolean isZero(@NonNull UElement argument) {
        if (argument instanceof ULiteralExpression) {
            Object value2 = ((ULiteralExpression)argument).getValue();
            return value2 instanceof Number && ((Number)value2).intValue() == 0;
        }
        return false;
    }

    private static boolean isMinusOne(@NonNull UElement argument) {
        if (argument instanceof UPrefixExpression) {
            UPrefixExpression expression2 = (UPrefixExpression)argument;
            UExpression operand2 = expression2.getOperand();
            if (operand2 instanceof ULiteralExpression && expression2.getOperator() == UastPrefixOperator.UNARY_MINUS) {
                Object value2 = ((ULiteralExpression)operand2).getValue();
                return value2 instanceof Number && ((Number)value2).intValue() == 1;
            }
            return false;
        }
        return false;
    }

    private static void checkResourceType(@NonNull JavaContext context, @NonNull UElement argument, @NonNull EnumSet<ResourceType> expectedType, @NonNull UCallExpression call, @NonNull PsiMethod calledMethod) {
        EnumSet<ResourceType> actual = ResourceEvaluator.getResourceTypes(context, argument);
        if (actual == null && (!SupportAnnotationDetector.isNumber(argument) || SupportAnnotationDetector.isZero(argument) || SupportAnnotationDetector.isMinusOne(argument))) {
            return;
        }
        if (actual != null && (!Sets.intersection(actual, expectedType).isEmpty() || expectedType.contains(ResourceType.DRAWABLE) && (actual.contains(ResourceType.COLOR) || actual.contains(ResourceType.MIPMAP)))) {
            return;
        }
        if (SupportAnnotationDetector.isIgnoredInIde(RESOURCE_TYPE, context, argument)) {
            return;
        }
        if (expectedType.contains(ResourceType.STYLEABLE) && expectedType.size() == 1 && JavaEvaluator.isMemberInClass((PsiMember)calledMethod, "android.content.res.TypedArray") && SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)call.getReceiver(), context)) {
            return;
        }
        String message = actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? "Expected a color resource id (`R.color.`) but received an RGB integer" : (expectedType.contains(ResourceEvaluator.COLOR_INT_MARKER_TYPE) ? String.format("Should pass resolved color instead of resource id here: `getResources().getColor(%1$s)`", argument.asSourceString()) : (actual != null && actual.size() == 1 && actual.contains(ResourceEvaluator.PX_MARKER_TYPE) ? "Expected a dimension resource id (`R.color.`) but received a pixel integer" : (expectedType.contains(ResourceEvaluator.PX_MARKER_TYPE) ? String.format("Should pass resolved pixel size instead of resource id here: `getResources().getDimension*(%1$s)`", argument.asSourceString()) : (expectedType.size() < ResourceType.getNames().length - 2 ? String.format("Expected resource of type %1$s", Joiner.on((String)" or ").join(expectedType)) : "Expected resource identifier (`R`.type.`name`)"))));
        context.report(RESOURCE_TYPE, argument, context.getUastLocation(argument), message);
    }

    public static boolean typeArrayFromArrayLiteral(@Nullable UElement node, @NonNull JavaContext context) {
        if (SupportAnnotationDetector.isMethodCall(node)) {
            List expressions2;
            UCallExpression expression2 = (UCallExpression)node;
            assert (expression2 != null);
            String name = expression2.getMethodName();
            if (name != null && "obtainStyledAttributes".equals(name) && !(expressions2 = expression2.getValueArguments()).isEmpty()) {
                int arg;
                if (expressions2.size() == 1) {
                    arg = 0;
                } else if (expressions2.size() == 2) {
                    PsiType type2;
                    for (arg = 0; arg < expressions2.size() && !((type2 = ((UExpression)expressions2.get(arg)).getExpressionType()) instanceof PsiArrayType); ++arg) {
                    }
                    if (arg == expressions2.size()) {
                        return false;
                    }
                } else if (expressions2.size() == 4) {
                    arg = 1;
                } else {
                    return false;
                }
                return ConstantEvaluator.isArrayLiteral((UElement)expressions2.get(arg), context);
            }
            return false;
        }
        if (node instanceof UReferenceExpression) {
            PsiVariable variable2;
            UExpression lastAssignment;
            PsiElement resolved = ((UReferenceExpression)node).resolve();
            if (resolved instanceof PsiVariable && (lastAssignment = UastLintUtils.findLastAssignment(variable2 = (PsiVariable)resolved, node, context)) != null) {
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)lastAssignment, context);
            }
        } else {
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)node)) {
                return true;
            }
            if (UastExpressionUtils.isNewArrayWithDimensions((UElement)node)) {
                return true;
            }
            if (node instanceof UParenthesizedExpression) {
                UParenthesizedExpression parenthesizedExpression = (UParenthesizedExpression)node;
                UExpression expression3 = parenthesizedExpression.getExpression();
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)expression3, context);
            }
            if (UastExpressionUtils.isTypeCast((UElement)node)) {
                UBinaryExpressionWithType castExpression = (UBinaryExpressionWithType)node;
                assert (castExpression != null);
                UExpression operand2 = castExpression.getOperand();
                return SupportAnnotationDetector.typeArrayFromArrayLiteral((UElement)operand2, context);
            }
        }
        return false;
    }

    private static boolean isMethodCall(UElement node) {
        if (node instanceof UQualifiedReferenceExpression) {
            UExpression last = SupportAnnotationDetector.getLastInQualifiedChain((UQualifiedReferenceExpression)node);
            return UastExpressionUtils.isMethodCall((UElement)last);
        }
        return UastExpressionUtils.isMethodCall((UElement)node);
    }

    @NonNull
    private static UExpression getLastInQualifiedChain(@NonNull UQualifiedReferenceExpression node) {
        UExpression last = node.getSelector();
        while (last instanceof UQualifiedReferenceExpression) {
            last = ((UQualifiedReferenceExpression)last).getSelector();
        }
        return last;
    }

    private static void checkIntRange(@NonNull JavaContext context, @NonNull UAnnotation annotation, @NonNull UElement argument, @NonNull List<UAnnotation> allAnnotations) {
        String message = SupportAnnotationDetector.getIntRangeError(context, annotation, argument);
        if (message != null) {
            if (SupportAnnotationDetector.findIntDef(allAnnotations) != null) {
                return;
            }
            if (SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
                return;
            }
            context.report(RANGE, argument, context.getUastLocation(argument), message);
        }
    }

    @Nullable
    private static String getIntRangeError(@NonNull JavaContext context, @NonNull UAnnotation annotation, @NonNull UElement argument) {
        Object object;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            UCallExpression newExpression = (UCallExpression)argument;
            for (UExpression expression2 : newExpression.getValueArguments()) {
                String error = SupportAnnotationDetector.getIntRangeError(context, annotation, (UElement)expression2);
                if (error == null) continue;
                return error;
            }
        }
        if (!((object = ConstantEvaluator.evaluate(context, argument)) instanceof Number)) {
            return null;
        }
        long value2 = ((Number)object).longValue();
        long from = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_FROM, Long.MIN_VALUE);
        long to = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_TO, Long.MAX_VALUE);
        return SupportAnnotationDetector.getIntRangeError(value2, from, to);
    }

    private static String getIntRangeError(long value2, long from, long to) {
        String message = null;
        if (value2 < from || value2 > to) {
            StringBuilder sb = new StringBuilder(20);
            if (value2 < from) {
                sb.append("Value must be \u2265 ");
                sb.append(Long.toString(from));
            } else {
                assert (value2 > to);
                sb.append("Value must be \u2264 ");
                sb.append(Long.toString(to));
            }
            sb.append(" (was ").append(value2).append(')');
            message = sb.toString();
        }
        return message;
    }

    private static void checkFloatRange(@NonNull JavaContext context, @NonNull UAnnotation annotation, @NonNull UElement argument) {
        boolean toInclusive;
        boolean fromInclusive;
        double to;
        double from;
        Object object = ConstantEvaluator.evaluate(context, argument);
        if (!(object instanceof Number)) {
            return;
        }
        double value2 = ((Number)object).doubleValue();
        String message = SupportAnnotationDetector.getFloatRangeError(value2, from = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_FROM, Double.NEGATIVE_INFINITY), to = SupportAnnotationDetector.getDoubleAttribute(annotation, ATTR_TO, Double.POSITIVE_INFINITY), fromInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_FROM_INCLUSIVE, true), toInclusive = SupportAnnotationDetector.getBoolean(annotation, ATTR_TO_INCLUSIVE, true), argument);
        if (message != null && !SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
            context.report(RANGE, argument, context.getUastLocation(argument), message);
        }
    }

    @Nullable
    private static String getFloatRangeError(double value2, double from, double to, boolean fromInclusive, boolean toInclusive, @NonNull UElement node) {
        if (!((fromInclusive && value2 >= from || !fromInclusive && value2 > from) && (toInclusive && value2 <= to || !toInclusive && value2 < to))) {
            StringBuilder sb = new StringBuilder(20);
            if (from != Double.NEGATIVE_INFINITY) {
                if (to != Double.POSITIVE_INFINITY) {
                    if (fromInclusive && value2 < from || !fromInclusive && value2 <= from) {
                        sb.append("Value must be ");
                        if (fromInclusive) {
                            sb.append('\u2265');
                        } else {
                            sb.append('>');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(from));
                    } else {
                        assert (toInclusive && value2 > to || !toInclusive && value2 >= to);
                        sb.append("Value must be ");
                        if (toInclusive) {
                            sb.append('\u2264');
                        } else {
                            sb.append('<');
                        }
                        sb.append(' ');
                        sb.append(Double.toString(to));
                    }
                } else {
                    sb.append("Value must be ");
                    if (fromInclusive) {
                        sb.append('\u2265');
                    } else {
                        sb.append('>');
                    }
                    sb.append(' ');
                    sb.append(Double.toString(from));
                }
            } else if (to != Double.POSITIVE_INFINITY) {
                sb.append("Value must be ");
                if (toInclusive) {
                    sb.append('\u2264');
                } else {
                    sb.append('<');
                }
                sb.append(' ');
                sb.append(Double.toString(to));
            }
            sb.append(" (was ");
            if (node instanceof ULiteralExpression) {
                String str = node.asSourceString();
                if (str.endsWith("f") || str.endsWith("F")) {
                    str = str.substring(0, str.length() - 1);
                }
                sb.append(str);
            } else {
                sb.append(value2);
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    private static void checkSize(@NonNull JavaContext context, @NonNull UAnnotation annotation, @NonNull UElement argument) {
        int actual;
        boolean isString = false;
        if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
            actual = ((UCallExpression)argument).getValueArgumentCount();
        } else {
            Object object = ConstantEvaluator.evaluate(context, argument);
            if (object instanceof String) {
                actual = ((String)object).length();
                isString = true;
            } else {
                return;
            }
        }
        long exact = SupportAnnotationDetector.getLongAttribute(annotation, "value", -1L);
        long min = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MIN, Long.MIN_VALUE);
        long max = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MAX, Long.MAX_VALUE);
        long multiple = SupportAnnotationDetector.getLongAttribute(annotation, ATTR_MULTIPLE, 1L);
        String unit = isString ? "length" : "size";
        String message = SupportAnnotationDetector.getSizeError(actual, exact, min, max, multiple, unit);
        if (message != null && !SupportAnnotationDetector.isIgnoredInIde(RANGE, context, argument)) {
            context.report(RANGE, argument, context.getUastLocation(argument), message);
        }
    }

    private static String getSizeError(long actual, long exact, long min, long max, long multiple, @NonNull String unit) {
        String message = null;
        if (exact != -1L) {
            if (exact != actual) {
                message = String.format("Expected %1$s %2$d (was %3$d)", unit, exact, actual);
            }
        } else if (actual < min || actual > max) {
            StringBuilder sb = new StringBuilder(20);
            if (actual < min) {
                sb.append("Expected ").append(unit).append(" \u2265 ");
                sb.append(Long.toString(min));
            } else {
                assert (actual > max);
                sb.append("Expected ").append(unit).append(" \u2264 ");
                sb.append(Long.toString(max));
            }
            sb.append(" (was ").append(actual).append(')');
            message = sb.toString();
        } else if (actual % multiple != 0L) {
            message = String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, multiple, actual, actual / multiple * multiple, (actual / multiple + 1L) * multiple);
        }
        return message;
    }

    @Nullable
    private static UAnnotation findIntRange(@NonNull List<UAnnotation> annotations2) {
        for (UAnnotation annotation : annotations2) {
            if (!INT_RANGE_ANNOTATION.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    static UAnnotation findIntDef(@NonNull List<UAnnotation> annotations2) {
        for (UAnnotation annotation : annotations2) {
            if (!"android.support.annotation.IntDef".equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    private static void checkTypeDefConstant(@NonNull JavaContext context, @NonNull UAnnotation annotation, @Nullable UElement argument, @Nullable UElement errorNode, boolean flag, @NonNull List<UAnnotation> allAnnotations) {
        block37: {
            block36: {
                PsiVariable variable2;
                block38: {
                    UastPrefixOperator operator;
                    UPrefixExpression expression2;
                    if (argument == null) {
                        return;
                    }
                    if (argument instanceof ULiteralExpression) {
                        Object value2 = ((ULiteralExpression)argument).getValue();
                        if (value2 == null) {
                            return;
                        }
                        if (value2 instanceof String) {
                            String string = (String)value2;
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, false, string, allAnnotations);
                        } else if (value2 instanceof Integer || value2 instanceof Long) {
                            long v;
                            long l = v = value2 instanceof Long ? ((Long)value2).longValue() : ((Integer)value2).longValue();
                            if (flag && v == 0L) {
                                return;
                            }
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode, flag, value2, allAnnotations);
                        }
                    } else if (SupportAnnotationDetector.isMinusOne(argument)) {
                        if (!flag) {
                            SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                        }
                    } else if (argument instanceof UPrefixExpression) {
                        expression2 = (UPrefixExpression)argument;
                        if (flag) {
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2.getOperand(), errorNode, true, allAnnotations);
                        } else {
                            operator = expression2.getOperator();
                            if (operator == UastPrefixOperator.BITWISE_NOT) {
                                if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, (UElement)expression2)) {
                                    return;
                                }
                                context.report(TYPE_DEF, (UElement)expression2, context.getUastLocation((UElement)expression2), "Flag not allowed here");
                            } else if (operator == UastPrefixOperator.UNARY_MINUS) {
                                SupportAnnotationDetector.reportTypeDef(context, annotation, argument, errorNode, allAnnotations);
                            }
                        }
                    } else if (argument instanceof UParenthesizedExpression) {
                        expression2 = ((UParenthesizedExpression)argument).getExpression();
                        if (expression2 != null) {
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2, errorNode, flag, allAnnotations);
                        }
                    } else if (argument instanceof UIfExpression) {
                        expression2 = (UIfExpression)argument;
                        if (expression2.getThenExpression() != null) {
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2.getThenExpression(), errorNode, flag, allAnnotations);
                        }
                        if (expression2.getElseExpression() != null) {
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2.getElseExpression(), errorNode, flag, allAnnotations);
                        }
                    } else if (argument instanceof UBinaryExpression) {
                        expression2 = (UBinaryExpression)argument;
                        if (flag) {
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2.getLeftOperand(), errorNode, true, allAnnotations);
                            SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression2.getRightOperand(), errorNode, true, allAnnotations);
                        } else {
                            operator = expression2.getOperator();
                            if (operator == UastBinaryOperator.BITWISE_AND || operator == UastBinaryOperator.BITWISE_OR || operator == UastBinaryOperator.BITWISE_XOR) {
                                if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, (UElement)expression2)) {
                                    return;
                                }
                                context.report(TYPE_DEF, (UElement)expression2, context.getUastLocation((UElement)expression2), "Flag not allowed here");
                            }
                        }
                    }
                    if (!(argument instanceof UReferenceExpression)) break block36;
                    PsiElement resolved = ((UReferenceExpression)argument).resolve();
                    if (!(resolved instanceof PsiVariable)) break block37;
                    variable2 = (PsiVariable)resolved;
                    if (variable2.getType() instanceof PsiArrayType) {
                        return;
                    }
                    if (!variable2.hasModifierProperty("static") || !variable2.hasModifierProperty("final")) break block38;
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, argument, errorNode != null ? errorNode : argument, flag, resolved, allAnnotations);
                    break block37;
                }
                UExpression lastAssignment = UastLintUtils.findLastAssignment(variable2, argument, context);
                if (lastAssignment == null) break block37;
                SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)lastAssignment, errorNode != null ? errorNode : argument, flag, allAnnotations);
                break block37;
            }
            if (UastExpressionUtils.isNewArrayWithInitializer((UElement)argument)) {
                UCallExpression arrayInitializer = (UCallExpression)argument;
                PsiType type2 = arrayInitializer.getExpressionType();
                if (type2 != null) {
                    type2 = type2.getDeepComponentType();
                }
                if (PsiType.INT.equals((Object)type2) || PsiType.LONG.equals((Object)type2)) {
                    for (UExpression expression3 : arrayInitializer.getValueArguments()) {
                        SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)expression3, errorNode, flag, allAnnotations);
                    }
                }
            }
        }
    }

    private static void checkTypeDefConstant(@NonNull JavaContext context, @NonNull UAnnotation annotation, @NonNull UElement argument, @Nullable UElement errorNode, boolean flag, Object value2, @NonNull List<UAnnotation> allAnnotations) {
        UAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, argument) == null) {
            return;
        }
        UExpression allowed = SupportAnnotationDetector.getAnnotationValue(annotation);
        if (allowed == null) {
            return;
        }
        if (UastExpressionUtils.isArrayInitializer((UElement)allowed)) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            for (UExpression expression2 : initializers) {
                PsiElement resolved;
                if (!(expression2 instanceof ULiteralExpression ? value2.equals(((ULiteralExpression)expression2).getValue()) : (expression2 instanceof ExternalReferenceExpression ? (resolved = UastLintUtils.resolve((ExternalReferenceExpression)expression2, argument)) != null && resolved.equals(value2) : expression2 instanceof UReferenceExpression && (resolved = ((UReferenceExpression)expression2).resolve()) != null && resolved.equals(value2)))) continue;
                return;
            }
            if (value2 instanceof PsiField) {
                PsiField astNode = (PsiField)value2;
                UExpression initializer = context.getUastContext().getInitializerBody((PsiVariable)astNode);
                if (initializer != null) {
                    SupportAnnotationDetector.checkTypeDefConstant(context, annotation, (UElement)initializer, errorNode, flag, allAnnotations);
                    return;
                }
            }
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, flag, initializers, allAnnotations);
        }
    }

    private static void reportTypeDef(@NonNull JavaContext context, @NonNull UAnnotation annotation, @NonNull UElement argument, @Nullable UElement errorNode, @NonNull List<UAnnotation> allAnnotations) {
        UExpression allowed = SupportAnnotationDetector.getAnnotationValue(annotation);
        if (UastExpressionUtils.isArrayInitializer((UElement)allowed)) {
            UCallExpression initializerExpression = (UCallExpression)allowed;
            List initializers = initializerExpression.getValueArguments();
            SupportAnnotationDetector.reportTypeDef(context, argument, errorNode, false, initializers, allAnnotations);
        }
    }

    private static void reportTypeDef(@NonNull JavaContext context, @NonNull UElement node, @Nullable UElement errorNode, boolean flag, @NonNull List<UExpression> allowedValues, @NonNull List<UAnnotation> allAnnotations) {
        String rangeError;
        if (errorNode == null) {
            errorNode = node;
        }
        if (SupportAnnotationDetector.isIgnoredInIde(TYPE_DEF, context, errorNode)) {
            return;
        }
        String values = SupportAnnotationDetector.listAllowedValues(node, allowedValues);
        String message = flag ? "Must be one or more of: " + values : "Must be one of: " + values;
        UAnnotation rangeAnnotation = SupportAnnotationDetector.findIntRange(allAnnotations);
        if (rangeAnnotation != null && (rangeError = SupportAnnotationDetector.getIntRangeError(context, rangeAnnotation, node)) != null && !rangeError.isEmpty()) {
            message = message + " or " + Character.toLowerCase(rangeError.charAt(0)) + rangeError.substring(1);
        }
        context.report(TYPE_DEF, errorNode, context.getUastLocation(errorNode), message);
    }

    @Nullable
    private static UExpression getAnnotationValue(@NonNull UAnnotation annotation) {
        UNamedExpression value2 = annotation.findDeclaredAttributeValue("value");
        if (value2 == null) {
            value2 = annotation.findDeclaredAttributeValue(null);
        }
        if (value2 == null) {
            return null;
        }
        return value2.getExpression();
    }

    private static String listAllowedValues(@NonNull UElement context, @NonNull List<UExpression> allowedValues) {
        StringBuilder sb = new StringBuilder();
        for (UExpression allowedValue : allowedValues) {
            String s = null;
            PsiElement resolved = null;
            if (allowedValue instanceof ExternalReferenceExpression) {
                resolved = UastLintUtils.resolve((ExternalReferenceExpression)allowedValue, context);
            } else if (allowedValue instanceof UReferenceExpression) {
                resolved = ((UReferenceExpression)allowedValue).resolve();
            }
            if (resolved instanceof PsiField) {
                String containingClassName;
                PsiField field = (PsiField)resolved;
                String string = containingClassName = field.getContainingClass() != null ? field.getContainingClass().getName() : null;
                if (containingClassName == null) continue;
                s = containingClassName + "." + field.getName();
            }
            if (s == null) {
                s = allowedValue.asSourceString();
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    static double getDoubleAttribute(@NonNull UAnnotation annotation, @NonNull String name, double defaultValue) {
        Double value2 = PermissionRequirement.getAnnotationDoubleValue(annotation, name);
        if (value2 != null) {
            return value2;
        }
        return defaultValue;
    }

    static long getLongAttribute(@NonNull UAnnotation annotation, @NonNull String name, long defaultValue) {
        Long value2 = PermissionRequirement.getAnnotationLongValue(annotation, name);
        if (value2 != null) {
            return value2;
        }
        return defaultValue;
    }

    static boolean getBoolean(@NonNull UAnnotation annotation, @NonNull String name, boolean defaultValue) {
        Boolean value2 = PermissionRequirement.getAnnotationBooleanValue(annotation, name);
        if (value2 != null) {
            return value2;
        }
        return defaultValue;
    }

    @NonNull
    static PsiAnnotation[] filterRelevantAnnotations(@NonNull JavaEvaluator evaluator, @NonNull PsiAnnotation[] annotations2) {
        ArrayList<PsiAnnotation> result = null;
        int length = annotations2.length;
        if (length == 0) {
            return annotations2;
        }
        for (PsiAnnotation annotation : annotations2) {
            PsiElement resolved;
            PsiJavaCodeReferenceElement ref;
            String signature = annotation.getQualifiedName();
            if (signature == null || signature.startsWith("java.")) continue;
            if (signature.startsWith("android.support.annotation.")) {
                if (signature.endsWith(".Nullable") || signature.endsWith(".NonNull")) continue;
                if (length == 1) {
                    return annotations2;
                }
                if (result == null) {
                    result = new ArrayList<PsiAnnotation>(2);
                }
                result.add(annotation);
            }
            if ((ref = annotation.getNameReferenceElement()) == null || !((resolved = ref.resolve()) instanceof PsiClass) || !((PsiClass)resolved).isAnnotationType()) continue;
            PsiClass cls = (PsiClass)resolved;
            PsiAnnotation[] innerAnnotations = evaluator.getAllAnnotations((PsiModifierListOwner)cls);
            for (int j = 0; j < innerAnnotations.length; ++j) {
                PsiAnnotation inner = innerAnnotations[j];
                String a = inner.getQualifiedName();
                if (a == null || a.startsWith("java.") || !a.equals("android.support.annotation.IntDef") && !a.equals(PERMISSION_ANNOTATION) && !a.equals(INT_RANGE_ANNOTATION) && !a.equals("android.support.annotation.StringDef")) continue;
                if (length == 1 && j == innerAnnotations.length - 1 && result == null) {
                    return innerAnnotations;
                }
                if (result == null) {
                    result = new ArrayList(2);
                }
                result.add(inner);
            }
        }
        return result != null ? result.toArray(PsiAnnotation.EMPTY_ARRAY) : PsiAnnotation.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(3);
        types.add(UCallExpression.class);
        types.add(UVariable.class);
        return types;
    }

    @Override
    @Nullable
    public UastVisitor createUastVisitor(@NonNull JavaContext context) {
        return new CallVisitor(context);
    }

    private class CallVisitor
    extends AbstractUastVisitor {
        private final JavaContext mContext;

        public CallVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitCallExpression(UCallExpression call) {
            PsiMethod method = call.resolve();
            if (method != null) {
                this.checkCall(method, call);
            }
            return super.visitCallExpression(call);
        }

        public boolean visitVariable(UVariable node) {
            if (node instanceof UEnumConstant) {
                UEnumConstant constant = (UEnumConstant)node;
                PsiMethod method = constant.resolveMethod();
                this.checkCall(method, (UCallExpression)constant);
            }
            return super.visitVariable(node);
        }

        public void checkCall(PsiMethod method, UCallExpression call) {
            int i;
            List classAnnotations;
            JavaEvaluator evaluator = this.mContext.getEvaluator();
            PsiAnnotation[] annotations2 = evaluator.getAllAnnotations((PsiModifierListOwner)method);
            List methodAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, annotations2));
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null) {
                PsiAnnotation[] annotations3 = evaluator.getAllAnnotations((PsiModifierListOwner)containingClass);
                classAnnotations = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, annotations3));
            } else {
                classAnnotations = Collections.emptyList();
            }
            for (UAnnotation annotation : methodAnnotations) {
                SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, annotation, methodAnnotations, classAnnotations);
            }
            if (!classAnnotations.isEmpty()) {
                for (UAnnotation annotation : classAnnotations) {
                    SupportAnnotationDetector.this.checkMethodAnnotation(this.mContext, method, call, annotation, methodAnnotations, classAnnotations);
                }
            }
            List arguments = call.getValueArguments();
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            List annotations4 = null;
            int n = Math.min(parameters2.length, arguments.size());
            for (i = 0; i < n; ++i) {
                UExpression argument = (UExpression)arguments.get(i);
                PsiParameter parameter = parameters2[i];
                annotations4 = JavaUAnnotation.wrap((PsiAnnotation[])SupportAnnotationDetector.filterRelevantAnnotations(evaluator, evaluator.getAllAnnotations((PsiModifierListOwner)parameter)));
                SupportAnnotationDetector.this.checkParameterAnnotations(this.mContext, argument, call, method, annotations4);
            }
            if (annotations4 != null) {
                for (i = parameters2.length; i < arguments.size(); ++i) {
                    UExpression argument = (UExpression)arguments.get(i);
                    SupportAnnotationDetector.this.checkParameterAnnotations(this.mContext, argument, call, method, annotations4);
                }
            }
        }
    }

    private static class CheckPermissionVisitor
    extends AbstractUastVisitor {
        private boolean mChecksPermission;
        private boolean mDone;
        private final UElement mTarget;

        public CheckPermissionVisitor(@NonNull UElement target) {
            this.mTarget = target;
        }

        public boolean visitElement(UElement node) {
            return this.mDone || super.visitElement(node);
        }

        public boolean visitCallExpression(UCallExpression node) {
            if (UastExpressionUtils.isMethodCall((UElement)node)) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private void visitMethodCallExpression(UCallExpression node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if ((name = node.getMethodName()) != null && (name.startsWith("check") || name.startsWith("enforce")) && name.endsWith("Permission")) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
        }

        public boolean checksPermission() {
            return this.mChecksPermission;
        }
    }
}

