/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram;

import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdgeCreationPolicy;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNodeContentManager;
import com.intellij.diagram.DiagramPresentationModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.DiagramRelationshipManager;
import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.diagram.DiagramVisibilityManager;
import com.intellij.diagram.EmptyDiagramVisibilityManager;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.webflow.diagram.WebflowDiagramDataModel;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.diagram.editor.CreateActionStateElementAction;
import com.intellij.spring.webflow.diagram.editor.CreateDecisionStateElementAction;
import com.intellij.spring.webflow.diagram.editor.CreateEndStateElementAction;
import com.intellij.spring.webflow.diagram.editor.CreateSubflowStateElementAction;
import com.intellij.spring.webflow.diagram.editor.CreateViewStateElementAction;
import com.intellij.spring.webflow.diagram.managers.WebflowDiagramColorManager;
import com.intellij.spring.webflow.diagram.managers.WebflowDiagramElementManager;
import com.intellij.spring.webflow.diagram.managers.WebflowDiagramExtras;
import com.intellij.spring.webflow.diagram.managers.WebflowDiagramVfsResolver;
import com.intellij.spring.webflow.diagram.managers.WebflowNodeContentManager;
import com.intellij.spring.webflow.model.xml.GlobalTransitions;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.TransitionOwner;
import icons.SpringWebflowIcons;
import javax.swing.Icon;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowDiagramProvider
extends DiagramProvider<WebflowElementWrapper> {
    @NonNls
    private static final String ID = "SpringWebFlow";
    private final DiagramVisibilityManager visibilityManager = new EmptyDiagramVisibilityManager();
    private final DiagramNodeContentManager nodeContentManager = new WebflowNodeContentManager();
    private final DiagramElementManager<WebflowElementWrapper> diagramElementManager = new WebflowDiagramElementManager();
    private final DiagramVfsResolver<WebflowElementWrapper> diagramVfsResolver = new WebflowDiagramVfsResolver();
    private final DiagramColorManager diagramColorManager = new WebflowDiagramColorManager();
    private final DiagramExtras<WebflowElementWrapper> diagramExtras = new WebflowDiagramExtras();

    @Pattern(value="[a-zA-Z0-9_-]*")
    public String getID() {
        return ID;
    }

    public DiagramVisibilityManager createVisibilityManager() {
        return this.visibilityManager;
    }

    public DiagramEdgeCreationPolicy<WebflowElementWrapper> getEdgeCreationPolicy() {
        return new DiagramEdgeCreationPolicy<WebflowElementWrapper>(){

            public boolean acceptSource(@NotNull DiagramNode<WebflowElementWrapper> source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/spring/webflow/diagram/WebflowDiagramProvider$1", "acceptSource"));
                }
                Object element = source.getIdentifyingElement();
                return element instanceof WebflowDomElementWrapper && ((WebflowDomElementWrapper)element).getElement() instanceof TransitionOwner && !(((WebflowDomElementWrapper)element).getElement() instanceof GlobalTransitions);
            }

            public boolean acceptTarget(@NotNull DiagramNode<WebflowElementWrapper> target) {
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/webflow/diagram/WebflowDiagramProvider$1", "acceptTarget"));
                }
                Object element = target.getIdentifyingElement();
                return element instanceof WebflowDomElementWrapper && ((WebflowDomElementWrapper)element).getElement() instanceof Identified;
            }
        };
    }

    public DiagramNodeContentManager getNodeContentManager() {
        return this.nodeContentManager;
    }

    public DiagramElementManager<WebflowElementWrapper> getElementManager() {
        return this.diagramElementManager;
    }

    public DiagramVfsResolver<WebflowElementWrapper> getVfsResolver() {
        return this.diagramVfsResolver;
    }

    public DiagramRelationshipManager getRelationshipManager() {
        return DiagramRelationshipManager.NO_RELATIONSHIP_MANAGER;
    }

    public String getPresentableName() {
        return "Spring Web Flow";
    }

    public DiagramDataModel<WebflowElementWrapper> createDataModel(@NotNull Project project, @Nullable WebflowElementWrapper element, @Nullable VirtualFile file, DiagramPresentationModel presentationModel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/webflow/diagram/WebflowDiagramProvider", "createDataModel"));
        }
        return new WebflowDiagramDataModel(project, this, element, presentationModel);
    }

    public Icon getActionIcon(boolean isPopup) {
        return SpringWebflowIcons.SpringWebFlow;
    }

    public String getActionName(boolean isPopup) {
        return !isPopup ? "Spring Web Flow Designer" : "Spring Web Flow Overview";
    }

    public DiagramColorManager getColorManager() {
        return this.diagramColorManager;
    }

    @NotNull
    public DiagramExtras<WebflowElementWrapper> getExtras() {
        DiagramExtras<WebflowElementWrapper> diagramExtras = this.diagramExtras;
        if (diagramExtras == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/diagram/WebflowDiagramProvider", "getExtras"));
        }
        return diagramExtras;
    }

    public DiagramCreateNewElementAction<WebflowElementWrapper, ?>[] getCreateNewActions() {
        return new DiagramCreateNewElementAction[]{new CreateActionStateElementAction(), new CreateDecisionStateElementAction(), new CreateEndStateElementAction(), new CreateSubflowStateElementAction(), new CreateViewStateElementAction()};
    }
}

