/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database;

import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseFamilyId {
    private static final ConcurrentMap<String, DatabaseFamilyId> ourFamilies = ContainerUtil.newConcurrentMap();
    public static final DatabaseFamilyId UNKNOWN = DatabaseFamilyId.create("UNKNOWN");
    public static final DatabaseFamilyId ORACLE = DatabaseFamilyId.create("ORACLE");
    public static final DatabaseFamilyId MYSQL = DatabaseFamilyId.create("MYSQL");
    public static final DatabaseFamilyId POSTGRES = DatabaseFamilyId.create("POSTGRES");
    public static final DatabaseFamilyId MSSQL = DatabaseFamilyId.create("MSSQL");
    public static final DatabaseFamilyId SYBASE = DatabaseFamilyId.create("SYBASE");
    public static final DatabaseFamilyId DB2 = DatabaseFamilyId.create("DB2");
    public static final DatabaseFamilyId SQLITE = DatabaseFamilyId.create("SQLITE");
    public static final DatabaseFamilyId HSQLDB = DatabaseFamilyId.create("HSQLDB");
    public static final DatabaseFamilyId H2 = DatabaseFamilyId.create("H2");
    public static final DatabaseFamilyId DERBY = DatabaseFamilyId.create("DERBY");
    public static final DatabaseFamilyId MARIADB = DatabaseFamilyId.create("MARIADB");
    public static final DatabaseFamilyId REDSHIFT = DatabaseFamilyId.create("REDSHIFT");
    public static final DatabaseFamilyId VERTICA = DatabaseFamilyId.create("VERTICA");
    public static final DatabaseFamilyId PRESTO = DatabaseFamilyId.create("PRESTO");
    public static final DatabaseFamilyId INFORMIX = DatabaseFamilyId.create("INFORMIX");
    public static final DatabaseFamilyId IMPALA = DatabaseFamilyId.create("IMPALA");
    public static final DatabaseFamilyId NETEZZA = DatabaseFamilyId.create("NETEZZA");
    public static final DatabaseFamilyId PHOENIX = DatabaseFamilyId.create("PHOENIX");
    public static final DatabaseFamilyId HIVE = DatabaseFamilyId.create("HIVE");
    public static final DatabaseFamilyId SNOWFLAKE = DatabaseFamilyId.create("SNOWFLAKE");
    public static final DatabaseFamilyId INGRES = DatabaseFamilyId.create("INGRES");
    public static final DatabaseFamilyId TERADATA = DatabaseFamilyId.create("TERADATA");
    public static final DatabaseFamilyId OPENEDGE = DatabaseFamilyId.create("OPENEDGE");
    public static final DatabaseFamilyId TIBERO = DatabaseFamilyId.create("TIBERO");
    public static final DatabaseFamilyId FILEMAKER = DatabaseFamilyId.create("FILEMAKER");
    private final String myName;

    @NotNull
    public static DatabaseFamilyId create(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/DatabaseFamilyId", "create"));
        }
        DatabaseFamilyId existing = (DatabaseFamilyId)ourFamilies.get(name);
        if (existing != null) {
            DatabaseFamilyId databaseFamilyId = existing;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "create"));
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = (DatabaseFamilyId)ConcurrencyUtil.cacheOrGet(ourFamilies, (Object)name, (Object)new DatabaseFamilyId(name));
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "create"));
        }
        return databaseFamilyId;
    }

    private DatabaseFamilyId(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/DatabaseFamilyId", "<init>"));
        }
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "getName"));
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isOracle() {
        return this == ORACLE;
    }

    public boolean isMysql() {
        return this == MYSQL || this == MARIADB;
    }

    public boolean isPostgres() {
        return this == POSTGRES || this == REDSHIFT;
    }

    public boolean isMicrosoft() {
        return this == MSSQL;
    }

    public boolean isSybase() {
        return this == SYBASE;
    }

    public boolean isDb2() {
        return this == DB2;
    }

    public boolean isHsqldb() {
        return this == HSQLDB;
    }

    public boolean isH2() {
        return this == H2;
    }

    public boolean isDerby() {
        return this == DERBY;
    }

    public boolean isSqlite() {
        return this == SQLITE;
    }

    public boolean isTransactSql() {
        return this.isMicrosoft() || this.isSybase();
    }

    @NotNull
    public static DatabaseFamilyId forDataSource(@NotNull DatabaseSystem o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/DatabaseFamilyId", "forDataSource"));
        }
        DatabaseFamilyId result = DatabaseFamilyId.fromString(o.getDatabaseProductName());
        if (result != UNKNOWN) {
            DatabaseFamilyId databaseFamilyId = result;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forDataSource"));
            }
            return databaseFamilyId;
        }
        if (o instanceof RawConnectionConfig) {
            result = DatabaseFamilyId.forConnection((RawConnectionConfig)((Object)o));
        }
        DatabaseFamilyId databaseFamilyId = result;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forDataSource"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId forConnection(@Nullable RawConnectionConfig o) {
        if (o == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forConnection"));
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId result = DatabaseFamilyId.fromString(o.getUrl());
        if (result != UNKNOWN) {
            DatabaseFamilyId databaseFamilyId = result;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forConnection"));
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.fromString(o.getDriverClass());
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "forConnection"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public static DatabaseFamilyId fromString(@Nullable String text) {
        if (text == null) {
            DatabaseFamilyId databaseFamilyId = UNKNOWN;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        String pattern = "(?i).*(?:%s).*";
        for (DatabaseFamilyId family : ourFamilies.values()) {
            if (!text.matches(String.format(pattern, family.getName()))) continue;
            DatabaseFamilyId databaseFamilyId = family;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "hsql"))) {
            DatabaseFamilyId databaseFamilyId = HSQLDB;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "microsoft|sqlserver"))) {
            DatabaseFamilyId databaseFamilyId = MSSQL;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (text.matches(String.format(pattern, "adaptive server")) || text.startsWith("ase")) {
            DatabaseFamilyId databaseFamilyId = SYBASE;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        if (text.startsWith("ids")) {
            DatabaseFamilyId databaseFamilyId = INFORMIX;
            if (databaseFamilyId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
            }
            return databaseFamilyId;
        }
        DatabaseFamilyId databaseFamilyId = UNKNOWN;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/DatabaseFamilyId", "fromString"));
        }
        return databaseFamilyId;
    }
}

